/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;

public class CasaDeMarkatLogger {
    private PrintWriter simpleLogWriter;
    private PrintWriter debugLogWriter;

    public CasaDeMarkatLogger(String simpleLogFilename, String debugLogFilename) {
        this.simpleLogWriter = this.initializeLoggingFile(simpleLogFilename);
        this.debugLogWriter = this.initializeLoggingFile(debugLogFilename);
    }

    private PrintWriter initializeLoggingFile(String filename) {
        PrintWriter writer = null;
        try {
            if (filename != null) {
                File log_file = new File(filename);
                if (!log_file.exists()) {
                    log_file.createNewFile();
                    writer = new PrintWriter(new FileWriter(log_file, true));
                } else {
                    writer = log_file.length() / 1024L / 1024L > 500L ? new PrintWriter(new FileWriter(log_file, false)) : new PrintWriter(new FileWriter(log_file, true));
                }
                writer = new PrintWriter(new FileWriter(log_file, true));
                writer.append("1234\r\n\r\n\r\n***********************************START OF THE NEW DAY***********************************\r\n" + new Date().toString() + "\r\n" + "******************************************************************************************\r\n");
                writer.flush();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return writer;
    }

    public void log(String s) {
        try {
            if (this.simpleLogWriter != null) {
                this.simpleLogWriter.append(s);
                this.simpleLogWriter.flush();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void debug(String s) {
        try {
            if (this.debugLogWriter != null) {
                this.debugLogWriter.append(s);
                this.debugLogWriter.flush();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void debug(Throwable exception) {
        try {
            if (this.debugLogWriter != null) {
                exception.printStackTrace(this.debugLogWriter);
                this.debugLogWriter.flush();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void closeLogger() {
        try {
            if (this.simpleLogWriter != null) {
                try {
                    this.simpleLogWriter.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.debugLogWriter != null) {
                try {
                    this.debugLogWriter.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

