/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.newecr;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import purejavacomm.SerialPort;
import ro.atreides.ecr_online_native.database.TransfersInterface;
import ro.atreides.ecr_online_native.newecr.ECR;
import ro.atreides.ecr_online_native.newecr.online.Constants;
import ro.atreides.ecr_online_native.newecr.online_event.ListenerImpl;
import ro.atreides.ecr_online_native.newecr.online_event.ReaderImpl;
import ro.atreides.ecr_online_native.newecr.online_event.Writer;
import ro.atreides.utils.Logger;

public class MP55Online
extends ECR {
    private TransfersInterface transfers;
    private boolean running = true;
    private String serial;

    public MP55Online(String portName, int speed, TransfersInterface transfers) throws Exception {
        super(portName, speed);
        this.transfers = transfers;
        super.start();
    }

    @Override
    public void closeAll() {
        this.running = false;
        super.closeAll();
    }

    @Override
    protected void startThread(InputStream in, OutputStream out, SerialPort port) {
        final Writer writer = new Writer(out);
        final ReaderImpl reader = new ReaderImpl(in, port);
        ListenerImpl listener = new ListenerImpl(writer){

            @Override
            public TransfersInterface transfers() {
                return MP55Online.this.transfers;
            }

            @Override
            public void arrivedSerial(String serial) {
                MP55Online.this.updateSerial(serial);
            }
        };
        reader.setListener(listener);
        new Thread(){

            @Override
            public void run() {
                2.yield();
                while (MP55Online.this.running) {
                    writer.writetoport(Constants.TAKE_MESSAGE);
                    try {
                        reader.read(50);
                    }
                    catch (IOException e) {
                        Logger.logException(this, (Exception)e);
                    }
                }
            }
        }.start();
    }

    public void updateSerial(String serial) {
        this.serial = serial;
    }

    public boolean isRunning() {
        return this.running;
    }

    public String getSerial() {
        return this.serial;
    }
}

