/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.newecr.gui;

import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;

public abstract class AbstractListPanelImpl
extends AbstractListPanel {
    private boolean initialized = false;

    public AbstractListPanelImpl() {
        this.doStuff();
    }

    @Override
    public final AbstractTM buildTableModel() {
        return new AbstractTM(this.buildColumns(), this.buildTypes(), this.buildTmIntereface());
    }

    @Override
    public final void doStuff() {
        if (!this.initialized) {
            this.initialized = true;
            this.display();
            MouseListener me = this.buildMouseListener();
            if (me != null) {
                this.table.addMouseListener(me);
            }
        }
    }

    @Override
    public final JPanel getBottomPanel() {
        return this.buildBottomPanel();
    }

    protected MouseListener buildMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent e) {
                int selRow = AbstractListPanelImpl.this.table.rowAtPoint(e.getPoint());
                if (selRow != -1 && e.isPopupTrigger()) {
                    AbstractListPanelImpl.this.table.setRowSelectionInterval(selRow, selRow);
                    JPopupMenu popup = AbstractListPanelImpl.this.getPopup(AbstractListPanelImpl.this.tm.getData().get(selRow));
                    if (popup != null) {
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int selRow = AbstractListPanelImpl.this.table.rowAtPoint(e.getPoint());
                if (selRow != -1 && e.getButton() == 1 && e.getClickCount() == 2) {
                    AbstractListPanelImpl.this.doubleClick(AbstractListPanelImpl.this.tm.getData().get(selRow));
                }
            }
        };
    }

    @Override
    public abstract String[] buildColumns();

    @Override
    public abstract Class[] buildTypes();

    @Override
    public abstract Vector buildData();

    public abstract TmInterface buildTmIntereface();

    public abstract JPanel buildBottomPanel();

    public abstract JPopupMenu getPopup(Object var1);

    public abstract void doubleClick(Object var1);

    public void selectRows(int first, int last) {
        if (first > -1 && last > -1) {
            try {
                this.table.scrollRectToVisible(AbstractListPanelImpl.getRowBounds(this.table, first, last));
                this.table.setRowSelectionInterval(first, last);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static Rectangle getRowBounds(JTable table, int first, int last) {
        AbstractListPanelImpl.checkRows(table, first, last);
        Rectangle result = table.getCellRect(first, -1, true);
        result = result.union(table.getCellRect(last, -1, true));
        Insets i = table.getInsets();
        result.x = i.left;
        result.width = table.getWidth() - i.left - i.right;
        return result;
    }

    private static void checkRows(JTable table, int first, int last) {
        if (first < 0) {
            throw new IndexOutOfBoundsException(first + " < 0");
        }
        if (first > last) {
            throw new IndexOutOfBoundsException(first + " > " + last);
        }
        if (last >= table.getRowCount()) {
            throw new IndexOutOfBoundsException(last + " >= " + table.getRowCount());
        }
    }
}

