/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.newecr.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import ro.atreides.ecr_online_native.newecr.gui.AddDialog;
import ro.atreides.ecr_online_native.newecr.gui.Casa;
import ro.atreides.ecr_online_native.newecr.gui.Config;
import ro.atreides.ecr_online_native.newecr.gui.License;
import ro.atreides.ecr_online_native.newecr.gui.PasswordManager;
import ro.atreides.ecr_online_native.newecr.gui.Products;
import ro.atreides.ecr_online_native.newecr.gui.SimpleListPanel;
import ro.atreides.ecr_online_native.newecr.online.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.table.AbstractListPanel;

public class CasaPanel
extends JPanel {
    private AbstractListPanel listpanel;
    public static final String YES_TEXT = "<html><font size=3 color=green><b>YES</font></html>";
    public static final String NO_TEXT = "<html><font size=3 color=red><b>NO</font></html>";

    public CasaPanel() {
        this.init();
        this.display();
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    CasaPanel.this.updateSerie();
                    Utils.sleep(1000);
                }
            }
        }.start();
    }

    private void init() {
        this.listpanel = new SimpleListPanel(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Casa casa = (Casa)data.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return casa.getSeria();
                    }
                    case 1: {
                        return casa.getPort();
                    }
                    case 2: {
                        return casa.getSpeed();
                    }
                    case 3: {
                        String seria = casa.getSeria();
                        return casa.isRuning() ? (Validators.correctString(seria) ? (License.getInstance().isLicensed(casa.getSeria()) ? CasaPanel.YES_TEXT : CasaPanel.NO_TEXT) : "?") : "?";
                    }
                    case 4: {
                        return casa.isRuning();
                    }
                }
                return "null";
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                Casa casa = (Casa)data.get(rowIndex);
                if (casa.isRuning()) {
                    casa.stop();
                    CasaPanel.this.updateSerie();
                } else {
                    casa.start();
                    CasaPanel.this.updateSerie();
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 4;
            }

            @Override
            public String[] buildColumns() {
                return new String[]{"Serial", "Port name", "Speed", "Licensed", "On/Off"};
            }

            @Override
            public Class[] buildTypes() {
                return new Class[]{String.class, String.class, String.class, String.class, Boolean.class};
            }

            @Override
            public Vector buildData() {
                this.clear();
                return new Vector();
            }

            @Override
            public JPanel buildBottomPanel() {
                JButton adaugare = new JButton("Add ECR");
                adaugare.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Casa casa;
                        AddDialog add = new AddDialog(this.getTm().getData(), (JFrame)SwingUtilities.getRoot(CasaPanel.this));
                        if (add.succces() && (casa = add.getCasa()) != null) {
                            this.getTm().getData().add(casa);
                            ((AbstractTableModel)this.getJTable().getModel()).fireTableDataChanged();
                        }
                    }
                });
                adaugare.setMnemonic('A');
                JButton golire = new JButton("Clear");
                golire.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.clear();
                    }
                });
                golire.setMnemonic('C');
                JButton detect = new JButton("Detect");
                detect.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.clear();
                        Vector detected = Utils.detect(CasaPanel.this);
                        this.getTm().refresh(detected);
                    }
                });
                detect.setMnemonic('D');
                JButton salvare = new JButton("Save");
                salvare.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (PasswordManager.getInstance().hasPermission(CasaPanel.this.getFrame())) {
                            Config.saveCase(this.getTm().getData());
                        }
                    }
                });
                salvare.setMnemonic('S');
                JButton reincarca = new JButton("Reload");
                reincarca.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.clear();
                        this.getTm().refresh(Config.getCase());
                        License.getInstance().reload();
                        Products.getInstance().reload();
                    }
                });
                reincarca.setMnemonic('R');
                JPanel result = new JPanel(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 0;
                c.anchor = 10;
                c.weightx = 0.0;
                c.weighty = 1.0;
                c.insets = new Insets(5, 5, 5, 5);
                c.gridx = 0;
                c.gridy = 0;
                result.add((Component)adaugare, c);
                ++c.gridx;
                result.add((Component)detect, c);
                ++c.gridx;
                c.weightx = 1.0;
                c.anchor = 21;
                result.add((Component)golire, c);
                c.weightx = 0.0;
                c.anchor = 10;
                ++c.gridx;
                result.add((Component)salvare, c);
                ++c.gridx;
                result.add((Component)reincarca, c);
                return result;
            }

            @Override
            public JPopupMenu getPopup(Object o) {
                JPopupMenu popup = new JPopupMenu();
                Casa casa = (Casa)o;
                final String seria = casa.getSeria();
                JMenuItem reincarca = new JMenuItem("Reload products");
                reincarca.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Products.getInstance().reload(seria);
                    }
                });
                popup.add(reincarca);
                return popup.getComponentCount() == 0 ? null : popup;
            }

            @Override
            public void doubleClick(Object o) {
            }

            private void clear() {
                for (Casa casa : this.getTm().getData()) {
                    casa.stop();
                }
                this.getTm().refresh(new Vector());
            }
        };
        this.listpanel.getTm().refresh(Config.getCase());
        License.getInstance().reload();
    }

    private void updateSerie() {
        if (this.listpanel != null) {
            AbstractTableModel model = (AbstractTableModel)this.listpanel.getJTable().getModel();
            int length = this.listpanel.getTm().getData().size();
            for (int i = 0; i < length; ++i) {
                model.fireTableCellUpdated(i, 0);
                model.fireTableCellUpdated(i, 4);
            }
        }
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.listpanel, c);
    }

    public JFrame getFrame() {
        return (JFrame)SwingUtilities.getRoot(this);
    }
}

