/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.newecr.gui;

import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecr_online_native.newecr.gui.Casa;
import ro.atreides.ecr_online_native.newecr.gui.License;
import ro.atreides.ecr_online_native.newecr.gui.LicenseView;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public class Config {
    private static final String CONFIG_FILE = "config.txt";
    private static final String LICENSE_FILE = "licenses.txt";
    private static final String CASE_KEY = "ecrs";
    public static final String DEFAULT_PRODUSE_XML = "products.xml";
    private static final String VANZARI_KEY = "sells";
    private static final String DEFAULT_VANZARI_DIR = "sells";
    private static final String USE_PASSWORD_KEY = "usepassword";
    private static final String DEFAULT_PASSWORD = "poweruser";
    public static final String LOG_PROTOCOL__FILENAME = "protocol.log";
    public static final String LOG_ERROR__FILENAME = "error.log";
    public static final String LOGS_ZIP_TO_SEND = "logs.zip";
    private static final String MAIL_SERVER_KEY = "mailserver";
    private static final String MAIL_TO_KEY = "mailto";
    private static final String DEFAULT_MAIL_SERVER = "www.atreides.ro";
    private static final String DEFAULT_MAIL_TO = "andrei@atreides.ro";
    private static final String GMAIL_USERNAME = "atreides.support";
    private static final String GMAIL_PASSWORD = "atreides1234";
    public static final String BACKUP_DIR = "backup";

    public static void saveCase(Vector v) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            Casa casa = (Casa)iter.next();
            buffer.append(casa.getPort());
            buffer.append(",");
            buffer.append(casa.isRuning() ? 1 : 0);
            buffer.append(",");
            buffer.append(casa.getSpeed());
            if (!iter.hasNext()) continue;
            buffer.append(";");
        }
        ro.atreides.ecr_online_native.newecr.online.Utils.save(CASE_KEY, buffer.toString());
    }

    public static Vector getCase() {
        Vector<Casa> result = new Vector<Casa>();
        Vector all = ro.atreides.ecr_online_native.newecr.online.Utils.getCase();
        String value = ro.atreides.ecr_online_native.newecr.online.Utils.load(CASE_KEY);
        if (Validators.correctString(value)) {
            Vector caseItems = Utils.splitString(value, ';');
            for (int i = 0; i < caseItems.size(); ++i) {
                String s = (String)caseItems.elementAt(i);
                Vector values = Utils.splitString(s, ',');
                String port = (String)values.get(0);
                String onS = (String)values.get(1);
                boolean on = onS.equals("1");
                String speedS = (String)values.get(2);
                int speed = Integer.parseInt(speedS);
                Casa casa = new Casa();
                casa.setPort(port);
                casa.setSpeed(speed);
                if (on) {
                    casa.start();
                }
                result.add(casa);
            }
        }
        return result;
    }

    public static void setVanzariDir(File f) {
        if (f.exists() && f.isDirectory()) {
            String currentPath = new File(FileUtils.getCurrentDir()).getAbsolutePath();
            String result = f.getAbsolutePath();
            if (result.startsWith(currentPath) && (result = result.replace(currentPath, "")).startsWith(File.separator)) {
                result = result.replaceFirst(File.separator, "");
            }
            ro.atreides.ecr_online_native.newecr.online.Utils.save("sells", result);
        }
    }

    public static String getVanzariDir() {
        String result = "sells";
        String value = ro.atreides.ecr_online_native.newecr.online.Utils.load("sells");
        if (Validators.correctString(value)) {
            result = value;
        }
        return result;
    }

    public static String getVanzariDirFor(String serieCasa) {
        return Config.getVanzariDir() + File.separator + serieCasa;
    }

    public static String getProduseXmlFor(String serieCasa) {
        String result = DEFAULT_PRODUSE_XML;
        String value = ro.atreides.ecr_online_native.newecr.online.Utils.load(serieCasa);
        if (Validators.correctString(value)) {
            result = value;
        }
        return result;
    }

    public static String getLicenseFor(String serial) {
        return ro.atreides.ecr_online_native.newecr.online.Utils.load(serial, LICENSE_FILE);
    }

    public static void setLicenseFor(String serial, String license) {
        ro.atreides.ecr_online_native.newecr.online.Utils.save(serial, license, LICENSE_FILE);
    }

    public static Vector getSerialsInLicenseFile() {
        Vector<String> result = new Vector<String>();
        Properties props = ro.atreides.ecr_online_native.newecr.online.Utils.loadConfiguration(LICENSE_FILE);
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            String serieCasa = (String)en.nextElement();
            result.add(serieCasa);
        }
        return result;
    }

    public static Vector getLicenses() {
        Vector<LicenseView> result = new Vector<LicenseView>();
        Properties props = ro.atreides.ecr_online_native.newecr.online.Utils.loadConfiguration(LICENSE_FILE);
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            String seria = (String)en.nextElement();
            String license = props.getProperty(seria);
            if (!License.isLicensed(license, seria)) continue;
            LicenseView view = new LicenseView();
            view.setSeria(seria);
            view.setLicense(license);
            result.add(view);
        }
        return result;
    }

    public static String getPassword() {
        return DEFAULT_PASSWORD;
    }

    public static boolean usePassword() {
        return true;
    }

    public static String getMailServer() {
        String result = DEFAULT_MAIL_SERVER;
        String value = ro.atreides.ecr_online_native.newecr.online.Utils.load(MAIL_SERVER_KEY);
        if (Validators.correctString(value)) {
            result = value;
        }
        return result;
    }

    public static String getMailTo() {
        String result = DEFAULT_MAIL_TO;
        String value = ro.atreides.ecr_online_native.newecr.online.Utils.load(MAIL_TO_KEY);
        if (Validators.correctString(value)) {
            result = value;
        }
        return result;
    }

    public static String getGmailUsername() {
        return GMAIL_USERNAME;
    }

    public static String getGmailPassword() {
        return GMAIL_PASSWORD;
    }
}

