/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.newecr.gui;

import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MailUtils {
    public static void sendMail(String server, String from, String[] to, String subject, String message, String[] attachFiles) throws MessagingException {
        MailUtils.sendMail(null, null, server, from, to, subject, message, attachFiles);
    }

    public static void sendMail(Properties props, Session session, String server, String from, String[] to, String subject, String message, String[] attachFiles) throws MessagingException {
        boolean debug = false;
        if (props == null) {
            props = new Properties();
        }
        props.put("mail.smtp.host", server);
        if (session == null) {
            session = Session.getDefaultInstance((Properties)props, null);
        }
        session.setDebug(debug);
        MimeMessage msg = new MimeMessage(session);
        msg.setSubject(subject);
        msg.setFrom((Address)new InternetAddress(from));
        InternetAddress[] addressTo = new InternetAddress[to.length];
        for (int i = 0; i < to.length; ++i) {
            addressTo[i] = new InternetAddress(to[i]);
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
        MimeBodyPart bodyMessage = new MimeBodyPart();
        bodyMessage.setText(message);
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)bodyMessage);
        if (attachFiles != null) {
            for (int i = 0; i < attachFiles.length; ++i) {
                String file = attachFiles[i];
                MimeBodyPart bodyAttachment = new MimeBodyPart();
                bodyAttachment.setDataHandler(new DataHandler((DataSource)new FileDataSource(file)));
                bodyAttachment.setFileName(file);
                multipart.addBodyPart((BodyPart)bodyAttachment);
            }
        }
        msg.setContent((Multipart)multipart);
        Transport.send((Message)msg);
    }

    public static void sendMailGoogleSMTP(final String username, final String password, String from, String[] to, String subject, String message, String[] attachFiles) throws MessagingException {
        Properties props = new Properties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.auth", "true");
        Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        });
        MailUtils.sendMail(props, session, "smtp.gmail.com", from, to, subject, message, attachFiles);
    }

    public static void sendMailGoogleSMTP(String username, String password, String from, String to, String subject, String message, String[] attachFiles) throws MessagingException {
        MailUtils.sendMailGoogleSMTP(username, password, from, new String[]{to}, subject, message, attachFiles);
    }

    public static void sendMail(String server, String from, String to, String subject, String message, String[] attachFiles) throws MessagingException {
        MailUtils.sendMail(server, from, new String[]{to}, subject, message, attachFiles);
    }

    public static void sendMail(String server, String from, String to, String subject, String message, String attachFile) throws MessagingException {
        MailUtils.sendMail(server, from, to, subject, message, new String[]{attachFile});
    }

    public static void sendMail(String server, String from, String[] to, String subject, String message) throws MessagingException {
        MailUtils.sendMail(server, from, to, subject, message, null);
    }

    public static void sendMail(String server, String from, String to, String subject, String message) throws MessagingException {
        MailUtils.sendMail(server, from, new String[]{to}, subject, message);
    }

    public static void main(String[] args) {
        try {
            MailUtils.sendMailGoogleSMTP("atreides.support", "atreides1234", "support_ecr_online@atreides.ro", new String[]{"atreides.support@gmail.com"}, "support ecr_online", "Hello!", null);
            MailUtils.sendMailGoogleSMTP("atreides.support", "atreides1234", "support_ecr_online@atreides.ro", new String[]{"atreides.support@gmail.com"}, "support ecr_online", "Hello2!", null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

