/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.newecr.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import ro.atreides.ecr_online_native.newecr.gui.Config;
import ro.atreides.utils.gui.GenericDialog;
import ro.atreides.utils.gui.dialogs.DialogUtils;

class PassDialog {
    private String passText;
    private boolean correct;
    private JFrame frame;

    public PassDialog(JFrame frame) {
        this.frame = frame;
    }

    private boolean buildPanel(String text, String title) {
        JPanel result = new JPanel(new GridBagLayout());
        final JPasswordField passField = new JPasswordField(10);
        JButton ok = new JButton("OK");
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(3, 3, 3, 3);
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel(text), c);
        ++c.gridx;
        result.add((Component)passField, c);
        ++c.gridx;
        result.add((Component)ok, c);
        final JDialog dialog = GenericDialog.getDialog(true, result, this.frame, title);
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PassDialog.this.passText = new String(passField.getPassword());
                String s = Config.getPassword();
                if (PassDialog.this.passText.equals(s)) {
                    PassDialog.this.correct = true;
                } else {
                    DialogUtils.errorDialog(PassDialog.this.frame, "Password incorrect", "Error");
                }
                dialog.dispose();
            }
        };
        ok.addActionListener(action);
        passField.addActionListener(action);
        dialog.setVisible(true);
        return false;
    }

    public boolean correct(String text, String title) {
        this.buildPanel(text, title);
        return this.correct;
    }

    public String getPassword(String text, String title) {
        this.buildPanel(text, title);
        return this.passText;
    }
}

