/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.newecr.gui;

import java.io.File;
import java.util.Hashtable;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr_online_native.database.ProductData;
import ro.atreides.ecr_online_native.newecr.gui.Config;
import ro.atreides.ecr_online_native.newecr.gui.License;
import ro.atreides.ecr_online_native.newecr.gui.MainPanel;
import ro.atreides.ecr_online_native.newecr.gui.ProductsXmlHandler;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;

public class Products {
    private static Products instance;
    private Hashtable caseSerials = new Hashtable();
    private License licenseManager = License.getInstance();

    public static synchronized Products getInstance() {
        if (instance == null) {
            instance = new Products();
        }
        return instance;
    }

    public ProductData getProductForCode(String code, String serial) {
        ProductData result = null;
        Hashtable products = this.getProductsForCasa(serial);
        boolean licensed = this.licenseManager.isLicensed(serial);
        result = licensed ? (ProductData)products.get(code) : (ProductData)products.get("#" + code);
        return result;
    }

    private Hashtable getProductsForCasa(String serial) {
        Hashtable result = (Hashtable)this.caseSerials.get(serial);
        if (result == null) {
            this.loadProducts(serial);
            result = this.getProductsForCasa(serial);
        }
        return result;
    }

    private void loadProducts(String serial) {
        Hashtable products = null;
        try {
            ProductsXmlHandler handler = new ProductsXmlHandler();
            String xml = Config.getProduseXmlFor(serial);
            File produseFile = new File(xml);
            if (produseFile.exists()) {
                Utils.importXml((DefaultHandler)handler, xml);
                products = handler.getProducts();
            } else {
                DialogUtils.errorDialog(MainPanel.getInstance(), "file '" + xml + "' doesn't exist", "ERROR");
            }
        }
        catch (Throwable e) {
            Logger.logError((Object)this, e);
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Fisier products.xml incorect. Programul se va inchide", "Eroare Fatala");
            Utils.systemExit();
        }
        this.caseSerials.put(serial, products == null ? new Hashtable() : products);
    }

    public void reload() {
        this.caseSerials.clear();
    }

    public void reload(String seria) {
        this.loadProducts(seria);
    }
}

