/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.newecr.gui;

import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr_online_native.database.ProductData;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;

public class ProductsXmlHandler
extends DefaultHandler {
    private Hashtable products = new Hashtable();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("product")) {
            String code = attributes.getValue("code");
            String name = attributes.getValue("name").toUpperCase();
            double price = Utils.parseDouble(attributes.getValue("price"));
            int departament = Integer.parseInt(attributes.getValue("department"));
            int group = Integer.parseInt(attributes.getValue("group"));
            int tvaGroup = Integer.parseInt(attributes.getValue("tvagroup"));
            ProductData produs = new ProductData();
            produs.setProductCode(code);
            produs.setName(name);
            produs.setPriceAsFloat(price);
            produs.setQuantityAsInt(1000);
            produs.setDepartamentAsInt(departament);
            produs.setGroupAsInt(group);
            produs.setTvaGroupAsInt(tvaGroup);
            this.products.put(code, produs);
            ProductData not_licensed = produs.clone();
            not_licensed.setName("PRODUS" + this.products.size());
            this.products.put("#" + code, not_licensed);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        Logger.logException(this, (Exception)ex);
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        Logger.logException(this, (Exception)ex);
    }

    public Hashtable getProducts() {
        return this.products;
    }
}

