/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.newecr.gui;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import ro.atreides.ecr_online_native.newecr.gui.Bon;
import ro.atreides.ecr_online_native.newecr.gui.Config;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;

public class Vanzari {
    public void save(Bon bon, String serial, int nrBon, int nrZ) {
        File f = new File(Config.getVanzariDirFor(serial));
        if (!f.exists()) {
            f.mkdirs();
        }
        String filename = this.getZDir(f, nrZ) + File.separator + this.getDate() + "_" + this.nrBonToString(nrBon) + ".xml";
        System.out.println("filename = " + filename);
        try {
            FileUtils.writeTextToFile(filename, bon.toXml());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveCSV(Bon bon, String serial, int nrBon, int nrZ) {
        File f = new File(Config.getVanzariDirFor(serial));
        if (!f.exists()) {
            f.mkdirs();
        }
        String filename = f.getAbsolutePath() + File.separator + "receipts.txt";
        try {
            FileUtils.appendTextToFileWithLocking(filename, bon.toCSV());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getDate() {
        return Formatters.currentDateAndTimeForFileSystem.format(new Date());
    }

    private String getZDir(File f, int nrZ) {
        File temp;
        String zString = this.nrZtoString(nrZ);
        String result = null;
        File[] files = f.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file1 = files[i];
            if (!file1.getName().endsWith(zString)) continue;
            result = file1.getAbsolutePath();
        }
        if (result == null && !(temp = new File(result = f.getAbsolutePath() + File.separator + this.getDate() + "_" + zString)).exists()) {
            temp.mkdirs();
        }
        return result;
    }

    private String nrBonToString(int nrBon) {
        String s = Integer.toString(nrBon);
        int zerosToAdd = 4 - s.length();
        switch (zerosToAdd) {
            case 1: {
                s = "0" + s;
                break;
            }
            case 2: {
                s = "00" + s;
                break;
            }
            case 3: {
                s = "000" + s;
                break;
            }
            case 4: {
                s = "0000" + s;
            }
        }
        return s;
    }

    private String nrZtoString(int nrZ) {
        String s = Integer.toString(nrZ);
        int zerosToAdd = 5 - s.length();
        switch (zerosToAdd) {
            case 1: {
                s = "0" + s;
                break;
            }
            case 2: {
                s = "00" + s;
                break;
            }
            case 3: {
                s = "000" + s;
                break;
            }
            case 4: {
                s = "0000" + s;
                break;
            }
            case 5: {
                s = "00000" + s;
            }
        }
        return s;
    }
}

