/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecronline.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ro.atreides.utils.db.DaoInterface;

public class EcrOnlineDao
implements DaoInterface {
    private Connection connection;
    private PreparedStatement insertBonFiscal;
    private PreparedStatement searchBon;
    private PreparedStatement getMaxBon;

    public Connection getConnection() {
        return this.connection;
    }

    public EcrOnlineDao(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.insertBonFiscal = this.connection.prepareStatement("insert into ecr_online_bons ( bon ) values ( ? )");
        this.searchBon = this.connection.prepareStatement("select * from ecr_online_bons where bon = ?");
        this.getMaxBon = this.connection.prepareStatement("select max(bon) from ecr_online_bons");
    }

    public String getMaxBon() throws SQLException {
        String result = null;
        ResultSet rs = this.getMaxBon.executeQuery();
        if (rs.next()) {
            result = rs.getString(1);
        }
        rs.close();
        return result;
    }

    public void addBon(String bon) throws SQLException {
        this.insertBonFiscal.setString(1, bon);
        this.insertBonFiscal.execute();
    }

    public boolean isBonEntered(String bon) throws SQLException {
        this.searchBon.setString(1, bon);
        ResultSet rs = this.searchBon.executeQuery();
        boolean result = false;
        if (rs.next()) {
            result = true;
        }
        rs.close();
        return result;
    }
}

