/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.facturi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.facturi.AgedDebtorsEntry;
import ro.atreides.facturi.FacturatEntry;
import ro.atreides.facturi.FacturiEmiseView;
import ro.atreides.facturi.IncasareDetaliataEntry;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.FacturiNeplatiteEntry;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.facturi.FacturaItem;

public class FacturiDao
implements DaoInterface {
    private Connection connection;
    private PreparedStatement addFactura;
    private PreparedStatement selectLastFacturaNumber;
    private PreparedStatement updateTotalPtFactura;
    private PreparedStatement selectFacturi;
    private PreparedStatement addFacturaItem;
    private PreparedStatement selectFacturaItems;
    private PreparedStatement updateFactura;
    private PreparedStatement deleteItemsForFactura;
    private PreparedStatement deleteFactura;
    private PreparedStatement getFacturiNeplatitePtClient;
    private PreparedStatement getDetaliiPlataForFactura;
    private PreparedStatement getTotalFacturatForClients;
    private PreparedStatement getTotalFacturatForClientsCategories;
    private PreparedStatement setStatusForFactura;
    private PreparedStatement addOrderIdToFactura;
    private PreparedStatement getOrderIdsForFactura;
    private PreparedStatement linkFacturaFileToFactura;
    private PreparedStatement getIdFileByIdFactura;
    private PreparedStatement getIdDocumentForComandaFerma;
    private PreparedStatement deleteItemsByid;

    public Connection getConnection() {
        return this.connection;
    }

    public FacturiDao(Connection connection) throws SQLException {
        this.connection = connection;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.setStatusForFactura = this.connection.prepareStatement("update facturi_emise set status_factura = ? where id = ?");
        this.getTotalFacturatForClientsCategories = this.connection.prepareStatement("select sum(facturi_emise_items.sell_price * facturi_emise_items.quantity) as total_cu_tva, sum(facturi_emise_items.sell_price_fara_tva * facturi_emise_items.quantity) as total_fara_tva, sum(facturi_emise_items.valoare_tva * facturi_emise_items.quantity) as total_tva, id_client from facturi_emise inner join facturi_emise_items on facturi_emise.id = facturi_emise_items.id_factura inner join products on facturi_emise_items.id_product = products.id where facturi_emise.status = 1 and facturi_emise.dateadd >= ? and facturi_emise.dateadd < ? and (products.id_subcategory = ? OR ? = -1 ) group by id_client");
        this.getTotalFacturatForClients = this.connection.prepareStatement("select sum(total_general), id_client from facturi_emise where status_factura in (2, 3, 4) and status = 1 and dateadd >= ? and dateadd < ? and (id_client = ? OR ? = -1) group by id_client");
        this.getDetaliiPlataForFactura = this.connection.prepareStatement("select products.label as product, ( select sum(facturi_emise_plati.platit) from facturi_emise_plati where facturi_emise_items.id = facturi_emise_plati.id_facturi_emise_items ) as incasat, facturi_emise_items.quantity * facturi_emise_items.sell_price as valoare, facturi_emise_items.id as id_entry from facturi_emise_items inner join products on facturi_emise_items.id_product = products.id inner join facturi_emise on facturi_emise_items.id_factura = facturi_emise.id inner join documente on facturi_emise.id = documente.id_factura_emisa where (documente.fiscal = ? or ? = -1) and facturi_emise_items.id_factura = ?");
        this.getFacturiNeplatitePtClient = this.connection.prepareStatement("select facturi_emise.*,  coalesce( ( select sum(suma) from fisa_plati where fisa_plati.id_factura_emisa = facturi_emise.id ), 0) as suma_achitata from facturi_emise inner join documente on facturi_emise.id = documente.id_factura_emisa where status_factura in (2, 3, 4) and (documente.fiscal = ? or ? = -1) and facturi_emise.plata = 0 and id_client = ? order by dateadd, facturi_emise.id");
        this.selectFacturaItems = this.connection.prepareStatement("select * from facturi_emise_items where id_factura = ? order by id");
        this.addFacturaItem = this.connection.prepareStatement("insert into facturi_emise_items ( id_factura, id_product, quantity, sell_price, sell_price_fara_tva, valoare_tva, id_magazie, produs_factura, produs_line_1 ) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.addFactura = this.connection.prepareStatement("insert into facturi_emise ( id_client, valoare, serie_factura, numar, dateadd, status, total_tva, total_general, id_agent, scadenta, status_factura, numar_tipizat, numar_auto, id_societatea_noastra ) values ( ?, ?, ?, ?, ?, 1, ?, ?, ?, ?, ?, ?, ?, ? ) ");
        this.updateFactura = this.connection.prepareStatement("update facturi_emise set id_client = ?, valoare = ?, serie_factura = ?, numar = ?, dateadd = ?, scadenta = ?, total_tva = ?, total_general = ?, status_factura = ?, numar_tipizat = ?, numar_auto = ?, id_societatea_noastra = ? where id = ?");
        this.selectLastFacturaNumber = this.connection.prepareStatement("select to_number(coalesce(numar,'0'), '99999999999999999999') as nr_fact from facturi_emise where serie_factura = ? order by nr_fact desc");
        this.updateTotalPtFactura = this.connection.prepareStatement("update facturi_emise set valoare = ?, total_tva = ?, total_general = ? where id = ?");
        this.selectFacturi = this.connection.prepareStatement("select * from facturi_emise left outer join documente on facturi_emise.id = documente.id_factura_emisa where (documente.fiscal = ? or ? = -1 or documente.fiscal is null) and dateadd >=? and dateadd < ? and (id_client = ? or ? = -1) and (id_agent = ? or ? = -1) and (status_Factura = ? or ? = -1) and ( ( numar like ?) or (serie_factura like ?) ) AND (facturi_emise.id_societatea_noastra = ? or ? = -1) order by dateadd, numar");
        this.deleteItemsForFactura = this.connection.prepareStatement("delete from facturi_emise_items where id_factura = ?");
        this.deleteFactura = this.connection.prepareStatement("delete from facturi_emise where id = ?");
        this.addOrderIdToFactura = this.connection.prepareStatement("insert into facturi_emise_orders (id_order, id_factura) values (?,?)");
        this.getOrderIdsForFactura = this.connection.prepareStatement("select * from facturi_emise_orders where id_factura = ?");
        this.linkFacturaFileToFactura = this.connection.prepareStatement("update facturi_emise set file_id = ? where id = ?");
        this.getIdFileByIdFactura = this.connection.prepareStatement("select files.id, files.title from files inner join facturi_emise on facturi_emise.file_id = files.id where facturi_emise.id = ?");
        this.getIdDocumentForComandaFerma = this.connection.prepareStatement("select documente.id as id_document from facturi_emise_items inner join facturi_emise on facturi_emise.id = facturi_emise_items.id_factura inner join facturi_emise_orders on facturi_emise_orders.id_factura = facturi_emise.id inner join orders on orders.id = facturi_emise_orders.id_order inner join documente on documente.id_factura_emisa = facturi_emise.id where orders.id = ? and documente.comanda_type = ?");
        this.deleteItemsByid = this.connection.prepareStatement("delete from facturi_emise_items where id = ?");
    }

    public Hashtable<Integer, FacturatEntry> getTotalFacturiForClient(int idClient, Timestamp start, Timestamp stop) throws SQLException {
        Hashtable<Integer, FacturatEntry> result = new Hashtable<Integer, FacturatEntry>();
        this.getTotalFacturatForClients.setTimestamp(1, start);
        this.getTotalFacturatForClients.setTimestamp(2, stop);
        this.getTotalFacturatForClients.setInt(3, idClient);
        this.getTotalFacturatForClients.setInt(4, idClient);
        ResultSet rs = this.getTotalFacturatForClients.executeQuery();
        while (rs.next()) {
            FacturatEntry fe = new FacturatEntry();
            fe.setTotalFacturat(rs.getDouble(1));
            int idClient1 = rs.getInt("id_client");
            fe.setIdClient(idClient1);
            result.put(idClient1, fe);
        }
        rs.close();
        return result;
    }

    public Hashtable<Integer, AgedDebtorsEntry> getTotalFacturiForClientCategories(Timestamp start, Timestamp stop, int idCategory) throws SQLException {
        Hashtable<Integer, AgedDebtorsEntry> result = new Hashtable<Integer, AgedDebtorsEntry>();
        this.getTotalFacturatForClientsCategories.setTimestamp(1, start);
        this.getTotalFacturatForClientsCategories.setTimestamp(2, stop);
        this.getTotalFacturatForClientsCategories.setInt(3, idCategory);
        this.getTotalFacturatForClientsCategories.setInt(4, idCategory);
        ResultSet rs = this.getTotalFacturatForClientsCategories.executeQuery();
        while (rs.next()) {
            AgedDebtorsEntry ae = new AgedDebtorsEntry();
            int idClient1 = rs.getInt("id_client");
            ae.setIdClient(idClient1);
            ae.setTotalCuTva(rs.getDouble(1));
            ae.setTotalFaraTva(rs.getDouble(2));
            ae.setTotalTva(rs.getDouble(3));
            result.put(idClient1, ae);
        }
        rs.close();
        return result;
    }

    public void addOrderIdToFactura(int idOrder, int idFactura) throws SQLException {
        this.addOrderIdToFactura.setInt(1, idOrder);
        this.addOrderIdToFactura.setInt(2, idFactura);
        this.addOrderIdToFactura.execute();
    }

    public void deleteFactura(int idFactura) throws SQLException {
        this.deleteFactura.setInt(1, idFactura);
        this.deleteFactura.execute();
    }

    public void deleteItemsForFactura(int idFactura) throws SQLException {
        this.deleteItemsForFactura.setInt(1, idFactura);
        this.deleteItemsForFactura.execute();
    }

    public void setStatusForFactura(int idFactura, int status) throws SQLException {
        this.setStatusForFactura.setInt(1, status);
        this.setStatusForFactura.setInt(2, idFactura);
        this.setStatusForFactura.execute();
    }

    public void updateFactura(int idClient, double valoare, double tva, double total, String serie, int numar, Timestamp dateadd, Timestamp scadenta, int newStatus, String numarTipizat, String numarAuto, int id, int idSocietateaNoastra) throws SQLException {
        this.updateFactura.setInt(1, idClient);
        this.updateFactura.setDouble(2, valoare);
        this.updateFactura.setString(3, serie);
        this.updateFactura.setInt(4, numar);
        this.updateFactura.setTimestamp(5, dateadd);
        this.updateFactura.setTimestamp(6, scadenta);
        this.updateFactura.setDouble(7, tva);
        this.updateFactura.setDouble(8, total);
        this.updateFactura.setInt(9, newStatus);
        this.updateFactura.setString(10, numarTipizat);
        this.updateFactura.setString(11, numarAuto);
        if (idSocietateaNoastra > 0) {
            this.updateFactura.setInt(12, idSocietateaNoastra);
        } else {
            this.updateFactura.setNull(12, 4);
        }
        this.updateFactura.setInt(13, id);
        this.updateFactura.execute();
    }

    public void addFacturaItem(int idFactura, int idProduct, double quantity, double sellPriceCuTva, double sellPriceFaraTva, double valoareTva, int idMagazie, String numeProdus, String produsLine1) throws SQLException {
        this.addFacturaItem.setInt(1, idFactura);
        this.addFacturaItem.setInt(2, idProduct);
        this.addFacturaItem.setDouble(3, quantity);
        this.addFacturaItem.setDouble(4, sellPriceCuTva);
        this.addFacturaItem.setDouble(5, sellPriceFaraTva);
        this.addFacturaItem.setDouble(6, valoareTva);
        this.addFacturaItem.setInt(7, idMagazie);
        this.addFacturaItem.setString(8, numeProdus);
        this.addFacturaItem.setString(9, produsLine1);
        this.addFacturaItem.execute();
    }

    public Vector getFacturaItems(int idFactura) throws SQLException {
        Vector<FacturaItem> result = new Vector<FacturaItem>();
        this.selectFacturaItems.setInt(1, idFactura);
        ResultSet rs = this.selectFacturaItems.executeQuery();
        while (rs.next()) {
            FacturaItem fItem = new FacturaItem(rs.getDouble("quantity"), rs.getInt("id_magazie"), rs.getInt("id_product"), rs.getDouble("sell_price"), rs.getDouble("sell_price_fara_tva"), rs.getDouble("valoare_tva"), rs.getInt("id_factura"), rs.getString("produs_factura"), rs.getString("produs_line_1"));
            fItem.setId(rs.getInt("id"));
            result.add(fItem);
        }
        rs.close();
        return result;
    }

    public Vector<Integer> getOrderIdsForFactura(int idFactura) throws SQLException {
        Vector<Integer> result = new Vector<Integer>();
        this.getOrderIdsForFactura.setInt(1, idFactura);
        ResultSet rs = this.getOrderIdsForFactura.executeQuery();
        while (rs.next()) {
            result.add(rs.getInt("id_order"));
        }
        rs.close();
        return result;
    }

    public Vector<FacturiEmiseView> getFacturiList(int idClient, Timestamp start, Timestamp stop, int idAgent, int status, String numar, int fisc, int idSocietateaNoastraFilter) throws SQLException {
        int f = -1;
        switch (fisc) {
            case 2: {
                f = 1;
                break;
            }
            case 3: {
                f = 0;
                break;
            }
        }
        this.selectFacturi.setInt(1, f);
        this.selectFacturi.setInt(2, f);
        this.selectFacturi.setTimestamp(3, start);
        this.selectFacturi.setTimestamp(4, stop);
        this.selectFacturi.setInt(5, idClient);
        this.selectFacturi.setInt(6, idClient);
        this.selectFacturi.setInt(7, idAgent);
        this.selectFacturi.setInt(8, idAgent);
        this.selectFacturi.setInt(9, status);
        this.selectFacturi.setInt(10, status);
        this.selectFacturi.setString(11, "%" + numar + "%");
        this.selectFacturi.setString(12, "%" + numar + "%");
        this.selectFacturi.setInt(13, idSocietateaNoastraFilter);
        this.selectFacturi.setInt(14, idSocietateaNoastraFilter);
        Vector<FacturiEmiseView> result = new Vector<FacturiEmiseView>();
        ResultSet rs = this.selectFacturi.executeQuery();
        while (rs.next()) {
            FacturiEmiseView toAdd = new FacturiEmiseView();
            toAdd.setIdClient(rs.getInt("id_client"));
            toAdd.setIdFactura(rs.getInt("id"));
            toAdd.setData(rs.getTimestamp("dateadd"));
            toAdd.setScadenta(rs.getTimestamp("scadenta"));
            toAdd.setSerie(rs.getString("serie_factura"));
            String s = rs.getString("numar");
            int nr = Integer.parseInt(s);
            toAdd.setNumarIntern(nr);
            toAdd.setTotal(rs.getDouble("valoare"));
            toAdd.setTva(rs.getDouble("total_tva"));
            toAdd.setTotalGeneral(rs.getDouble("total_general"));
            toAdd.setStatusFactura(rs.getInt("status_factura"));
            toAdd.setNumarTipizat(rs.getString("numar_tipizat"));
            toAdd.setNumarAuto(rs.getString("numar_auto"));
            int idSocietateaNoastra = rs.getInt("id_societatea_noastra");
            toAdd.setIdSocietateaNoastra(idSocietateaNoastra > 0 ? idSocietateaNoastra : -1);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public void addFactura(int idClient, double valoare, String seria, int numar, Timestamp data, double tva, double totalGeneral, int idAgent, Timestamp scadenta, int status, String numarTipizat, String nrAuto, int idSocietateaNoastra) throws SQLException {
        this.addFactura.setInt(1, idClient);
        this.addFactura.setDouble(2, valoare);
        this.addFactura.setString(3, seria);
        this.addFactura.setString(4, numar + "");
        this.addFactura.setTimestamp(5, data);
        this.addFactura.setDouble(6, tva);
        this.addFactura.setDouble(7, totalGeneral);
        if (idAgent > 0) {
            this.addFactura.setInt(8, idAgent);
        } else {
            this.addFactura.setNull(8, 4);
        }
        this.addFactura.setTimestamp(9, scadenta);
        this.addFactura.setInt(10, status);
        this.addFactura.setString(11, numarTipizat);
        this.addFactura.setString(12, nrAuto);
        if (idSocietateaNoastra > 0) {
            this.addFactura.setInt(13, idSocietateaNoastra);
        } else {
            this.addFactura.setNull(13, 4);
        }
        this.addFactura.execute();
    }

    public void linkFacturaFile(int fileId, int idFactura) throws SQLException {
        this.linkFacturaFileToFactura.setInt(1, fileId);
        this.linkFacturaFileToFactura.setInt(2, idFactura);
        this.linkFacturaFileToFactura.execute();
    }

    public int getLastFacturaNumber(String seria) throws SQLException {
        this.selectLastFacturaNumber.setString(1, seria);
        ResultSet rs = this.selectLastFacturaNumber.executeQuery();
        int result = -1;
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void updateTotal(double valoare, double tva, double total, int idFactura) throws SQLException {
        this.updateTotalPtFactura.setDouble(1, valoare);
        this.updateTotalPtFactura.setDouble(2, tva);
        this.updateTotalPtFactura.setDouble(3, total);
        this.updateTotalPtFactura.setInt(4, idFactura);
        this.updateTotalPtFactura.execute();
    }

    public Vector<FacturiNeplatiteEntry> getFacturiNeplatitePtClient(int idClient, int what) throws SQLException {
        Vector<FacturiNeplatiteEntry> result = new Vector<FacturiNeplatiteEntry>();
        int f1 = -1;
        switch (what) {
            case 2: {
                f1 = 1;
                break;
            }
            case 3: {
                f1 = 0;
                break;
            }
        }
        this.getFacturiNeplatitePtClient.setInt(1, f1);
        this.getFacturiNeplatitePtClient.setInt(2, f1);
        this.getFacturiNeplatitePtClient.setInt(3, idClient);
        ResultSet rs = this.getFacturiNeplatitePtClient.executeQuery();
        while (rs.next()) {
            FacturiNeplatiteEntry f = new FacturiNeplatiteEntry();
            f.setDate(rs.getTimestamp("dateadd"));
            f.setPlatit(rs.getDouble("suma_achitata"));
            f.setTotal(rs.getDouble("total_general"));
            f.compute();
            f.setFactura(rs.getString("numar"));
            f.setIdFactura(rs.getInt("id"));
            f.setScadenta(rs.getTimestamp("scadenta"));
            result.add(f);
        }
        rs.close();
        return result;
    }

    public Vector<IncasareDetaliataEntry> getDetaliiPlataForFactura(int idFactura, int what) throws SQLException {
        Vector<IncasareDetaliataEntry> result = new Vector<IncasareDetaliataEntry>();
        int f1 = -1;
        switch (what) {
            case 2: {
                f1 = 1;
                break;
            }
            case 3: {
                f1 = 0;
                break;
            }
        }
        this.getDetaliiPlataForFactura.setInt(1, f1);
        this.getDetaliiPlataForFactura.setInt(2, f1);
        this.getDetaliiPlataForFactura.setInt(3, idFactura);
        ResultSet rs = this.getDetaliiPlataForFactura.executeQuery();
        while (rs.next()) {
            IncasareDetaliataEntry f = new IncasareDetaliataEntry(rs.getString("product"), rs.getInt("id_entry"), rs.getDouble("valoare"), rs.getDouble("incasat"));
            result.add(f);
        }
        rs.close();
        return result;
    }

    public Hashtable getIdFileByIdFactura(int idFactura) throws SQLException {
        this.getIdFileByIdFactura.setInt(1, idFactura);
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        ResultSet rs = this.getIdFileByIdFactura.executeQuery();
        while (rs.next()) {
            int idFile = rs.getInt("id");
            String fileName = rs.getString("title");
            result.put("id", idFile);
            result.put("title", fileName);
        }
        return result;
    }

    public int getIdDocumentForComandaFerma(int orderId) throws SQLException {
        this.getIdDocumentForComandaFerma.setInt(1, orderId);
        this.getIdDocumentForComandaFerma.setInt(2, StockLogic.COMANDA_TYPE.COMANDA_FERMA.getIdTip());
        ResultSet resultSet = this.getIdDocumentForComandaFerma.executeQuery();
        if (resultSet.next()) {
            return resultSet.getInt("id_document");
        }
        return -1;
    }

    public void deleteItemsById(int id) throws SQLException {
        this.deleteItemsByid.setInt(1, id);
        this.deleteItemsByid.execute();
    }
}

