/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.facturi.gui;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.facturi.FacturiEmiseView;
import ro.atreides.facturi.FacturiLogic;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.logic.winmentor.WinmentorExportLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.documente.DocumenteLogic;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class FacturiEmiseReport
extends AbstractReportPanel
implements CleanupRequired {
    private FacturiLogic logic;
    private double total;
    private double totalTVA;
    private double totalGeneral;
    private JLabel totalLabel;
    private JLabel totalTVALabel;
    private JLabel totalGeneralLabel;
    private JComboBox agenti;
    private JComboBox status;
    private JComboBox societati;
    private XComboBox clienti;
    private Hashtable printCriteria = new Hashtable();
    private ReportInterface reportInterface;
    private DoubleClicked action;
    private FilterableComboBoxModel clientsComboModel;
    private JTextField nrFacturaField;
    private JButton exportButton;
    public static final String[] columns = new String[]{LangRoAll.client, "Numar si serie", LangRoAll.data, LangRoAll.status, LangRoAll.valoare, LangRoAll.tva, LangRoAll.total};
    private static Comparator date_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            FacturiEmiseView item1 = (FacturiEmiseView)o1;
            FacturiEmiseView item2 = (FacturiEmiseView)o2;
            return item1.getData().before(item2.getData()) ? -1 : 1;
        }
    };
    private static Comparator client_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            FacturiEmiseView item1 = (FacturiEmiseView)o1;
            FacturiEmiseView item2 = (FacturiEmiseView)o2;
            return item1.getClient().compareToIgnoreCase(item2.getClient());
        }
    };
    private static Comparator serie_numar_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            FacturiEmiseView item1 = (FacturiEmiseView)o1;
            FacturiEmiseView item2 = (FacturiEmiseView)o2;
            return item1.getSerieNumar().compareToIgnoreCase(item2.getSerieNumar());
        }
    };

    public FacturiEmiseReport() {
        this.logic = FacturiLogic.getInstance();
    }

    public DoubleClicked getAction() {
        return this.action;
    }

    public void setAction(DoubleClicked action) {
        this.action = action;
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        String nrFactura = this.nrFacturaField.getText();
        if (Validators.correctString(nrFactura)) {
            result.put("Numar factura", nrFactura);
            this.printCriteria.put("Numar factura", nrFactura);
        } else {
            this.printCriteria.remove("Numar factura");
        }
        if (ComboUtils.anythingButAllSelected(this.clienti)) {
            Client c = (Client)this.clienti.getSelectedItem();
            result.put(Constants.CLIENT_KEY, c.getId());
            this.printCriteria.put(Constants.CLIENT_KEY, c.toString());
        } else {
            result.put(Constants.CLIENT_KEY, -1);
            this.printCriteria.remove(Constants.CLIENT_KEY);
        }
        if (ComboUtils.anythingButAllSelected(this.agenti)) {
            User u = (User)this.agenti.getSelectedItem();
            result.put("Agent", u.getId());
            this.printCriteria.put("Agent", u.toString());
        } else {
            this.printCriteria.remove("Agent");
            result.put("Agent", -1);
        }
        String s = (String)this.status.getSelectedItem();
        int idStatus = FacturiLogic.getInstance().getStatusForString(s);
        result.put(Constants.STATUS_FACTURA_KEY, idStatus);
        this.printCriteria.put(Constants.STATUS_FACTURA_KEY, s);
        this.printCriteria.remove("Societate");
        if (FacturiLogic.getInstance().isMultipleSocietatiEnabled() && ComboUtils.anythingButAllSelected(this.societati)) {
            ClientPersJuridica societate = (ClientPersJuridica)this.societati.getSelectedItem();
            result.put("Societate", societate);
            this.printCriteria.put("Societate", societate.getCompanyName());
        }
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        this.societati = new JComboBox();
        c.gridy = 0;
        c.gridx = 0;
        if (FacturiLogic.getInstance().isMultipleSocietatiEnabled()) {
            c.weightx = 0.0;
            result.add((Component)new JLabel("Societatea"), c);
            ++c.gridx;
            c.weightx = 1.0;
            result.add((Component)this.societati, c);
            ++c.gridy;
            c.gridx = 0;
        }
        c.weightx = 0.0;
        result.add((Component)new JLabel("Numar factura"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.nrFacturaField = new JTextField(20);
        result.add((Component)this.nrFacturaField, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.clientsComboModel = new FilterableComboBoxModel(ClientLogic.getInstance().getClientsSorted());
        this.clienti = new XComboBox(this.clientsComboModel, true);
        this.clienti.setPrototypeDisplayValue("111111111111111111111111111111111");
        result.add((Component)this.clienti, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Agent"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.agenti = new JComboBox();
        result.add((Component)this.agenti, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.status), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.status = new JComboBox();
        result.add((Component)this.status, c);
        return result;
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM model = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                FacturiEmiseView st = (FacturiEmiseView)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return st.getClient();
                    }
                    case 1: {
                        return st.getSerieNumar();
                    }
                    case 2: {
                        return Formatters.DATE_FORMAT_RO.format(st.getData());
                    }
                    case 3: {
                        return FacturiLogic.getInstance().getStringForStatus(st.getStatusFactura());
                    }
                    case 4: {
                        return Utils.getString2Decimals(st.getTotal());
                    }
                    case 5: {
                        return Utils.getString2Decimals(st.getTva());
                    }
                    case 6: {
                        return Utils.getString2Decimals(st.getTotalGeneral());
                    }
                }
                return null;
            }
        });
        return model;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel("Total facturi"), c);
        ++c.gridx;
        this.totalLabel = new JLabel("");
        result.add((Component)this.totalLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Total TVA"), c);
        ++c.gridx;
        this.totalTVALabel = new JLabel("");
        result.add((Component)this.totalTVALabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Total General"), c);
        ++c.gridx;
        this.totalGeneralLabel = new JLabel("");
        result.add((Component)this.totalGeneralLabel, c);
        this.exportButton = new JButton("Export");
        ++c.gridx;
        result.add((Component)this.exportButton, c);
        return result;
    }

    @Override
    public String getName() {
        return "Facturi emise";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return this.logic.getFacturiEmise(criteria, this.whatToPrint);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void refreshTotalPanel() {
        this.computeTotals(this.data);
        this.totalLabel.setText(Utils.getString2Decimals(this.total));
        this.totalTVALabel.setText(Utils.getString2Decimals(this.totalTVA));
        this.totalGeneralLabel.setText(Utils.getString2Decimals(this.totalGeneral));
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    FacturiEmiseView st = (FacturiEmiseView)o;
                    try {
                        int column = 0;
                        Label label = new Label(column, row, st.getClient());
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, st.getCui());
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, st.getSerieNumar());
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, Formatters.DATE_FORMAT_RO.format(st.getData()));
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, FacturiLogic.getInstance().getStringForStatus(st.getStatusFactura()));
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(++column, row, st.getTotal()));
                        sheet.addCell((WritableCell)new Number(++column, row, st.getTva()));
                        sheet.addCell((WritableCell)new Number(++column, row, st.getTotalGeneral()));
                        ++column;
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return new String[]{LangRoAll.client, "CUI/CNP", "Numar si serie", LangRoAll.data, LangRoAll.status, LangRoAll.valoare, LangRoAll.tva, LangRoAll.total};
                }

                @Override
                public String getSheetName() {
                    return FacturiEmiseReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void doStuff() {
        this.clientsComboModel.refresh(ClientLogic.getInstance().getClientsSorted());
        ComboUtils.replaceItemsForCombo(this.societati, ClientLogic.getInstance().getSocietatiPropriiSorted());
        ComboUtils.replaceItemsForCombo(this.agenti, UsersLogic.getInstance().getUsersInGroup("group_agenti"));
        ComboUtils.replaceItemsForCombo(this.status, FacturiLogic.getInstance().getAllStatuses());
        final FacturiEmiseReport panel = this;
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    return;
                }
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final FacturiEmiseView st = (FacturiEmiseView)FacturiEmiseReport.this.data.elementAt(selRow);
                final JPopupMenu popup = new JPopupMenu();
                if (st.getStatusFactura() != 5) {
                    JMenuItem vizualizeaza = new JMenuItem("Vizualizeaza factura");
                    vizualizeaza.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            popup.setVisible(false);
                            FacturiEmiseReport.this.action.doubleClicked(st);
                        }
                    });
                    popup.add(vizualizeaza);
                }
                if (st.getStatusFactura() == 1 || st.getStatusFactura() == 2 || st.getStatusFactura() == 5 && Config.getInstance().getBoolean("facturareAllowStergereFacturaAnulata")) {
                    JMenuItem sterge = new JMenuItem("Sterge factura");
                    sterge.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            popup.setVisible(false);
                            if (DialogUtils.confirmDialog(panel, "Stergem aceasta factura", "")) {
                                FacturiEmiseReport.this.logic.deleteFactura(st.getIdFactura(), st.getData());
                                FacturiEmiseReport.this.raport();
                            }
                        }
                    });
                    popup.add(sterge);
                }
                if (st.getStatusFactura() == 3) {
                    JMenuItem valideaza = new JMenuItem("Valideaza factura");
                    valideaza.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            popup.setVisible(false);
                            if (DialogUtils.confirmDialog(panel, "Validam aceasta factura", "")) {
                                FacturiEmiseReport.this.logic.valideazaFactura(st);
                                FacturiEmiseReport.this.raport();
                            }
                        }
                    });
                    popup.add(valideaza);
                }
                if (st.getStatusFactura() == 3 || st.getStatusFactura() == 4 || st.getStatusFactura() == 6) {
                    JMenuItem anuleaza = new JMenuItem("Anuleaza");
                    anuleaza.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            popup.setVisible(false);
                            if (DialogUtils.confirmDialog(panel, "Anulam acest document", "")) {
                                FacturiEmiseReport.this.logic.anuleazaFactura(st, FacturiEmiseReport.this.whatToPrint);
                                FacturiEmiseReport.this.raport();
                            }
                        }
                    });
                    popup.add(anuleaza);
                }
                JMenuItem descarcaFactura = new JMenuItem("Descarca factura");
                descarcaFactura.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Hashtable map = FacturiLogic.getInstance().getFileIdByIdFactura(st.getIdFactura());
                        Integer idFile = (Integer)map.get("id");
                        String fileName = (String)map.get("title");
                        if (idFile != null && fileName != null) {
                            String path = FileUtils.getTempDir() + File.separator + "descarcari_from_db";
                            File f = new File(path);
                            f.mkdirs();
                            path = path + File.separator + fileName;
                            File file = new File(path);
                            DocumenteLogic.getInstance().saveDocument(file, idFile);
                            DialogUtils.okDialog(FacturiEmiseReport.this.table, "Factura a fost salvata in " + path, "Factura salvata");
                            try {
                                Desktop.getDesktop().open(file);
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        } else {
                            DialogUtils.errorDialog(FacturiEmiseReport.this.table, "Nu exista nici o factura salvata in baza de date", "Eroare");
                        }
                    }
                });
                popup.add(descarcaFactura);
                popup.setInvoker(FacturiEmiseReport.this.table);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                FacturiEmiseReport.this.clientsComboModel.refresh(ClientLogic.getInstance().getClientsSorted());
            }

            @Override
            public String getName() {
                return "FacturaPanel_persFizica";
            }
        }, 41);
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                FacturiEmiseReport.this.clientsComboModel.refresh(ClientLogic.getInstance().getClientsSorted());
                ComboUtils.replaceItemsForCombo(FacturiEmiseReport.this.societati, ClientLogic.getInstance().getSocietatiPropriiSorted());
            }

            @Override
            public String getName() {
                return "FacturaPanel_persJuridica";
            }
        }, 42);
        UsersLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(FacturiEmiseReport.this.agenti, UsersLogic.getInstance().getUsersInGroup("group_agenti"));
            }

            @Override
            public String getName() {
                return "FacturiEmiseReport_users";
            }
        }, 4);
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 1: {
                        return "";
                    }
                    case 2: {
                        return "";
                    }
                    case 3: {
                        return "";
                    }
                    case 4: {
                        return FacturiEmiseReport.this.totalLabel.getText();
                    }
                    case 5: {
                        return FacturiEmiseReport.this.totalTVALabel.getText();
                    }
                    case 6: {
                        return FacturiEmiseReport.this.totalGeneralLabel.getText();
                    }
                }
                return null;
            }

            @Override
            public String getReportTitle() {
                return FacturiEmiseReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return FacturiEmiseReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                FacturiEmiseView sve = (FacturiEmiseView)row;
                switch (column) {
                    case 0: {
                        return sve.getClient();
                    }
                    case 1: {
                        return sve.getSerieNumar();
                    }
                    case 2: {
                        return Formatters.DATE_FORMAT_RO.format(sve.getData());
                    }
                    case 3: {
                        return FacturiLogic.getInstance().getStringForStatus(sve.getStatusFactura());
                    }
                    case 4: {
                        return Utils.getString2Decimals(sve.getTotal());
                    }
                    case 5: {
                        return Utils.getString2Decimals(sve.getTva());
                    }
                    case 6: {
                        return Utils.getString2Decimals(sve.getTotalGeneral());
                    }
                }
                return null;
            }
        };
        final FacturiEmiseReport parent = this;
        this.exportButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    return;
                }
                JPopupMenu menu = new JPopupMenu();
                JMenuItem exportWinmentor = new JMenuItem("Export WinMentor");
                exportWinmentor.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String filePath = WinmentorExportLogic.getInstance().exportDateWinMentorFacturiEmise(parent, FacturiEmiseReport.this.data);
                        if (filePath != null) {
                            DialogUtils.okDialog(parent, "Datele au fost salvate la " + filePath, LangRoAll.succes);
                        } else {
                            DialogUtils.errorDialog(parent, "Export esuat", LangRoAll.eroare);
                        }
                    }
                });
                menu.add(exportWinmentor);
                JMenuItem exportDeverJSON = new JMenuItem("Export Dever");
                exportDeverJSON.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Date start = (Date)FacturiEmiseReport.this.criteria.get(Constants.START_KEY);
                        Date stop = (Date)FacturiEmiseReport.this.criteria.get(Constants.STOP_KEY);
                        boolean b = ContaLogic.getInstance().exportFacturiEmiseToJSON(FacturiEmiseReport.this.tm.getData(), start, stop);
                        if (b) {
                            DialogUtils.okDialog(parent, "Exportul a fost efectuat", LangRoAll.succes);
                        } else {
                            DialogUtils.errorDialog(parent, "Export esuat", LangRoAll.eroare);
                        }
                    }
                });
                menu.add(exportDeverJSON);
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return client_sorter;
            }
            case 1: {
                return serie_numar_sorter;
            }
            case 2: {
                return date_sorter;
            }
        }
        return null;
    }

    private void computeTotals(Vector items) {
        this.total = 0.0;
        this.totalTVA = 0.0;
        this.totalGeneral = 0.0;
        for (FacturiEmiseView element : items) {
            this.total += element.getTotal();
            this.totalTVA += element.getTva();
            this.totalGeneral += element.getTotalGeneral();
        }
    }

    @Override
    public void cleanup() {
    }
}

