/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.facturi.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JTabbedPane;
import ro.atreides.facturi.FacturiEmiseView;
import ro.atreides.facturi.FacturiLogic;
import ro.atreides.facturi.gui.AddFacturaPanel;
import ro.atreides.facturi.gui.FacturiEmiseReport;
import ro.atreides.facturi.gui.RaportIesiriPanel;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.SwitchToList;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class FacturiPanel
extends ReflectedJPanel
implements CleanupRequired {
    private JTabbedPane content = null;
    private AddFacturaPanel addFacturaPanel;
    private FacturiEmiseReport facturiEmisePanel;
    private RaportIesiriPanel raportIesiriPanel;

    @Override
    public void doStuff() {
        this.content = new JTabbedPane();
        this.addFacturaPanel = new AddFacturaPanel(this);
        this.content.add("Adauga factura", this.addFacturaPanel);
        this.facturiEmisePanel = new FacturiEmiseReport();
        this.facturiEmisePanel.doStuff();
        this.content.add(this.facturiEmisePanel.getName(), this.facturiEmisePanel);
        this.raportIesiriPanel = new RaportIesiriPanel();
        this.raportIesiriPanel.doStuff();
        this.content.add(this.raportIesiriPanel.getName(), this.raportIesiriPanel);
        FacturiLogic.getInstance().setAddFacturaPanel(this.addFacturaPanel);
        this.addFacturaPanel.setEmitent(AdministrationPanel.loggedUser);
        this.facturiEmisePanel.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                FacturiEmiseView fev = (FacturiEmiseView)o;
                FacturiPanel.this.addFacturaPanel.setFacturaToEdit(fev);
                FacturiPanel.this.content.setSelectedComponent(FacturiPanel.this.addFacturaPanel);
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        this.addFacturaPanel.setAction(new SwitchToList(){

            @Override
            public void doAction() {
                FacturiPanel.this.content.setSelectedComponent(FacturiPanel.this.facturiEmisePanel);
                FacturiPanel.this.facturiEmisePanel.raport();
            }
        });
        int max = this.content.getTabCount();
        for (int i = 0; i < max; ++i) {
            ReflectedJPanel panel = (ReflectedJPanel)this.content.getComponentAt(i);
            panel.setUserLogInterface(this.userLogInterface);
            this.content.setBackgroundAt(i, Constants.BO_TAB_LEVEL_TWO_COLOR);
        }
        GuiUtilsRest.addPiratGuiMouseListenerForReports(this.content);
        this.display();
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.content, c);
    }

    @Override
    public void cleanup() {
        this.addFacturaPanel.cleanup();
        this.facturiEmisePanel.cleanup();
    }
}

