/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.facturi.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.facturi.FacturiLogic;
import ro.atreides.facturi.IesireProdusFacturiEmise;
import ro.atreides.nomenclatura.Product;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class RaportIesiriPanel
extends AbstractReportPanel {
    private Hashtable printCriteria = new Hashtable();
    private JLabel produs;
    private JLabel tipComandaLabel;
    private JLabel clientiLabel;
    private JLabel totalLabel;
    private JLabel totalValLabel;
    private XComboBox produseCombo;
    private JComboBox tipComandaCombo;
    private JComboBox clientiCombo;
    FilterableComboBoxModel produseComboModel;
    public static final String[] columns = new String[]{LangRoAll.produs, LangRoAll.client, "Serie", "Numar", LangRoAll.data, LangRoAll.cantitate, "P. vanzare", "V. vanzare"};
    private ReportInterface reportInterface;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (this.tipComandaCombo != null && ComboUtils.anythingButAllSelected(this.tipComandaCombo)) {
            StockLogic.COMANDA_TYPE selectedItem = (StockLogic.COMANDA_TYPE)((Object)this.tipComandaCombo.getSelectedItem());
            result.put("Comanda Type", (Object)selectedItem);
            this.printCriteria.put("Comanda Type", selectedItem);
        } else {
            result.put("Comanda Type", -1);
            this.printCriteria.remove("Comanda Type");
        }
        if (ComboUtils.anythingButAllSelected(this.produseCombo)) {
            Product p = (Product)this.produseCombo.getSelectedItem();
            result.put("Product", p.getId());
            this.printCriteria.put("Product", p.toString());
        } else {
            result.put("Product", -1);
            this.printCriteria.remove("Product");
        }
        if (ComboUtils.anythingButAllSelected(this.clientiCombo)) {
            Client c = (Client)this.clientiCombo.getSelectedItem();
            result.put(Constants.CLIENT_KEY, c.getId());
            this.printCriteria.put(Constants.CLIENT_KEY, c.toString());
        } else {
            result.put(Constants.CLIENT_KEY, -1);
            this.printCriteria.remove(Constants.CLIENT_KEY);
        }
        return result;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return StockLogic.getInstance().getIesiriProduseFacturiEmiseByCriteria(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    IesireProdusFacturiEmise iesire = (IesireProdusFacturiEmise)o;
                    try {
                        int column = 0;
                        Label label = new Label(column, row, iesire.getProdus());
                        sheet.addCell((WritableCell)label);
                        int n = ++column;
                        sheet.addCell((WritableCell)new Label(n, row, iesire.getNumePersFizica() != null ? iesire.getNumePersFizica() : iesire.getNumePersJuridica()));
                        label = new Label(++column, row, iesire.getSerieFactura());
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, iesire.getNumarFactura() + "");
                        sheet.addCell((WritableCell)label);
                        label = new Label(++column, row, Formatters.DATE_AND_TIME_FORMAT.format(iesire.getData()));
                        sheet.addCell((WritableCell)label);
                        int n2 = ++column;
                        sheet.addCell((WritableCell)new Number(n2, row, iesire.getCantitate()));
                        int n3 = ++column;
                        sheet.addCell((WritableCell)new Number(n3, row, iesire.getPpu()));
                        int n4 = ++column;
                        sheet.addCell((WritableCell)new Number(n4, row, iesire.getValoare()));
                        int n5 = ++column;
                        ++column;
                        label = new Label(n5, row, iesire.getComandaType().toString());
                        sheet.addCell((WritableCell)label);
                        ++column;
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return RaportIesiriPanel.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Raport Iesiri";
    }

    @Override
    public AbstractTM buildTableModel() {
        String[] columnsLocal = VpConfig.getInstance().futureStocksEnabledFacturiEmise ? Utils.addOneElementToStringArray(columns, "Tip comanda") : columns;
        AbstractTM model = new AbstractTM(columnsLocal, Utils.getStringClass(columnsLocal.length), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                IesireProdusFacturiEmise iesire = (IesireProdusFacturiEmise)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return iesire.getProdus();
                    }
                    case 1: {
                        return iesire.getNumePersFizica() != null ? iesire.getNumePersFizica() : iesire.getNumePersJuridica();
                    }
                    case 2: {
                        return iesire.getSerieFactura();
                    }
                    case 3: {
                        return iesire.getNumarFactura();
                    }
                    case 4: {
                        return iesire.getData();
                    }
                    case 5: {
                        return iesire.getCantitate();
                    }
                    case 6: {
                        return iesire.getPpu();
                    }
                    case 7: {
                        return iesire.getValoare();
                    }
                    case 8: {
                        return iesire.getComandaType();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return model;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel();
        result.setBorder(new TitledBorder("Total"));
        this.totalLabel = new JLabel("Total: ");
        result.add(this.totalLabel);
        this.totalValLabel = new JLabel("");
        result.add(this.totalValLabel);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        this.produs = new JLabel("Produs");
        result.add((Component)this.produs, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.produseComboModel = new FilterableComboBoxModel(FacturiLogic.getInstance().getAllProducts());
        this.produseCombo = new XComboBox(this.produseComboModel);
        this.produseCombo.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.produseCombo.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                RaportIesiriPanel.this.produseCombo.selectAllText();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        result.add((Component)this.produseCombo, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        if (VpConfig.getInstance().futureStocksEnabledFacturiEmise) {
            this.tipComandaLabel = new JLabel("Tip comanda");
            result.add((Component)this.tipComandaLabel, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.tipComandaCombo = new JComboBox();
            result.add((Component)this.tipComandaCombo, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
        }
        this.clientiLabel = new JLabel("Client");
        result.add((Component)this.clientiLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.clientiCombo = new JComboBox();
        result.add((Component)this.clientiCombo, c);
        return result;
    }

    @Override
    public void refreshTotalPanel() {
        double sum = 0.0;
        Vector data = this.tm.getData();
        for (IesireProdusFacturiEmise ies : data) {
            sum += ies.getValoare();
        }
        this.totalValLabel.setText(Utils.getString3Decimals(sum));
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.clientiCombo, ClientLogic.getInstance().getAllClientsSorted());
        if (VpConfig.getInstance().futureStocksEnabledFacturiEmise) {
            ComboUtils.replaceItemsForCombo(this.tipComandaCombo, StockLogic.getComandaTypeCollection());
        }
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                return "";
            }

            @Override
            public String getReportTitle() {
                return RaportIesiriPanel.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return RaportIesiriPanel.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return true;
            }

            @Override
            public String getCellContent(Object row, int column) {
                IesireProdusFacturiEmise iesire = (IesireProdusFacturiEmise)row;
                switch (column) {
                    case 0: {
                        return iesire.getProdus();
                    }
                    case 1: {
                        return iesire.getNumePersFizica() != null ? iesire.getNumePersFizica() : iesire.getNumePersJuridica();
                    }
                    case 2: {
                        return iesire.getSerieFactura();
                    }
                    case 3: {
                        return iesire.getNumarFactura() + "";
                    }
                    case 4: {
                        return Formatters.DATE_AND_TIME_FORMAT.format(iesire.getData());
                    }
                    case 5: {
                        return Utils.getString3DecimalsNoTrunc(iesire.getCantitate());
                    }
                    case 6: {
                        return Utils.getString2DecimalsNoTrunc(iesire.getPpu());
                    }
                    case 7: {
                        return Utils.getString2DecimalsNoTrunc(iesire.getValoare());
                    }
                    case 8: {
                        return iesire.getComandaType().toString();
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

