/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.gef;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.LayerManager;
import org.tigris.gef.event.ModeChangeEvent;
import org.tigris.gef.event.ModeChangeListener;
import org.tigris.gef.graph.presentation.JGraph;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.util.Localizer;
import org.tigris.gef.util.ResourceLoader;
import ro.atreides.gef.DBbridge;
import ro.atreides.gef.DMI;
import ro.atreides.gef.FigRestaurant;
import ro.atreides.gef.PaletteRestaurant;
import ro.atreides.gef.data.DataInterfaceImpl;
import ro.atreides.gef.utils.FigAdder;
import ro.atreides.gef.utils.xml.XmlUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public class DiagramPanel
extends JPanel
implements Cloneable,
ModeChangeListener {
    private JGraph _graph = new JGraph();
    private String diagramName;
    private PaletteRestaurant pallete;

    public DiagramPanel(String name, DBbridge diagramInterface) {
        this.diagramName = name;
        DataInterfaceImpl dataInterface = new DataInterfaceImpl(this._graph, diagramInterface);
        Localizer.addResource("GefBase", "org.tigris.gef.base.BaseResourceBundle");
        Localizer.addResource("GefPres", "org.tigris.gef.presentation.PresentationResourceBundle");
        Localizer.addLocale(Locale.getDefault());
        Localizer.switchCurrentLocale(Locale.getDefault());
        ResourceLoader.addResourceExtension("gif");
        ResourceLoader.addResourceLocation("/org/tigris/gef/Images");
        ResourceLoader.addResourceLocation("/ro/atreides/gef/Images");
        this.setLayout(new BorderLayout());
        this._graph.setBackground(Color.white);
        this._graph.setDefaultSize(new Dimension(1250, 1000));
        this._graph.setDrawingSize(this._graph.getDefaultSize());
        this.add((Component)this._graph, "Center");
        this.pallete = new PaletteRestaurant(dataInterface, this);
        this._graph.setForeground(Color.RED);
        this._graph.getEditor().setGridHidden(true);
        this._graph.setOpaque(true);
        this._graph.getEditor().getJComponent().setOpaque(true);
        this._graph.setTitle(name);
    }

    public void setTitle(String newTitle) {
        this._graph.setTitle(newTitle);
    }

    private void addPaletteFig() {
        this.add((Component)this.pallete, "North");
        this.validate();
    }

    private void removePaletteFig() {
        this.remove(this.pallete);
        this.validate();
    }

    public void setEditable(boolean b) {
        this._graph.getEditor().setElementsSelectable(b);
        if (b) {
            this.addPaletteFig();
        } else {
            this.removePaletteFig();
        }
    }

    @Override
    public void modeChange(ModeChangeEvent mce) {
    }

    public String getDiagramName() {
        return this.diagramName;
    }

    public void setMasaFillColor(String name, Color color) {
        Editor editor = Globals.curEditor();
        LayerManager layerM = editor.getLayerManager();
        List contents = layerM.getContents();
        if (contents == null) {
            return;
        }
        Vector figs = new Vector(contents);
        for (Fig fig : figs) {
            String numeMasa;
            Vector lines;
            if (!(fig instanceof FigRestaurant) || (lines = Utils.splitString(numeMasa = ((FigRestaurant)((Object)fig)).getNume(), '\n')).size() <= 0 || !name.equals(numeMasa = (String)lines.get(0))) continue;
            fig.setFillColor(color);
            fig.damage();
            return;
        }
    }

    public void setMasaConturLineColor(String name, Color color) {
        Editor editor = Globals.curEditor();
        LayerManager layerM = editor.getLayerManager();
        List contents = layerM.getContents();
        if (contents == null) {
            return;
        }
        Vector figs = new Vector(contents);
        for (Fig fig : figs) {
            if (!(fig instanceof FigRestaurant) || !name.equals(((FigRestaurant)((Object)fig)).getNume())) continue;
            fig.setLineColor(color);
            fig.damage();
            return;
        }
    }

    public void setNameOspatar(String masa, String ospatarName, String dataSiOra, String clientName, String detaliiNota) {
        Editor editor = Globals.curEditor();
        LayerManager layerM = editor.getLayerManager();
        List contents = layerM.getContents();
        if (contents == null) {
            return;
        }
        Vector figs = new Vector(contents);
        for (Fig fig : figs) {
            FigRestaurant f;
            if (!(fig instanceof FigRestaurant) || !masa.equals((f = (FigRestaurant)((Object)fig)).getNume())) continue;
            String detalii = ospatarName;
            if (Validators.correctString(dataSiOra)) {
                detalii = detalii + "\n" + dataSiOra;
                if (Validators.correctString(clientName)) {
                    detalii = detalii + "\n" + clientName;
                }
                if (Validators.correctString(detaliiNota)) {
                    detalii = detalii + "\n" + detaliiNota;
                }
            }
            f.setDetalii(detalii);
            fig.damage();
            return;
        }
    }

    public void setAllMasaFontSize(int size) {
        Editor editor = Globals.curEditor();
        Vector figs = new Vector(editor.getLayerManager().getContents());
        for (Fig fig : figs) {
            if (!(fig instanceof FigRestaurant)) continue;
            ((FigRestaurant)((Object)fig)).setFontSize(size);
            fig.damage();
        }
    }

    public void setMasaFontSize(String masa, int size) {
        Editor editor = Globals.curEditor();
        Vector figs = new Vector(editor.getLayerManager().getContents());
        for (Fig fig : figs) {
            if (!masa.equals(((FigRestaurant)((Object)fig)).getNume())) continue;
            ((FigRestaurant)((Object)fig)).setFontSize(size);
            fig.damage();
            return;
        }
    }

    public Editor getEditor() {
        return this._graph.getEditor();
    }

    public JGraph getGraph() {
        return this._graph;
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame("diagram");
        frame.setDefaultCloseOperation(3);
        final DiagramPanel diagramPanel = new DiagramPanel("diagram 1", new DMI(frame));
        frame.add(diagramPanel);
        frame.pack();
        frame.setSize(800, 600);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        JFrame frame2 = new JFrame();
        frame2.setDefaultCloseOperation(3);
        JButton button3 = new JButton("Enable Edit");
        button3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                diagramPanel.setEditable(true);
            }
        });
        JButton button4 = new JButton("Disable Edit");
        button4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                diagramPanel.setEditable(false);
            }
        });
        String filename = "test.xml";
        JButton buttonOpen = new JButton("open");
        buttonOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor editor = diagramPanel.getEditor();
                Vector figures = XmlUtils.getFigures("test.xml", new DataInterfaceImpl(diagramPanel.getGraph(), new DMI(frame)));
                FigAdder.addFigs(editor, figures);
            }
        });
        JButton buttonSave = new JButton("save");
        buttonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor editor = diagramPanel.getEditor();
                XmlUtils.saveFigures("test.xml", editor);
            }
        });
        JPanel panel = new JPanel();
        panel.add(button3);
        panel.add(button4);
        panel.add(buttonOpen);
        panel.add(buttonSave);
        frame2.add(panel);
        frame2.pack();
        frame2.setLocationRelativeTo(null);
        frame2.setVisible(true);
    }
}

