/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.gef;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.tigris.gef.base.Editor;
import org.tigris.gef.presentation.FigCircle;
import ro.atreides.gef.DBbridge;
import ro.atreides.gef.FigRestaurant;
import ro.atreides.gef.TextDrawer;
import ro.atreides.gef.data.DataInterface;
import ro.atreides.gef.data.DataInterfaceSetter;
import ro.atreides.gef.utils.gui.DiagramRestaurantInputDialog;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.multilang.LangRoAll;

public class FigCircleWithText
extends FigCircle
implements MouseListener,
FigRestaurant,
DataInterfaceSetter {
    private static final BasicStroke stroke = new BasicStroke(4.0f);
    protected TextDrawer figTextDrawer;
    protected transient DataInterface dataInterface;
    protected String nume = "";
    protected String detalii = "";
    protected int nrLocs;
    protected boolean virtuala;
    protected String fullDetails;

    public FigCircleWithText(DataInterface intrface, int x, int y, int w, int h) {
        super(x, y, w, h);
        this.figTextDrawer = new TextDrawer(x, y, w, h);
        this.dataInterface = intrface;
    }

    public FigCircleWithText(DataInterface intrface, int x, int y, int w, int h, Color lColor, Color fColor) {
        super(x, y, w, h, lColor, fColor);
        this.figTextDrawer = new TextDrawer(x, y, w, h);
        this.dataInterface = intrface;
    }

    public FigCircleWithText(DataInterface intrface, int x, int y, int w, int h, boolean resizable) {
        super(x, y, w, h, resizable);
        this.figTextDrawer = new TextDrawer(x, y, w, h);
        this.dataInterface = intrface;
    }

    public FigCircleWithText(DataInterface intrface, int x, int y, int w, int h, boolean resizable, Color lColor, Color fColor) {
        super(x, y, w, h, resizable, lColor, fColor);
        this.figTextDrawer = new TextDrawer(x, y, w, h);
        this.dataInterface = intrface;
    }

    @Override
    public void paint(Object g) {
        Graphics2D g2d = (Graphics2D)((Graphics)g).create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setStroke(stroke);
        ((Graphics)g).setColor(this.getFillColor());
        ((Graphics)g).fillOval(this._x, this._y, this._w, this._h);
        g2d.setColor(this.getLineColor());
        g2d.drawOval(this._x - 1, this._y - 1, this._w + 1, this._h + 1);
        Dimension minSize = this.getMinimumSize();
        int x = this._x + (this._w - minSize.width) / 2;
        int y = this._y + (this._h - minSize.height) / 2;
        this.figTextDrawer.setLocation(x, y);
        this.figTextDrawer.paint(g);
        g2d.dispose();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = this.figTextDrawer.getMinimumSize();
        dim.setSize(dim.getWidth() + 6.0, dim.getHeight() + 5.0);
        return dim;
    }

    @Override
    public Vector getPopUpActions(MouseEvent me) {
        if (!this.isEditorMode()) {
            Vector popUpActions = new Vector(0);
            return popUpActions;
        }
        Vector<JMenuItem> popUpActions = new Vector<JMenuItem>(5);
        JMenuItem stergeItem = new JMenuItem(LangRoAll.sterge);
        stergeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBbridge modifier = FigCircleWithText.this.dataInterface.getDiagramModifier();
                if (modifier.canDelete(FigCircleWithText.this.nume)) {
                    FigCircleWithText.this.deleteFromModel();
                } else {
                    JOptionPane.showMessageDialog(modifier.getMainFrame(), "NU se poate sterge : \"" + FigCircleWithText.this.nume + "\"");
                }
            }
        });
        JMenuItem modificaItem = new JMenuItem(LangRoAll.modifica);
        modificaItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fullD;
                boolean vir;
                DBbridge modifier = FigCircleWithText.this.dataInterface.getDiagramModifier();
                DiagramRestaurantInputDialog dialog = new DiagramRestaurantInputDialog(modifier.getMainFrame(), true, modifier.getMainFrame(), LangRoAll.modifica, FigCircleWithText.this.nume, FigCircleWithText.this.nrLocs, FigCircleWithText.this.virtuala, FigCircleWithText.this.fullDetails);
                String newName = dialog.getInput();
                String nrLocuri = dialog.getNrLocuri();
                if (newName == null) {
                    return;
                }
                int nrL = 1;
                if (Validators.correctInteger(nrLocuri)) {
                    nrL = Integer.parseInt(nrLocuri);
                }
                if (modifier.canModify(FigCircleWithText.this.nume, newName, nrL, vir = dialog.isVirtuala(), fullD = dialog.getDetalii())) {
                    FigCircleWithText.this.setNume(newName);
                    FigCircleWithText.this.setNrLocuri(nrL);
                    FigCircleWithText.this.setVirtuala(vir);
                    FigCircleWithText.this.setFullDetails(fullD);
                } else {
                    JOptionPane.showMessageDialog(modifier.getMainFrame(), "Nu puteti modifica", LangRoAll.eroare, 0);
                }
            }
        });
        popUpActions.add(stergeItem);
        popUpActions.add(modificaItem);
        return popUpActions;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        try {
            if (!this.isEditorMode()) {
                DBbridge modifier = this.dataInterface.getDiagramModifier();
                modifier.buttonPush(this.nume);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void setTextToTextDrawer() {
        String toSet = this.nume;
        if (Validators.correctString(this.detalii)) {
            toSet = toSet + "\n" + this.detalii;
        }
        this.figTextDrawer.setText(toSet);
        Dimension minSize = this.getMinimumSize();
        this.figTextDrawer.setSize(minSize.width, minSize.height);
        this.setSize(Math.max(minSize.width, this._w), Math.max(minSize.height, this._h));
        this.damage();
    }

    public String toString() {
        String toolTip = "";
        return toolTip;
    }

    @Override
    public String getNume() {
        return this.nume;
    }

    @Override
    public void setDetalii(String d) {
        this.detalii = d != null ? d : "";
        this.setTextToTextDrawer();
    }

    @Override
    public void setFontSize(int size) {
        System.out.println("min1 = " + this.getMinimumSize());
        this.figTextDrawer.setFontSize(size);
        Dimension minSize = this.getMinimumSize();
        System.out.println("min2 = " + minSize);
        this.figTextDrawer.setSize(minSize.width, minSize.height);
        this.setSize(Math.max(minSize.width, this._w), Math.max(minSize.height, this._h));
        this.damage();
    }

    @Override
    public void setNume(String text) {
        this.nume = text != null ? text : "";
        this.setTextToTextDrawer();
    }

    public boolean isEditorMode() {
        Editor editor = this.dataInterface.getJGraph().getEditor();
        return editor.canSelectElements();
    }

    @Override
    public void setDataInterface(DataInterface data) {
        this.dataInterface = data;
    }

    @Override
    public void setNrLocuri(int nrL) {
        this.nrLocs = nrL;
    }

    @Override
    public void setVirtuala(boolean v) {
        this.virtuala = v;
    }

    @Override
    public void setFullDetails(String text) {
        this.fullDetails = text;
    }

    public int getNrLocs() {
        return this.nrLocs;
    }

    public boolean isVirtuala() {
        return this.virtuala;
    }

    public String getFullDetails() {
        return this.fullDetails;
    }
}

