/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.gef;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.tigris.gef.base.CmdReorder;
import org.tigris.gef.presentation.FigRect;
import org.tigris.gef.util.Localizer;
import ro.atreides.gef.DBbridge;
import ro.atreides.gef.TextDrawer;
import ro.atreides.gef.data.DataInterface;
import ro.atreides.gef.data.DataInterfaceSetter;
import ro.atreides.gef.utils.gui.FontChangerDialog;
import ro.atreides.gef.utils.gui.TextChangerDialog;
import ro.atreides.utils.multilang.LangRoAll;

public class FigComment
extends FigRect
implements MouseListener,
Serializable,
DataInterfaceSetter {
    protected TextDrawer figTextDrawer;
    protected transient DataInterface dataInterface;

    public FigComment(DataInterface intrface, int x, int y, int w, int h, boolean resizable, Color lColor, Color fColor) {
        super(x, y, w, h, resizable, lColor, fColor);
        this.figTextDrawer = new TextDrawer(x, y, w, h);
        this.dataInterface = intrface;
    }

    public FigComment(DataInterface intrface, int x, int y, int w, int h) {
        super(x, y, w, h);
        this.figTextDrawer = new TextDrawer(x, y, w, h);
        this.dataInterface = intrface;
    }

    public FigComment(DataInterface intrface, int x, int y, int w, int h, Color lColor, Color fColor) {
        super(x, y, w, h, lColor, fColor);
        this.figTextDrawer = new TextDrawer(x, y, w, h);
        this.dataInterface = intrface;
    }

    public FigComment(DataInterface intrface, int x, int y, int w, int h, boolean resizable) {
        super(x, y, w, h, resizable);
        this.figTextDrawer = new TextDrawer(x, y, w, h);
        this.dataInterface = intrface;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = this.figTextDrawer.getMinimumSize();
        dim.setSize(dim.getWidth() + 6.0, dim.getHeight() + 5.0);
        return dim;
    }

    @Override
    public void paint(Object g) {
        Graphics2D g2d = (Graphics2D)((Graphics)g).create();
        g2d.setStroke(new BasicStroke(1.0f));
        super.paint((Object)g2d);
        g2d.dispose();
        Dimension minSize = this.getMinimumSize();
        int x = this._x + (this._w - minSize.width) / 2;
        int y = this._y + (this._h - minSize.height) / 2;
        this.figTextDrawer.setLocation(x, y);
        this.figTextDrawer.paint(g);
        g2d.dispose();
    }

    @Override
    public Vector getPopUpActions(MouseEvent me) {
        if (this.getLocked()) {
            Vector popUpActions = new Vector(0);
            return popUpActions;
        }
        Vector<JComponent> popUpActions = new Vector<JComponent>();
        JMenuItem sizeItem = new JMenuItem("Font Size");
        sizeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBbridge modifier = FigComment.this.dataInterface.getDiagramModifier();
                FontChangerDialog dialog = new FontChangerDialog(modifier.getMainFrame(), true, modifier.getMainFrame(), "Font Size", FigComment.this.figTextDrawer.getFontSize());
                int size = dialog.getSelectedFontSize();
                if (size != -1) {
                    FigComment.this.setTextFontSize(size);
                    FigComment.this.damage();
                }
            }
        });
        JMenuItem changeTextItem = new JMenuItem("Schimba text");
        changeTextItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBbridge modifier = FigComment.this.dataInterface.getDiagramModifier();
                TextChangerDialog dialog = new TextChangerDialog(modifier.getMainFrame(), true, modifier.getMainFrame(), "Text Nou", FigComment.this.getText());
                if (dialog.getInput() != null) {
                    FigComment.this.setTextToTextDrawer(dialog.getInput());
                    FigComment.this.damage();
                }
            }
        });
        JMenuItem stergeItem = new JMenuItem(LangRoAll.sterge);
        stergeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FigComment.this.deleteFromModel();
            }
        });
        JMenuItem backColorItem = new JMenuItem("Background Color");
        backColorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBbridge modifier = FigComment.this.dataInterface.getDiagramModifier();
                Color color = JColorChooser.showDialog(modifier.getMainFrame(), "Choose Color", FigComment.this.getFillColor());
                if (color != null) {
                    System.out.println("setting back color");
                    FigComment.this.setFillColor(color);
                    FigComment.this.damage();
                }
            }
        });
        JMenuItem forgroundColorItem = new JMenuItem("Forground Color");
        forgroundColorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBbridge modifier = FigComment.this.dataInterface.getDiagramModifier();
                Color color = JColorChooser.showDialog(modifier.getMainFrame(), "Choose Color", FigComment.this.getForegroundColor());
                if (color != null) {
                    System.out.println("setting back color");
                    FigComment.this.figTextDrawer.setTextColor(color);
                    FigComment.this.damage();
                }
            }
        });
        JMenu menuFont = new JMenu("Font");
        menuFont.add(sizeItem);
        menuFont.add(forgroundColorItem);
        menuFont.add(backColorItem);
        JMenu orderMenu = new JMenu(Localizer.localize("PresentationGef", "Ordering"));
        orderMenu.setMnemonic('O');
        orderMenu.add(CmdReorder.BringForward);
        orderMenu.add(CmdReorder.SendBackward);
        orderMenu.add(CmdReorder.BringToFront);
        orderMenu.add(CmdReorder.SendToBack);
        popUpActions.add(stergeItem);
        popUpActions.add(changeTextItem);
        popUpActions.add(new JPopupMenu.Separator());
        popUpActions.add(menuFont);
        popUpActions.add(orderMenu);
        return popUpActions;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    protected void setTextToTextDrawer(String text) {
        this.figTextDrawer.setText(text);
        Dimension minSize = this.getMinimumSize();
        this.figTextDrawer.setSize(minSize.width, minSize.height);
        this.setSize(Math.max(minSize.width, this._w), Math.max(minSize.height, this._h));
    }

    public void setTextFontSize(int size) {
        this.figTextDrawer.setFontSize(size);
        Dimension minSize = this.getMinimumSize();
        this.figTextDrawer.setSize(minSize.width, minSize.height);
        this.setSize(Math.max(minSize.width, this._w), Math.max(minSize.height, this._h));
    }

    public int getFontSize() {
        return this.figTextDrawer.getFontSize();
    }

    public void setText(String text) {
        this.setTextToTextDrawer(text);
    }

    public String getText() {
        return this.figTextDrawer.getText();
    }

    public void setForeground(Color color) {
        this.figTextDrawer.setTextColor(color);
    }

    public Color getForegroundColor() {
        return this.figTextDrawer.getTextColor();
    }

    public void setBackground(Color color) {
        this.setFillColor(color);
    }

    public Color getBackgroundColor() {
        return this.getFillColor();
    }

    public String toString() {
        return "";
    }

    @Override
    public void setDataInterface(DataInterface data) {
        this.dataInterface = data;
    }
}

