/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.gef;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.tigris.gef.base.Editor;
import org.tigris.gef.presentation.FigRect;
import ro.atreides.gef.DBbridge;
import ro.atreides.gef.FigRestaurant;
import ro.atreides.gef.TextDrawer;
import ro.atreides.gef.data.DataInterface;
import ro.atreides.gef.data.DataInterfaceSetter;
import ro.atreides.gef.utils.gui.DiagramRestaurantInputDialog;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.multilang.LangRoAll;

public class FigRectWithText
extends FigRect
implements MouseListener,
FigRestaurant,
DataInterfaceSetter {
    private static final BasicStroke stroke = new BasicStroke(4.0f);
    protected TextDrawer figTextDrawer;
    protected transient DataInterface dataInterface;
    protected String nume = "";
    protected String detalii = "";
    protected int nrLocs;
    protected boolean virtuala;
    protected String fullDetails;

    public FigRectWithText(DataInterface intrface, int x, int y, int w, int h) {
        super(x, y, w, h);
        this.figTextDrawer = new TextDrawer(x, y, w, h);
        this.dataInterface = intrface;
    }

    public FigRectWithText(DataInterface intrface, int x, int y, int w, int h, Color lColor, Color fColor) {
        super(x, y, w, h, lColor, fColor);
        this.figTextDrawer = new TextDrawer(x, y, w, h);
        this.dataInterface = intrface;
    }

    public FigRectWithText(DataInterface intrface, int x, int y, int w, int h, boolean resizable) {
        super(x, y, w, h, resizable);
        this.figTextDrawer = new TextDrawer(x, y, w, h);
        this.dataInterface = intrface;
    }

    public FigRectWithText(DataInterface intrface, int x, int y, int w, int h, boolean resizable, Color lColor, Color fColor) {
        super(x, y, w, h, resizable, lColor, fColor);
        this.figTextDrawer = new TextDrawer(x, y, w, h);
        this.dataInterface = intrface;
    }

    @Override
    public void paint(Object g) {
        Graphics2D g2d = (Graphics2D)((Graphics)g).create();
        g2d.setStroke(stroke);
        super.paint((Object)g2d);
        g2d.dispose();
        Dimension minSize = this.getMinimumSize();
        int x = this._x + (this._w - minSize.width) / 2;
        int y = this._y + (this._h - minSize.height) / 2;
        this.figTextDrawer.setLocation(x, y);
        this.figTextDrawer.paint(g);
        g2d.dispose();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = this.figTextDrawer.getMinimumSize();
        dim.setSize(dim.getWidth() + 6.0, dim.getHeight() + 5.0);
        return dim;
    }

    @Override
    public Vector getPopUpActions(MouseEvent me) {
        if (!this.isEditorMode()) {
            Vector popUpActions = new Vector(0);
            return popUpActions;
        }
        Vector<JMenuItem> popUpActions = new Vector<JMenuItem>(5);
        JMenuItem stergeItem = new JMenuItem(LangRoAll.sterge);
        stergeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DBbridge modifier = FigRectWithText.this.dataInterface.getDiagramModifier();
                    if (modifier.canDelete(FigRectWithText.this.nume)) {
                        FigRectWithText.this.deleteFromModel();
                    } else {
                        JOptionPane.showMessageDialog(modifier.getMainFrame(), "NU se poate sterge :\"" + FigRectWithText.this.nume + "\"");
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        });
        JMenuItem modificaItem = new JMenuItem(LangRoAll.modifica);
        modificaItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String fullD;
                    boolean vir;
                    DBbridge modifier = FigRectWithText.this.dataInterface.getDiagramModifier();
                    DiagramRestaurantInputDialog dialog = new DiagramRestaurantInputDialog(modifier.getMainFrame(), true, modifier.getMainFrame(), LangRoAll.modifica, FigRectWithText.this.nume, FigRectWithText.this.nrLocs, FigRectWithText.this.virtuala, FigRectWithText.this.fullDetails);
                    String newName = dialog.getInput();
                    if (newName == null) {
                        return;
                    }
                    String nrLocuri = dialog.getNrLocuri();
                    int nrL = 1;
                    if (Validators.correctInteger(nrLocuri)) {
                        nrL = Integer.parseInt(nrLocuri);
                    }
                    if (modifier.canModify(FigRectWithText.this.nume, newName, nrL, vir = dialog.isVirtuala(), fullD = dialog.getDetalii())) {
                        FigRectWithText.this.setNume(newName);
                        FigRectWithText.this.setNrLocuri(nrL);
                        FigRectWithText.this.setVirtuala(vir);
                        FigRectWithText.this.setFullDetails(fullD);
                    } else {
                        JOptionPane.showMessageDialog(modifier.getMainFrame(), "Nu puteti modifica", LangRoAll.eroare, 0);
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        });
        popUpActions.add(stergeItem);
        popUpActions.add(modificaItem);
        return popUpActions;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        try {
            if (!this.isEditorMode()) {
                DBbridge modifier = this.dataInterface.getDiagramModifier();
                modifier.buttonPush(this.nume);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void setTextToTextDrawer() {
        String toSet = this.nume;
        if (Validators.correctString(this.detalii)) {
            toSet = toSet + "\n" + this.detalii;
        }
        this.figTextDrawer.setText(toSet);
        Dimension minSize = this.getMinimumSize();
        this.figTextDrawer.setSize(minSize.width, minSize.height);
        this.setSize(Math.max(minSize.width, this._w), Math.max(minSize.height, this._h));
    }

    public String toString() {
        String toolTip = "";
        return toolTip;
    }

    @Override
    public void setDetalii(String ospatarName) {
        this.detalii = ospatarName != null ? ospatarName : "";
        this.setTextToTextDrawer();
    }

    @Override
    public String getNume() {
        return this.nume;
    }

    @Override
    public void setFontSize(int size) {
        this.figTextDrawer.setFontSize(size);
        Dimension minSize = this.getMinimumSize();
        this.figTextDrawer.setSize(minSize.width, minSize.height);
        this.setSize(Math.max(minSize.width, this._w), Math.max(minSize.height, this._h));
    }

    @Override
    public void setNume(String text) {
        this.nume = text != null ? text : "";
        this.setTextToTextDrawer();
    }

    public boolean isEditorMode() {
        if (this.dataInterface != null) {
            Editor editor = this.dataInterface.getJGraph().getEditor();
            return editor.canSelectElements();
        }
        System.out.println("FigRectWithText.isEditorMode() : dataInterface = null");
        return false;
    }

    @Override
    public void setDataInterface(DataInterface data) {
        this.dataInterface = data;
    }

    @Override
    public void setNrLocuri(int nrL) {
        this.nrLocs = nrL;
    }

    @Override
    public void setVirtuala(boolean v) {
        this.virtuala = v;
    }

    @Override
    public void setFullDetails(String text) {
        this.fullDetails = text;
    }

    public int getNrLocs() {
        return this.nrLocs;
    }

    public boolean isVirtuala() {
        return this.virtuala;
    }

    public String getFullDetails() {
        return this.fullDetails;
    }
}

