/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.gef;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.ModeBroom;
import org.tigris.gef.base.ModeSelect;
import org.tigris.gef.base.SetModeAction;
import org.tigris.gef.ui.ToolBar;
import org.tigris.gef.util.ResourceLoader;
import ro.atreides.gef.DMI;
import ro.atreides.gef.DiagramPanel;
import ro.atreides.gef.ModeCreateFigCircleWithText;
import ro.atreides.gef.ModeCreateFigComment;
import ro.atreides.gef.ModeCreateFigInkModified;
import ro.atreides.gef.ModeCreateFigLineModified;
import ro.atreides.gef.ModeCreateFigRectWithText;
import ro.atreides.gef.ModeCreateHotelRectWithText;
import ro.atreides.gef.SetModeActionComment;
import ro.atreides.gef.SetModeActionRestaurant;
import ro.atreides.gef.data.DataInterface;
import ro.atreides.gef.data.DataInterfaceImpl;
import ro.atreides.gef.utils.FigAdder;
import ro.atreides.gef.utils.xml.XmlUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.multilang.LangRoAll;

public class PaletteRestaurant
extends ToolBar {
    private DiagramPanel diagramPanel;

    public PaletteRestaurant(DataInterface intrface, DiagramPanel panel) {
        this.diagramPanel = panel;
        this.defineButtons(intrface);
    }

    private void defineButtons(DataInterface inter) {
        this.add(new JLabel("Arrange: "));
        this.add(new SetModeAction(ModeSelect.class, "Select", "", LangRoAll.selectie, ResourceLoader.lookupIconResource("Select")));
        this.add(new SetModeAction(ModeBroom.class, "Broom", "", "Aliniere", ResourceLoader.lookupIconResource("Broom")));
        this.addSeparator();
        this.add(new JLabel("Restaurant table: "));
        this.add(new SetModeActionRestaurant(inter, ModeCreateFigCircleWithText.class, "Cerc", "", "Cerc", ResourceLoader.lookupIconResource("Connector")));
        this.add(new SetModeActionRestaurant(inter, ModeCreateFigRectWithText.class, "Patrat", "", "Patrat", ResourceLoader.lookupIconResource("Process")));
        this.addSeparator();
        this.add(new JLabel("Hotel room: "));
        this.add(new SetModeActionRestaurant(inter, ModeCreateHotelRectWithText.class, "Patrat", "", "Patrat", ResourceLoader.lookupIconResource("Process")));
        this.addSeparator();
        this.add(new JLabel("Drawing: "));
        this.add(new SetModeActionComment(inter, ModeCreateFigComment.class, "Text", "", "Text", ResourceLoader.lookupIconResource("Text")));
        this.add(new SetModeAction(ModeCreateFigLineModified.class, "Linie", "", "Linie", ResourceLoader.lookupIconResource("Line")));
        this.add(new SetModeAction(ModeCreateFigInkModified.class, "MultiLine", "", "MultiLine", ResourceLoader.lookupIconResource("Ink")));
        this.addSeparator();
        this.add(new JLabel("Utils: "));
        JButton saveToDisk = new JButton("Salveaza pe disk");
        saveToDisk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor editor;
                String destFile = FileDialog.getSaveDialogLocation(null, "Alegeti fisierul destinatie", "xml");
                if (destFile != null && !XmlUtils.saveFigures(destFile, editor = PaletteRestaurant.this.diagramPanel.getEditor())) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Salvare esuata", "Eroare!");
                }
            }
        });
        this.add(saveToDisk);
        JButton loadFromDisk = new JButton("Incarca de pe disk");
        loadFromDisk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputFile = FileDialog.getLoadDialogLocation(null, "Selectati fisierul diagrama", "xml");
                if (inputFile != null) {
                    Frame f = GuiUtils.getFrameForComponent(PaletteRestaurant.this.diagramPanel);
                    Editor editor = PaletteRestaurant.this.diagramPanel.getEditor();
                    Vector figures = XmlUtils.getFigures(inputFile, new DataInterfaceImpl(PaletteRestaurant.this.diagramPanel.getGraph(), new DMI(f)));
                    if (figures != null) {
                        FigAdder.removeAllFigs(editor);
                        FigAdder.addFigs(editor, figures);
                        DialogUtils.okDialog(GuiUtils.currentFrame, "Salvati pentru incarcarea diagramei", LangRoAll.atentie);
                    } else {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, "Diagrama invalida", "Incercati din nou");
                    }
                } else {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Fisier incorect", "Eroare!");
                }
            }
        });
        this.add(loadFromDisk);
    }

    public static void save() {
    }
}

