/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.gef.utils.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import ro.atreides.utils.multilang.LangRoAll;

public class DiagramRestaurantInputDialog
extends JDialog {
    private String input = null;
    private String newNrLocuri = null;
    private String detalii = "";
    private JTextField numeText;
    private JTextField locuriText;
    private JTextField detaliiText;
    private JButton ok;
    private JCheckBox virtualaCheckbox;
    private boolean virtuala;

    public DiagramRestaurantInputDialog(Component parent, boolean modal, Frame parentFrame, String title, String defaultText, int nrLocuri, boolean virtuala, String detalii) {
        super(parentFrame, title, modal);
        this.init(defaultText, nrLocuri, virtuala, detalii);
        this.display();
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void init(String defaultText, int nrLocuri, boolean virtuala, String detalii) {
        this.numeText = new JTextField(10);
        this.numeText.setText(defaultText);
        this.numeText.select(0, defaultText.length());
        this.locuriText = new JTextField(10);
        this.locuriText.setText("" + nrLocuri);
        this.locuriText.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DiagramRestaurantInputDialog.this.saveData();
                    DiagramRestaurantInputDialog.this.dispose();
                } else if (e.getKeyCode() == 27) {
                    DiagramRestaurantInputDialog.this.dispose();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.virtualaCheckbox = new JCheckBox();
        this.virtualaCheckbox.setSelected(virtuala);
        this.detaliiText = new JTextField(30);
        this.detaliiText.setText(detalii);
        this.ok = new JButton("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagramRestaurantInputDialog.this.saveData();
                DiagramRestaurantInputDialog.this.dispose();
            }
        });
    }

    private void saveData() {
        this.input = this.numeText.getText();
        this.newNrLocuri = this.locuriText.getText();
        this.virtuala = this.virtualaCheckbox.isSelected();
        this.detalii = this.detaliiText.getText();
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 0.5;
        c.insets = new Insets(10, 10, 10, 10);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)new JLabel("Nume"), c);
        ++c.gridx;
        this.add((Component)this.numeText, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Locuri"), c);
        ++c.gridx;
        this.add((Component)this.locuriText, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Virtuala"), c);
        ++c.gridx;
        this.add((Component)this.virtualaCheckbox, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel(LangRoAll.detalii), c);
        ++c.gridx;
        this.add((Component)this.detaliiText, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        this.add((Component)this.ok, c);
    }

    public String getInput() {
        return this.input;
    }

    public String getNrLocuri() {
        return this.newNrLocuri;
    }

    public String getDetalii() {
        return this.detalii;
    }

    public boolean isVirtuala() {
        return this.virtuala;
    }
}

