/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.gef.utils.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FontChangerDialog
extends JDialog {
    private int fontSize = -1;
    private static final String[] s = new String[]{"10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40"};

    public FontChangerDialog(Component parent, boolean modal, Frame parentFrame, String title, int defaultSize) {
        super(parentFrame, title, modal);
        this.init(defaultSize);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void init(int defaultSize) {
        JLabel label = new JLabel("Font Size");
        final JComboBox<String> boxSizes = new JComboBox<String>(s);
        boxSizes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("item selected = " + boxSizes.getSelectedItem());
            }
        });
        if (defaultSize >= 10 && defaultSize <= 40) {
            boxSizes.setSelectedIndex(defaultSize - 10);
        }
        JPanel buttonsPanel = new JPanel();
        JButton saveButton = new JButton("OK");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String sizeSelected = (String)boxSizes.getSelectedItem();
                    FontChangerDialog.this.fontSize = Integer.parseInt(sizeSelected);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
                FontChangerDialog.this.dispose();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChangerDialog.this.dispose();
            }
        });
        buttonsPanel.add(saveButton);
        buttonsPanel.add(cancelButton);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 21;
        c.weightx = 0.5;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        this.add((Component)label, c);
        c.gridx = 1;
        c.gridy = 0;
        this.add(boxSizes, c);
        c.insets = new Insets(5, 5, 2, 5);
        c.ipadx = 0;
        c.ipady = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weighty = 0.5;
        c.fill = 0;
        c.anchor = 22;
        this.add((Component)buttonsPanel, c);
    }

    public int getSelectedFontSize() {
        return this.fontSize;
    }

    public void getSelectedPort() {
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame("skdjf");
        frame.setDefaultCloseOperation(3);
        final JButton button = new JButton("button");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new FontChangerDialog(button, true, frame, "Font Size", 15);
            }
        });
        frame.add(button);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

