/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.jocuri;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.jocuri.AlertListener;
import ro.atreides.jocuri.JocuriThread;
import ro.atreides.jocuri.MasaJocuri;
import ro.atreides.jocuri.db.JocuriDao;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.Logger;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;

public class JocuriLogic
extends EventGenerator {
    private static JocuriLogic instance;
    private Hashtable threads;
    public static final long CHECK_INTERVAL = 5000L;
    public static final long ALERT_BEFORE = 600000L;
    private ConnectionPool pool = ConnectionPool.getInstance();

    private JocuriLogic() {
        this.threads = new Hashtable();
    }

    public static synchronized JocuriLogic getInstance() {
        if (instance == null) {
            instance = new JocuriLogic();
        }
        return instance;
    }

    private synchronized JocuriDao getJocuriDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        JocuriDao dao = null;
        while (dao == null) {
            dao = (JocuriDao)this.pool.getDao(JocuriDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(JocuriDao.class.getName(), connection);
        }
        return dao;
    }

    public Vector getMese() {
        try {
            Vector result = this.getJocuriDao().getTables();
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            return result;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return new Vector();
        }
    }

    public void closeDay() {
    }

    public void addMasa(String label) {
        try {
            this.getJocuriDao().addTable(label);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void deleteMasa(int id) {
        try {
            this.stopMasa(id);
            this.getJocuriDao().deleteTable(id);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public long startMasa(int id, long durataMillis, long startTime, AlertListener listener) {
        try {
            this.getJocuriDao().startTable(id, startTime, durataMillis);
            JocuriThread th = new JocuriThread(this, 5000L, id, 600000L, listener);
            th.start();
            this.threads.put("" + id, th);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            return startTime + durataMillis;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return -1L;
        }
    }

    public void recoverTable(int id, AlertListener listener) {
        JocuriThread th = (JocuriThread)this.threads.get(id + "");
        if (th == null) {
            th = new JocuriThread(this, 5000L, id, 600000L, listener);
            th.start();
            this.threads.put("" + id, th);
        }
    }

    public long updateMasa(int id, long millisToAdd) {
        try {
            this.getJocuriDao().updateTable(id, millisToAdd);
            MasaJocuri m = this.getMasaById(id);
            long stop = m.getStop();
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            return stop;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return -1L;
        }
    }

    public String getTimpConsumatString(int id) {
        MasaJocuri mj = this.getMasaById(id);
        long start = mj.getStart();
        String result = DateUtils.getDiferentaIntreOre(start, System.currentTimeMillis());
        return result;
    }

    public void stopMasa(int id) {
        try {
            this.getJocuriDao().stopTable(id);
            JocuriThread th = (JocuriThread)this.threads.get("" + id);
            if (th != null) {
                th.stopRunning();
                this.threads.remove("" + id);
            }
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public MasaJocuri getMasaById(int id) {
        try {
            MasaJocuri result = this.getJocuriDao().getTableById(id);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            return result;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return null;
        }
    }
}

