/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.jocuri.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.border.TitledBorder;
import ro.atreides.jocuri.JocuriLogic;
import ro.atreides.jocuri.MasaJocuri;
import ro.atreides.jocuri.gui.MasaEntry;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.config.Config;

public class MeseGui
extends ReflectedJPanel {
    private JocuriLogic logic = JocuriLogic.getInstance();

    public void display(Vector mese, int mesePerLine) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        int i = 1;
        for (MasaJocuri element : mese) {
            MasaEntry current = new MasaEntry(element);
            if (element.getStart() != -1L) {
                current.start(element.getStart(), element.getDurata(), element.getStop());
                this.logic.recoverTable(element.getId(), current);
            }
            current.setBorder(new TitledBorder(element.getLabel()));
            this.add((Component)current, c);
            ++c.gridx;
            if (i % mesePerLine == 0) {
                ++c.gridy;
                c.gridx = 0;
            }
            ++i;
        }
    }

    @Override
    public void doStuff() {
        this.init();
    }

    private void init() {
        int mesePerLine = Config.getInstance().getInt("jocuriMesePerLine");
        this.display(this.logic.getMese(), mesePerLine);
    }
}

