/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.monitor.gui;

import java.io.Serializable;

public class DiskPanelEntry
implements Serializable {
    private String label;
    private String freeSpace;
    private boolean monitor;
    private int warning;
    private int critical;
    private boolean isWarning;
    private boolean isCritical;

    public String getFreeSpace() {
        return this.freeSpace;
    }

    public void setFreeSpace(long kbytes) {
        long value = kbytes;
        String suffix = " KB";
        if (value > 0x100000L) {
            value /= 0x100000L;
            suffix = " GB";
        } else if (value > 1024L) {
            value /= 1024L;
            suffix = " MB";
        }
        this.freeSpace = value + suffix;
        int mega = (int)(kbytes / 1024L);
        if (mega < this.warning) {
            this.isWarning = true;
        } else {
            this.isWarning = false;
            this.isCritical = false;
        }
        this.isCritical = mega < this.critical;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isMonitor() {
        return this.monitor;
    }

    public void setMonitor(boolean monitor) {
        this.monitor = monitor;
    }

    public int getWarning() {
        return this.warning;
    }

    public void setWarning(int warning) {
        this.warning = warning;
    }

    public int getCritical() {
        return this.critical;
    }

    public void setCritical(int critical) {
        this.critical = critical;
    }

    public void setWarning(boolean value) {
        this.isWarning = value;
    }

    public void setCritical(boolean value) {
        this.isCritical = value;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public boolean isCritical() {
        return this.isCritical;
    }
}

