/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.monitor.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ro.atreides.monitor.gui.EditableStateListener;
import ro.atreides.monitor.gui.ReteaPanelCellRenderer;
import ro.atreides.monitor.gui.ReteaPanelEntry;
import ro.atreides.monitor.gui.TimeGetter;
import ro.atreides.monitor.gui.TimePanel;
import ro.atreides.monitor.logic.ReteaLogic;
import ro.atreides.monitor.threads.ReteaMonitorThread;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class ReteaPanel
extends AbstractListPanel
implements EditableStateListener {
    private static final String[] columns = new String[]{"host", "port", "Monitor"};
    private ReteaPanelCellRenderer renderer;
    private AbstractTM model;
    private TimePanel timePanel;
    private boolean isEditMode = false;

    public ReteaPanel() {
        this.doStuff();
        this.initialize();
        this.setPreferredSize(new Dimension(200, 100));
        this.setMinimumSize(this.getPreferredSize());
    }

    private Class[] getTypes() {
        return new Class[]{String.class, String.class, Boolean.class};
    }

    @Override
    public AbstractTM buildTableModel() {
        this.model = new AbstractTM(columns, this.getTypes(), new TmInterface(){

            @Override
            public Object getValueAt(int i, int i1, Vector vector) {
                ReteaPanelEntry e = (ReteaPanelEntry)vector.elementAt(i);
                switch (i1) {
                    case 0: {
                        return e.getHost();
                    }
                    case 1: {
                        return e.getPort();
                    }
                    case 2: {
                        return e.isMonitor();
                    }
                }
                return "out of bounds";
            }

            @Override
            public boolean isCellEditable(int i, int i1) {
                return ReteaPanel.this.isEditMode;
            }

            @Override
            public void setValueAt(Object o, int i, int i1, Vector vector) {
                ReteaPanelEntry e = (ReteaPanelEntry)vector.elementAt(i);
                switch (i1) {
                    case 0: {
                        e.setHost((String)o);
                        break;
                    }
                    case 1: {
                        e.setPort((String)o);
                        break;
                    }
                    case 2: {
                        e.setMonitor((Boolean)o);
                        break;
                    }
                }
                ReteaPanel.this.tm.fireTableRowsUpdated(i, i);
            }
        });
        this.renderer = new ReteaPanelCellRenderer(this.model);
        return this.model;
    }

    public AbstractTM getModel() {
        return this.model;
    }

    private void updateJTableColumns(JTable unu) {
        TableColumnModel colModel = unu.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            if (column.getHeaderValue().equals("Monitor")) continue;
            column.setCellRenderer(this.renderer);
        }
    }

    @Override
    public JPanel getBottomPanel() {
        return null;
    }

    @Override
    public Vector buildData() {
        return ReteaLogic.getVectorOfEntry();
    }

    @Override
    public String[] buildColumns() {
        return columns;
    }

    @Override
    public Class[] buildTypes() {
        return this.getTypes();
    }

    @Override
    public void doStuff() {
        this.display();
        this.updateJTableColumns(this.table);
    }

    public TimeGetter getTimeGetter() {
        return this.timePanel;
    }

    private void initialize() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 10;
        c.fill = 0;
        panel.add((Component)new JLabel("Verifica "), c);
        c.gridx = 1;
        c.gridy = 0;
        this.timePanel = new TimePanel();
        this.timePanel.setTime(ReteaLogic.getHours(), ReteaLogic.getMinutes());
        this.timePanel.setEditableMode(false);
        panel.add((Component)this.timePanel, c);
        c.gridx = 2;
        JButton buttonRefresh = new JButton(LangRoAll.verifica);
        final ReteaMonitorThread thread = new ReteaMonitorThread(this);
        buttonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                thread.refresh();
            }
        });
        panel.add((Component)buttonRefresh, c);
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)panel, c);
        thread.start();
    }

    @Override
    public void setEditable(boolean editable) {
        this.isEditMode = editable;
        this.timePanel.setEditableMode(editable);
    }

    @Override
    public void saveConfigurations() {
        ReteaLogic.saveConfigurationData(this.getModel().getData(), this.timePanel);
    }
}

