/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.monitor.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import ro.atreides.monitor.gui.EditableStateListener;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.LoginDialog;

public class SaveModifyPanel
extends JPanel {
    private static final String MODIFY_STATE = "Modifica Setari";
    private static final String SAVE_STATE = "Salveaza Setari";
    private Vector listeners = new Vector();

    public SaveModifyPanel() {
        this.initialize();
    }

    public void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 19;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 2, 0, 2);
        final JButton buttonModificaSalveaza = new JButton(MODIFY_STATE);
        buttonModificaSalveaza.setForeground(Color.BLUE);
        buttonModificaSalveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog dialog = new LoginDialog((Frame)GuiUtils.currentFrame, true);
                String user = dialog.getUserName();
                String passwd = dialog.getPassword();
                String cod = dialog.getCodAutentificare();
                if ((user == null || user.length() == 0 || passwd == null || passwd.length() == 0) && cod.length() == 0) {
                    return;
                }
                User supervizor = UsersLogic.getInstance().getUser(user, passwd, cod, true, true);
                if (UsersLogic.getInstance().isUserInGroup(supervizor.getId(), "group_bo_users")) {
                    try {
                        String text = buttonModificaSalveaza.getText();
                        if (text.equals(SaveModifyPanel.MODIFY_STATE)) {
                            for (Object o : SaveModifyPanel.this.listeners) {
                                if (!(o instanceof EditableStateListener)) continue;
                                ((EditableStateListener)o).setEditable(true);
                            }
                            buttonModificaSalveaza.setText(SaveModifyPanel.SAVE_STATE);
                            buttonModificaSalveaza.setForeground(Color.RED);
                        } else if (text.equals(SaveModifyPanel.SAVE_STATE)) {
                            for (Object o : SaveModifyPanel.this.listeners) {
                                if (!(o instanceof EditableStateListener)) continue;
                                ((EditableStateListener)o).saveConfigurations();
                                ((EditableStateListener)o).setEditable(false);
                            }
                            buttonModificaSalveaza.setText(SaveModifyPanel.MODIFY_STATE);
                            buttonModificaSalveaza.setForeground(Color.BLUE);
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.add((Component)buttonModificaSalveaza, c);
    }

    public void addEditableStateListener(EditableStateListener listener) {
        this.listeners.add(listener);
    }
}

