/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.monitor.logic;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.monitor.gui.DiskPanelEntry;
import ro.atreides.monitor.gui.TimeGetter;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Logger;

public class DiskLogic {
    private static final String pathToDiskConfigFile = "diskconfig.bin";
    private static final int KEY_HASHTABLE = 0;
    private static final int KEY_HOURS = 1;
    private static final int KEY_MINUTES = 2;

    public static synchronized Hashtable loadConfigurationData() {
        Object obj = ro.atreides.monitor.util.FileUtils.loadParametersFromFile(pathToDiskConfigFile);
        if (obj instanceof Hashtable) {
            return (Hashtable)obj;
        }
        return null;
    }

    public static synchronized void saveConfigurationData(Hashtable hashTable, TimeGetter time) {
        Hashtable<Integer, Serializable> table = new Hashtable<Integer, Serializable>();
        table.put(0, hashTable);
        table.put(1, Integer.valueOf(time.getHours()));
        table.put(2, Integer.valueOf(time.getMinutes()));
        ro.atreides.monitor.util.FileUtils.saveParametersToFile(pathToDiskConfigFile, table);
    }

    private static Object getParameter(Object key) {
        Hashtable table = DiskLogic.loadConfigurationData();
        if (table != null && key != null) {
            return table.get(key);
        }
        return null;
    }

    public static Vector getVectorOfEntry() {
        Hashtable table = (Hashtable)DiskLogic.getParameter(0);
        Vector<DiskPanelEntry> vector = new Vector<DiskPanelEntry>();
        File[] roots = File.listRoots();
        Vector allPartitions = new Vector();
        try {
            allPartitions = FileUtils.getUnixPartitions();
        }
        catch (IOException e) {
            Logger.logException("DiskLogic", (Exception)e);
        }
        for (int i = 0; i < allPartitions.size(); ++i) {
            String root = (String)allPartitions.elementAt(i);
            File rootFile = new File(root);
            DiskPanelEntry entry = null;
            if (table != null && (entry = (DiskPanelEntry)table.get(root)) != null) {
                entry.setFreeSpace(FileUtils.getFreeSpace(rootFile));
            }
            if (entry == null) {
                entry = new DiskPanelEntry();
                entry.setLabel(root);
                entry.setWarning(2048);
                entry.setCritical(512);
                entry.setFreeSpace(FileUtils.getFreeSpace(rootFile));
                entry.setMonitor(true);
            }
            vector.add(entry);
        }
        return vector;
    }

    public static int getHours() {
        Object obj = DiskLogic.getParameter(1);
        return obj == null ? 1 : (Integer)obj;
    }

    public static int getMinutes() {
        Object obj = DiskLogic.getParameter(2);
        return obj == null ? 0 : (Integer)obj;
    }
}

