/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.monitor.logic;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.monitor.gui.ReteaPanelEntry;
import ro.atreides.monitor.gui.TimeGetter;
import ro.atreides.monitor.util.FileUtils;

public class ReteaLogic {
    private static final String pathToReteaConfig = "reteaconfig.bin";
    private static final int KEY_VECTOR = 0;
    private static final int KEY_HOURS = 1;
    private static final int KEY_MINUTES = 2;

    public static synchronized Hashtable loadConfigurationData() {
        Object obj = FileUtils.loadParametersFromFile(pathToReteaConfig);
        if (obj instanceof Hashtable) {
            return (Hashtable)obj;
        }
        return null;
    }

    public static synchronized void saveConfigurationData(Vector vector, TimeGetter time) {
        System.out.println("save: hours = " + time.getHours() + ", minutes = " + time.getMinutes());
        Hashtable<Integer, Serializable> table = new Hashtable<Integer, Serializable>();
        table.put(0, vector);
        table.put(1, Integer.valueOf(time.getHours()));
        table.put(2, Integer.valueOf(time.getMinutes()));
        FileUtils.saveParametersToFile(pathToReteaConfig, table);
    }

    private static Object getParameter(Object key) {
        Hashtable table = ReteaLogic.loadConfigurationData();
        if (table != null && key != null) {
            return table.get(key);
        }
        return null;
    }

    public static Vector getVectorOfEntry() {
        Vector<ReteaPanelEntry> vector = (Vector<ReteaPanelEntry>)ReteaLogic.getParameter(0);
        if (vector != null) {
            for (ReteaPanelEntry entry : vector) {
                entry.setReachable(false);
                entry.setUnknown(true);
            }
        } else {
            vector = new Vector<ReteaPanelEntry>();
            ReteaPanelEntry oneEntry = new ReteaPanelEntry();
            oneEntry.setHost("yahoo.com");
            oneEntry.setPort("80");
            oneEntry.setMonitor(true);
            oneEntry.setUnknown(true);
            vector.add(oneEntry);
            oneEntry = new ReteaPanelEntry();
            oneEntry.setHost("gestiunerestaurant.ro");
            oneEntry.setPort("80");
            oneEntry.setMonitor(true);
            oneEntry.setUnknown(true);
            vector.add(oneEntry);
            for (int i = 2; i < 20; ++i) {
                oneEntry = new ReteaPanelEntry();
                oneEntry.setHost("");
                oneEntry.setPort("");
                oneEntry.setUnknown(true);
                vector.add(oneEntry);
            }
        }
        return vector;
    }

    public static int getHours() {
        Object obj = ReteaLogic.getParameter(1);
        return obj == null ? 1 : (Integer)obj;
    }

    public static int getMinutes() {
        Object obj = ReteaLogic.getParameter(2);
        return obj == null ? 0 : (Integer)obj;
    }
}

