/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.monitor.test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FormattedTextFieldDemo
extends JPanel
implements PropertyChangeListener {
    private double amount = 100000.0;
    private double rate = 7.5;
    private int numPeriods = 30;
    private JLabel amountLabel;
    private JLabel rateLabel;
    private JLabel numPeriodsLabel;
    private JLabel paymentLabel;
    private static String amountString = "Loan Amount: ";
    private static String rateString = "APR (%): ";
    private static String numPeriodsString = "Years: ";
    private static String paymentString = "Monthly Payment: ";
    private JFormattedTextField amountField;
    private JFormattedTextField rateField;
    private JFormattedTextField numPeriodsField;
    private JFormattedTextField paymentField;
    private NumberFormat amountFormat;
    private NumberFormat percentFormat;
    private NumberFormat paymentFormat;

    public FormattedTextFieldDemo() {
        super(new BorderLayout());
        this.setUpFormats();
        double payment = this.computePayment(this.amount, this.rate, this.numPeriods);
        this.amountLabel = new JLabel(amountString);
        this.rateLabel = new JLabel(rateString);
        this.numPeriodsLabel = new JLabel(numPeriodsString);
        this.paymentLabel = new JLabel(paymentString);
        this.amountField = new JFormattedTextField(this.amountFormat);
        this.amountField.setValue(new Double(this.amount));
        this.amountField.setColumns(10);
        this.amountField.addPropertyChangeListener("value", this);
        this.rateField = new JFormattedTextField(this.percentFormat);
        this.rateField.setValue(new Double(this.rate));
        this.rateField.setColumns(10);
        this.rateField.addPropertyChangeListener("value", this);
        this.numPeriodsField = new JFormattedTextField();
        this.numPeriodsField.setValue(new Integer(this.numPeriods));
        this.numPeriodsField.setColumns(10);
        this.numPeriodsField.addPropertyChangeListener("value", this);
        this.paymentField = new JFormattedTextField(this.paymentFormat);
        this.paymentField.setValue(new Double(payment));
        this.paymentField.setColumns(10);
        this.paymentField.setEditable(false);
        this.paymentField.setForeground(Color.red);
        this.amountLabel.setLabelFor(this.amountField);
        this.rateLabel.setLabelFor(this.rateField);
        this.numPeriodsLabel.setLabelFor(this.numPeriodsField);
        this.paymentLabel.setLabelFor(this.paymentField);
        JPanel labelPane = new JPanel(new GridLayout(0, 1));
        labelPane.add(this.amountLabel);
        labelPane.add(this.rateLabel);
        labelPane.add(this.numPeriodsLabel);
        labelPane.add(this.paymentLabel);
        JPanel fieldPane = new JPanel(new GridLayout(0, 1));
        fieldPane.add(this.amountField);
        fieldPane.add(this.rateField);
        fieldPane.add(this.numPeriodsField);
        fieldPane.add(this.paymentField);
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.add((Component)labelPane, "Center");
        this.add((Component)fieldPane, "After");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object source = e.getSource();
        if (source == this.amountField) {
            this.amount = ((Number)this.amountField.getValue()).doubleValue();
        } else if (source == this.rateField) {
            this.rate = ((Number)this.rateField.getValue()).doubleValue();
        } else if (source == this.numPeriodsField) {
            this.numPeriods = ((Number)this.numPeriodsField.getValue()).intValue();
        }
        double payment = this.computePayment(this.amount, this.rate, this.numPeriods);
        this.paymentField.setValue(new Double(payment));
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("FormattedTextFieldDemo");
        frame.setDefaultCloseOperation(3);
        frame.add(new FormattedTextFieldDemo());
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIManager.put("swing.boldMetal", Boolean.FALSE);
                FormattedTextFieldDemo.createAndShowGUI();
            }
        });
    }

    double computePayment(double loanAmt, double rate, int numPeriods) {
        double denominator;
        numPeriods *= 12;
        if (rate > 0.01) {
            double I = rate / 100.0 / 12.0;
            double partial1 = Math.pow(1.0 + I, 0.0 - (double)numPeriods);
            denominator = (1.0 - partial1) / I;
        } else {
            denominator = numPeriods;
        }
        double answer = -1.0 * loanAmt / denominator;
        return answer;
    }

    private void setUpFormats() {
        this.amountFormat = NumberFormat.getNumberInstance();
        this.percentFormat = NumberFormat.getNumberInstance();
        this.percentFormat.setMinimumFractionDigits(3);
        this.paymentFormat = NumberFormat.getCurrencyInstance();
    }
}

