/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.monitor.threads;

import java.util.Iterator;
import java.util.Vector;
import ro.atreides.monitor.gui.ReteaPanel;
import ro.atreides.monitor.gui.ReteaPanelEntry;
import ro.atreides.monitor.gui.TimeGetter;
import ro.atreides.monitor.ping.HostReachable;
import ro.atreides.monitor.threads.MonitorThread;
import ro.atreides.utils.gui.table.AbstractTM;

public class ReteaMonitorThread
extends MonitorThread {
    private ReteaPanel reteaPanel;
    private Long nextChek = System.currentTimeMillis() + 10000L;
    private static final int SLEEPTIME = 800;

    public ReteaMonitorThread(ReteaPanel panel) {
        this.reteaPanel = panel;
        this.MIN_SLEEP_TIME = 10000L;
        this.nextChek = System.currentTimeMillis() + this.getSleepTime();
    }

    @Override
    public void run() {
        while (true) {
            if (this.nextChek < System.currentTimeMillis()) {
                this.nextChek = System.currentTimeMillis() + this.getSleepTime();
                this.refresh(this.reteaPanel.getModel());
                continue;
            }
            this.sleepSome(800L);
        }
    }

    @Override
    protected long getSleepTime() {
        TimeGetter getter = this.reteaPanel.getTimeGetter();
        long time = (getter.getHours() * 60 + getter.getMinutes()) * 60 * 1000;
        return Math.max(this.MIN_SLEEP_TIME, time);
    }

    @Override
    public void refresh() {
        this.nextChek = System.currentTimeMillis();
    }

    private synchronized void refresh(AbstractTM model) {
        try {
            ReteaPanelEntry entry;
            Vector vector = model.getData();
            Iterator iterator = vector.iterator();
            int k = 0;
            while (iterator.hasNext()) {
                entry = (ReteaPanelEntry)iterator.next();
                if (entry.isMonitor()) {
                    entry.setUnknown(true);
                    model.fireTableRowsUpdated(k, k);
                }
                ++k;
            }
            iterator = vector.iterator();
            k = 0;
            while (iterator.hasNext() && this.nextChek >= System.currentTimeMillis()) {
                entry = (ReteaPanelEntry)iterator.next();
                if (entry.isMonitor()) {
                    entry.setReachable(HostReachable.isReachable(entry.getHost(), entry.getPort()));
                    model.fireTableRowsUpdated(k, k);
                }
                ++k;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

