/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.nomenclatura;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.PowerSearchProduct;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.ProductAttribute;
import ro.atreides.nomenclatura.ProductIcon;
import ro.atreides.nomenclatura.ProductWithPrice;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.nomenclatura.SectieEntry;
import ro.atreides.nomenclatura.db.CategoriesImpl;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.Logger;
import ro.atreides.utils.SectiiProvider;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.documente.DocumenteLogic;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.sql.SqlUtils;

public class NomeclaturaLogic
extends EventGenerator
implements SectiiProvider {
    private static NomeclaturaLogic instance = null;
    private ConnectionPool pool;
    private Vector allProducts = new Vector();
    private Hashtable allProductsHash = new Hashtable();
    private Hashtable productByIdHash = new Hashtable();
    private Hashtable powerProducts = new Hashtable();
    private boolean mustRefreshPowerProducts = true;
    public static Comparator FORCED_ORDER__CATEGORIES_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return NomeclaturaLogic.compareCategoriiForcedOrder(o1, o2);
        }
    };

    public static synchronized NomeclaturaLogic getInstance() {
        if (instance == null) {
            instance = new NomeclaturaLogic();
        }
        return instance;
    }

    private NomeclaturaLogic() {
        this.pool = ConnectionPool.getInstance();
        this.buildProducts();
    }

    private synchronized CategoriesImpl getCategoriesImpl() {
        ConnectionWrapper connection = this.pool.requestConnection();
        CategoriesImpl dao = null;
        while (dao == null) {
            dao = (CategoriesImpl)this.pool.getDao(CategoriesImpl.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(CategoriesImpl.class.getName(), connection);
        }
        return dao;
    }

    public void cleanupCategories() throws SQLException {
        this.getCategoriesImpl().deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Sectie> getAllSectii() {
        Vector<Sectie> result = new Vector();
        try {
            result = this.getAllSectiiNoCommit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Vector<Sectie> getAllSectiiNoCommit() throws SQLException {
        return this.getCategoriesImpl().getSectii();
    }

    public Sectie getSectieByNameNoCommit(String categoryName) throws SQLException {
        return this.getCategoriesImpl().getSectieByName(categoryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sectie getSectieByName(String categoryName) {
        Sectie result = null;
        try {
            result = this.getSectieByNameNoCommit(categoryName);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Sectie getSectieByIdNoCommit(Integer id) throws SQLException {
        return this.getCategoriesImpl().getSectieById(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sectie getSectieById(Integer id) {
        Sectie result = null;
        try {
            result = this.getSectieByIdNoCommit(id);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sectie getSectieByCod(int cod) {
        Sectie result = null;
        try {
            result = this.getCategoriesImpl().getSectieByCod(cod);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSectie(String label, int cod, String analitic, String analiticTva) {
        int id = -1;
        try {
            this.getCategoriesImpl().addSectie(label, analitic, analiticTva);
            id = this.pool.requestConnection().getIndentityLocal();
            this.getCategoriesImpl().setCodForSectie(id, cod);
            this.pool.requestConnection().commitTransaction();
            this.notifyListeners(0);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return id;
    }

    public int addSectieNoCommit(String label, String analitic, String analiticTva) throws SQLException {
        this.getCategoriesImpl().addSectie(label, analitic, analiticTva);
        int id = this.pool.requestConnection().getIndentityLocal();
        this.getCategoriesImpl().setCodForSectie(id, id);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSectie(String label, String analitic, String analiticTva) {
        try {
            int id = this.addSectieNoCommit(label, analitic, analiticTva);
            this.pool.requestConnection().commitTransaction();
            this.notifyListeners(0);
            int n = id;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            int n = -1;
            return n;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getCategorii(Integer cat, Comparator comparator) {
        Vector result = new Vector();
        try {
            result = this.getCategoriesImpl().getCategorii(cat);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        Collections.sort(result, comparator);
        return result;
    }

    public Vector<Categorie> getCategoriiNaturalOrder(Vector<String> sectii) {
        return this.getCategoriiInSectii(sectii, new Comparator(){

            public int compare(Object o1, Object o2) {
                return NomeclaturaLogic.compareCategorii(o1, o2);
            }
        });
    }

    public Vector<Categorie> getCategoriiForcedOrder(Vector<String> sectii) {
        return this.getCategoriiInSectii(sectii, FORCED_ORDER__CATEGORIES_COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<Categorie> getCategoriiInSectii(Vector<String> sectii, Comparator comparator) {
        Vector<Categorie> result = new Vector<Categorie>();
        try {
            for (String sectie : sectii) {
                Sectie sectie1 = this.getSectieByNameNoCommit(sectie);
                if (sectie1 == null) continue;
                Vector addNow = this.getCategoriesImpl().getCategorii(sectie1.getId());
                result.addAll(addNow);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        Collections.sort(result, comparator);
        return result;
    }

    public Vector getCategoriiNaturalOrder(Integer cat) {
        return this.getCategorii(cat, new Comparator(){

            public int compare(Object o1, Object o2) {
                return NomeclaturaLogic.compareCategorii(o1, o2);
            }
        });
    }

    public static int compareCategorii(Object o1, Object o2) {
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        Categorie s1 = (Categorie)o1;
        Categorie s2 = (Categorie)o2;
        int result = s1.getName().compareTo(s2.getName());
        return result;
    }

    public Vector getCategoriiForcedOrder(Integer cat) {
        return this.getCategorii(cat, FORCED_ORDER__CATEGORIES_COMPARATOR);
    }

    public static int compareCategoriiForcedOrder(Object o1, Object o2) {
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        Categorie s1 = (Categorie)o1;
        Categorie s2 = (Categorie)o2;
        int result = s1.getNrOrdine() - s2.getNrOrdine();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getCategorii() {
        Vector result = new Vector();
        try {
            result = this.getCategoriesImpl().getAllSubcategories();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSectieName2Categories(Collection<Categorie> categories) {
        try {
            for (Categorie category : categories) {
                Sectie sec = this.getSectieByCategoryIdNoCommit(category.getId());
                category.setNumeSectie(sec.getName());
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Sectie, Vector<Categorie>> arrangeCategoriesBySectii(Collection<Categorie> categories) {
        Map<Sectie, Vector<Categorie>> result = Collections.synchronizedMap(new LinkedHashMap());
        try {
            for (Categorie category : categories) {
                Sectie sec = this.getSectieByCategoryIdNoCommit(category.getSectie());
                Vector<Categorie> catsForSectie = result.get(sec);
                if (catsForSectie == null) {
                    catsForSectie = new Vector();
                    result.put(sec, catsForSectie);
                }
                catsForSectie.add(category);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getCategoriiPrincipale() {
        Vector<Categorie> result = new Vector<Categorie>();
        try {
            Vector rs1 = this.getCategoriesImpl().getAllSubcategories();
            for (int i = 0; i < rs1.size(); ++i) {
                Categorie categorie = (Categorie)rs1.elementAt(i);
                String catParinte = this.getCategorieParinte(categorie);
                if (catParinte != null) continue;
                result.add(categorie);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public String getCategorieParinte(Categorie c) {
        String s = Config.getInstance().getString("financiarCompressCategoriesList");
        if (Validators.correctString(s)) {
            Vector items = Utils.splitString(s, ',');
            for (int i = 0; i < items.size(); ++i) {
                String s1 = (String)items.elementAt(i);
                Vector items2 = Utils.splitString(s1, '=');
                String c1 = (String)items2.get(0);
                String c2 = (String)items2.get(1);
                if (!c.getName().equalsIgnoreCase(c1)) continue;
                return c2;
            }
            return null;
        }
        return null;
    }

    public Vector getCategoriiCopil(Categorie c) throws SQLException {
        Vector<Categorie> result = new Vector<Categorie>();
        String s = Config.getInstance().getStringNoCommit("financiarCompressCategoriesList");
        if (Validators.correctString(s)) {
            Vector items = Utils.splitString(s, ',');
            for (int i = 0; i < items.size(); ++i) {
                Categorie toAdd;
                String s1 = (String)items.elementAt(i);
                Vector items2 = Utils.splitString(s1, '=');
                String c1 = (String)items2.get(0);
                String c2 = (String)items2.get(1);
                if (!c.getName().equalsIgnoreCase(c2) || (toAdd = this.getCategoryByNameNoCommit(c1)) == null) continue;
                result.add(toAdd);
            }
        }
        return result;
    }

    public Vector getCategoriiNaturalOrder() {
        Vector result = this.getCategorii();
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                return NomeclaturaLogic.compareCategorii(o1, o2);
            }
        });
        return result;
    }

    public Categorie newCategoryNoCommit(int idSectie, String subCategoryName, int color, String codDepartament, int idTva, boolean pretKg, double comision) throws SQLException {
        Categorie newCat = new Categorie(-1, idSectie, subCategoryName, -1, -1, codDepartament, idTva, pretKg, comision);
        newCat.setColor(color);
        this.getCategoriesImpl().addCategory(newCat);
        int id = this.pool.requestConnection().getIndentityLocal();
        this.getCategoriesImpl().setOrdine(id, id);
        this.getCategoriesImpl().setCod(id, id);
        newCat.setNrOrdine(id);
        newCat.setCod(id);
        newCat.setId(id);
        return newCat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int newCategory(int idSectie, String subCategoryName, int color, String codDepartament, int idTva, boolean pretKg, double comision) {
        int id = -1;
        try {
            Categorie newCat = this.newCategoryNoCommit(idSectie, subCategoryName, color, codDepartament, idTva, pretKg, comision);
            this.pool.requestConnection().commitTransaction();
            this.notifyListeners(1);
            this.notifyObjectListeners(102, newCat);
            id = newCat.getId();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int newCategory(int idSectie, String subCategoryName, int color, int cod, int ordine, String codDepartament, int idTva, boolean pretKg, double comision) {
        int result = -1;
        try {
            Categorie newCat = new Categorie(-1, idSectie, subCategoryName, -1, cod, codDepartament, idTva, pretKg, comision);
            newCat.setColor(color);
            this.getCategoriesImpl().addCategory(newCat);
            int id = this.pool.requestConnection().getIndentityLocal();
            this.getCategoriesImpl().setOrdine(id, ordine);
            this.getCategoriesImpl().setCod(id, cod);
            this.pool.requestConnection().commitTransaction();
            result = id;
            this.notifyListeners(1);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCategory(Categorie s1) {
        try {
            this.getCategoriesImpl().updateCategory(s1);
            this.pool.commit();
            this.notifyListeners(1);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCategoryNew(Categorie s1) {
        try {
            this.getCategoriesImpl().updateCategoryNew(s1);
            this.pool.commit();
            this.notifyListeners(1);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSectie(Sectie c1) {
        try {
            this.getCategoriesImpl().updateSectie(c1);
            this.pool.requestConnection().commitTransaction();
            this.notifyListeners(0);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchOrderCategories(Categorie s1, Categorie s2) {
        if (s1 == null || s2 == null) {
            return;
        }
        int aux = s1.getNrOrdine();
        s1.setNrOrdine(s2.getNrOrdine());
        s2.setNrOrdine(aux);
        try {
            this.getCategoriesImpl().updateCategory(s1);
            this.getCategoriesImpl().updateCategory(s2);
            this.pool.requestConnection().commitTransaction();
            this.notifyListeners(1);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Categorie getCategoryByNameNoCommit(String subCategoryName) throws SQLException {
        return this.getCategoriesImpl().getCategoryByName(subCategoryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Categorie getCategoryByName(String subCategoryName) {
        Categorie result = null;
        try {
            result = this.getCategoryByNameNoCommit(subCategoryName);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Categorie getCategoryByCod(int scCod) {
        Categorie result = null;
        try {
            result = this.getCategoriesImpl().getCategoryByCod(scCod);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Categorie getCategoryByIdNoCommit(int scId) throws SQLException {
        return this.getCategoriesImpl().getCategoryById(scId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Categorie getCategoryById(int scId) {
        Categorie result = null;
        try {
            result = this.getCategoryByIdNoCommit(scId);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Integer> getParentCategories(int idsc) {
        try {
            Vector<Integer> vector = this.getCategoriesImpl().getParentSubcategoriesForSubcategory(idsc);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<Integer> vector = new Vector<Integer>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCategory(Categorie toDelete) {
        try {
            this.getCategoriesImpl().deleteCategory(toDelete);
            this.pool.requestConnection().commitTransaction();
            this.notifyListeners(1);
            this.notifyListeners(2);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Sectie getSectieByCategoryIdNoCommit(Integer subcategoryId) throws SQLException {
        return this.getCategoriesImpl().getSectieByCategoryId(subcategoryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sectie getSectieByCategoryId(Integer subcategoryId) {
        Sectie result = null;
        try {
            result = this.getSectieByCategoryIdNoCommit(subcategoryId);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    @Override
    public Vector<SectieEntry> getSectii() {
        Vector<SectieEntry> result = new Vector<SectieEntry>();
        for (Sectie element : this.getAllSectii()) {
            result.add(new SectieEntry(element.getName(), element.getId()));
        }
        return result;
    }

    public int getNextProductCodeNoCommit() throws SQLException {
        int result = this.getCategoriesImpl().getLastCode();
        return ++result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextProductCode() {
        int result = -1;
        try {
            result = this.getNextProductCodeNoCommit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProductNameById(Integer id) {
        String s = null;
        try {
            Product p = this.getProductFromDb(id);
            if (p != null) {
                s = p.getName();
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Product> getAllProducts(int tip) {
        Vector<Product> result = new Vector();
        try {
            result = this.getCategoriesImpl().getAllProducts(tip);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Vector getPowerSearchProducts(int tip) {
        return this.getPowerSearchProducts(tip, false);
    }

    public void updatePowerSearchProducts(int idProduct, Vector<String> coduri) {
        Product p = this.getProductById(idProduct);
        if (p != null && p.getStatus() == 1) {
            PowerSearchProduct psp = new PowerSearchProduct(p, coduri);
            this.powerProducts.put(p.getId(), psp);
        } else {
            this.powerProducts.remove(idProduct);
        }
        this.notifyListeners(2);
    }

    public Vector getPowerSearchProducts(int tip, boolean forceRefresh) {
        boolean refresh = false;
        if (this.allProducts.size() == 0 || forceRefresh) {
            this.buildProducts();
            this.mustRefreshPowerProducts = true;
        }
        if (this.mustRefreshPowerProducts) {
            Hashtable<Integer, Vector<String>> produseSiCoduri = this.getAllProductsBarCodesHash();
            for (int i = 0; i < this.allProducts.size(); ++i) {
                ProductWithPrice pp = (ProductWithPrice)this.allProducts.elementAt(i);
                Vector<String> coduri = produseSiCoduri.get(pp.getProduct().getId());
                if (coduri == null) continue;
                PowerSearchProduct psp = new PowerSearchProduct(pp.getProduct(), coduri);
                this.powerProducts.put(pp.getProduct().getId(), psp);
            }
            this.mustRefreshPowerProducts = false;
        }
        return new Vector(this.powerProducts.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildProducts() {
        this.allProducts.clear();
        this.allProductsHash.clear();
        try {
            Vector<Product> result = this.getCategoriesImpl().getAllProducts(-1);
            for (int i = 0; i < result.size(); ++i) {
                Product p = result.elementAt(i);
                ProductWithPrice pp = new ProductWithPrice();
                pp.setProduct(p);
                this.allProducts.add(pp);
                this.allProductsHash.put(p.getId(), pp);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        Collections.sort(this.allProducts, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
    }

    private void productChanged(int idProduct, double price) {
        this.productDeleted(idProduct);
        this.productAdded(idProduct, price);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void productAdded(int idProduct, double price) {
        try {
            this.productAddedNoCommit(idProduct, price);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void productAddedNoCommit(int idProduct, double price) throws SQLException {
        Product p = this.getProductByIdNoCommit(idProduct);
        ProductWithPrice pp = new ProductWithPrice();
        pp.setProduct(p);
        pp.setPrice(price);
        this.allProducts.add(pp);
        this.allProductsHash.put(p.getId(), pp);
        Vector<String> coduri = this.getAllBarCodesByIdProdNoCommit(idProduct);
        PowerSearchProduct psp = new PowerSearchProduct(p, coduri);
        this.powerProducts.put(idProduct, psp);
    }

    public void productDeleted(int idProduct) {
        ProductWithPrice pp = (ProductWithPrice)this.allProductsHash.get(idProduct);
        this.allProducts.remove(pp);
        this.allProductsHash.remove(idProduct);
        this.productByIdHash.remove(idProduct);
        this.powerProducts.remove(idProduct);
    }

    public Product getProductByCodNoCommit(int cod) throws SQLException {
        return this.getCategoriesImpl().getProductByCod(cod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Product getProductByCod(int cod) {
        Product result = null;
        try {
            result = this.getCategoriesImpl().getProductByCod(cod);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public boolean isCodBareDefined(String codBare) {
        Product p = this.getProductByCodBare(codBare);
        return p != null;
    }

    public Product getProductByCodBareNoCommit(String codBare) throws SQLException {
        Product result = this.getCategoriesImpl().getProductByCodBare(codBare);
        return result;
    }

    public Product getProductByCodSyncNoCommit(String codSync) throws SQLException {
        Product result = this.getCategoriesImpl().getProductByCodSync(codSync);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Product getProductByCodSync(String codSync) {
        Product result = null;
        try {
            result = this.getCategoriesImpl().getProductByCodSync(codSync);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Product getProductByPartialCodBareNoCommit(String codBare) throws SQLException {
        Product result = this.getCategoriesImpl().getProductByCodBarePartially(codBare);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Product getProductByCodBare(String codBare) {
        Product result = null;
        try {
            result = this.getCategoriesImpl().getProductByCodBare(codBare);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Product getProductByName(String name) {
        Product result = null;
        try {
            result = this.getProductByNameNoCommit(name, 1);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Product getProductByNameNoCommit(String name, int status) throws SQLException {
        return this.getCategoriesImpl().getProductByName(name, status);
    }

    public Vector getProductsForCategorie(Categorie subcat) {
        return this.getProductsForCategorie(subcat, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getProductsForCategorie(Categorie subcat, int uzIntern) {
        Vector result = new Vector();
        try {
            result = this.getCategoriesImpl().getProductsForCategorie(subcat.getId(), uzIntern);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getProductsForSectie(Sectie sectie) {
        Vector result = new Vector();
        try {
            result = this.getCategoriesImpl().getProductsForSectie(sectie.getId());
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public boolean isProductDefined(String name) {
        Product p = this.getProductByName(name);
        return p != null;
    }

    public Product getProductByIdNoCommit(Integer id) throws SQLException {
        Product p = (Product)this.productByIdHash.get(id);
        if (p != null) {
            return p;
        }
        p = this.getProductFromDb(id);
        if (p != null) {
            this.productByIdHash.put(id, p);
        }
        return p;
    }

    public Product getProductFromDb(Integer id) throws SQLException {
        Product p = this.getCategoriesImpl().getProductById(id);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Product getProductById(Integer id) {
        Product result = null;
        try {
            result = this.getProductByIdNoCommit(id);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public int addProductShortNoCommit(Product p, String codBare) throws SQLException {
        Vector<String> barcodes = new Vector<String>();
        barcodes.add(codBare);
        return this.addProductNoCommit(p.getName(), p.getNumeCasa(), p.getNumeSectie(), p.getLiber1(), p.getLiber2(), p.getCod(), p.getIdCategorie(), p.isUzIntern(), p.isExportCantar(), p.getPictureFile(), p.getCodSync(), barcodes);
    }

    public int addProductShortNoCommit(Product p, int idCategorie, Vector<String> barcodes) throws SQLException {
        return this.addProductNoCommit(p.getName(), p.getNumeCasa(), p.getNumeSectie(), p.getLiber1(), p.getLiber2(), p.getCod(), idCategorie, p.isUzIntern(), p.isExportCantar(), p.getPictureFile(), p.getCodSync(), barcodes);
    }

    public int addProductNoCommit(String label, String casaName, String sectieName, String liber1, String liber2, int cod, int idSubcategory, boolean uzIntern, boolean exportCantar, String pictureFile, String codSync, Vector<String> barcodes) throws SQLException {
        this.getCategoriesImpl().addProdus(label, casaName, sectieName, liber1, liber2, cod, idSubcategory, uzIntern, exportCantar, codSync);
        int idProdus = this.pool.requestConnection().getIndentityLocal();
        for (String barcode : barcodes) {
            this.addBarcodeToProductNoCommit(idProdus, barcode);
        }
        this.updatePictureForProductNoCommit(pictureFile, idProdus);
        this.updateToPrintNoCommit(true, idProdus);
        return idProdus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<Integer, Vector<String>> getAllProductsBarCodesHash() {
        try {
            Hashtable<Integer, Vector<String>> hashtable = this.getCategoriesImpl().getAllProductsBarcodes();
            return hashtable;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Hashtable<Integer, Vector<String>> hashtable = new Hashtable<Integer, Vector<String>>();
            return hashtable;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<String> getAllBarCodesByIdProdNoCommit(int prodId) throws SQLException {
        return this.getCategoriesImpl().getAllSecondaryCodesById(prodId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> getAllBarCodesByIdProd(int prodId) {
        try {
            Vector<String> vector = this.getAllBarCodesByIdProdNoCommit(prodId);
            return vector;
        }
        catch (SQLException e) {
            e.printStackTrace();
            Vector<String> vector = new Vector<String>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public String getAllBarcodesForProductAsString(int idProduct) {
        Vector<String> allCodes = NomeclaturaLogic.getInstance().getAllBarCodesByIdProd(idProduct);
        String result = "";
        for (String code : allCodes) {
            result = result + code + ", ";
        }
        result = result.substring(0, result.length() - 2);
        return result;
    }

    public String getFirstBarcodeByIdProd(int idProduct) {
        String result = "";
        Vector<String> allBarCodesByIdProd = this.getAllBarCodesByIdProd(idProduct);
        if (allBarCodesByIdProd.size() > 0 && (result = allBarCodesByIdProd.get(0)) != null) {
            return result;
        }
        return "";
    }

    public String getFirstBarcodeByIdProdNoCommit(int idProduct) throws SQLException {
        String result = "";
        Vector<String> allBarCodesByIdProd = this.getAllBarCodesByIdProdNoCommit(idProduct);
        if (allBarCodesByIdProd.size() > 0 && (result = allBarCodesByIdProd.get(0)) != null) {
            return result;
        }
        return "";
    }

    public String getLongBarcodeByIdProd(int idProduct) {
        Vector<String> allBarCodesByIdProd = this.getAllBarCodesByIdProd(idProduct);
        if (allBarCodesByIdProd.size() > 0) {
            for (String s : allBarCodesByIdProd) {
                if (s.length() != 13) continue;
                return s;
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBarCodeFromProduct(int productId, String barCode) {
        try {
            this.getCategoriesImpl().deleteSecondaryBarCode(productId, barCode);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBarcodeToProduct(int productId, String barcode) {
        try {
            this.addBarcodeToProductNoCommit(productId, barcode);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void addBarcodeToProductNoCommit(int productId, String barcode) throws SQLException {
        this.getCategoriesImpl().addBarcodeToProduct(productId, barcode);
    }

    public void deleteAllBarcodesFromProduct(int productId) throws SQLException {
        this.getCategoriesImpl().deleteAllBarCodeFromProduct(productId);
    }

    public void updatePictureForProductNoCommit(String pictureFile, int idProdus) throws SQLException {
        if (Validators.correctString(pictureFile)) {
            File f = new File(pictureFile);
            int size = (int)f.length();
            try {
                FileInputStream fin = new FileInputStream(pictureFile);
                int idFile = DocumenteLogic.getInstance().addFileNoCommit(pictureFile, "", pictureFile, "", fin, size);
                this.getCategoriesImpl().updateProductPicture(idProdus, idFile);
            }
            catch (FileNotFoundException e) {
                Logger.logException(this, (Exception)e);
            }
        }
    }

    public void updateProductNoCommit(Product p, double newPrice, Vector attributes) throws SQLException {
        this.getCategoriesImpl().updateProduct(p);
        this.getCategoriesImpl().deleteAttributesFromProduct(p.getId());
        this.addProductAttributes(p.getId(), attributes);
        this.updatePictureForProductNoCommit(p.getPictureFile(), p.getId());
        this.updateToPrintNoCommit(true, p.getId());
    }

    public void updateUzInternForProductNoCommit(boolean uzIntern, int idProdus) throws SQLException {
        this.getCategoriesImpl().updateUzInternForProduct(uzIntern, idProdus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUzInternForProductCommit(boolean uzIntern, int idProdus) {
        try {
            this.updateUzInternForProductNoCommit(uzIntern, idProdus);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProduct(Product p, double newPrice, Vector attributes) {
        try {
            this.updateProductNoCommit(p, newPrice, attributes);
            this.pool.commit();
            this.notifyListeners(2);
            this.notifyObjectListeners(100, p);
            this.productChanged(p.getId(), newPrice);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBarcodesForProductById(int idProduct, Vector<String> toCheck) {
        try {
            this.updateBarcodesForProductByIdNoCommit(idProduct, toCheck);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void updateBarcodesForProductByIdNoCommit(int idProduct, Vector<String> toCheck) throws SQLException {
        this.deleteAllBarcodesFromProduct(idProduct);
        for (String barcode : toCheck) {
            this.addBarcodeToProductNoCommit(idProduct, barcode);
        }
    }

    public void updateProductNoCommit(Product p) throws SQLException {
        this.getCategoriesImpl().updateProduct(p);
        String pictureFile = p.getPictureFile();
        if (Validators.correctString(pictureFile)) {
            this.updatePictureForProductNoCommit(p.getPictureFile(), p.getId());
        }
        this.updateToPrintNoCommit(true, p.getId());
    }

    public void deleteProductNoCommit(Product toDelete) throws SQLException {
        this.getCategoriesImpl().deleteProduct(toDelete);
    }

    public void deleteAllProductsNoCommit() throws SQLException {
        this.getCategoriesImpl().deleteAllProducts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Product> getProduseCantar() {
        Vector<Product> result = new Vector();
        try {
            result = this.getCategoriesImpl().getAllProduseCantar();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProdusLaKg(int idProduct) {
        try {
            boolean bl = this.getCategoriesImpl().isProductLaKg(idProduct);
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateCoduriBare(String txtFile) {
        ConnectionPool pool = null;
        try {
            LineNumberReader reader = new LineNumberReader(new FileReader(txtFile));
            pool = ConnectionPool.getInstance();
            Connection conn = pool.requestConnection().getConnection();
            String line = reader.readLine();
            while (line != null) {
                Vector fields = Utils.splitStringKeepStructure(line, '|', ' ');
                String codS = (String)fields.get(0);
                String codBareS = (String)fields.get(1);
                if (Validators.correctInteger(codS) && Validators.correctString(codBareS)) {
                    String s = "update products set cod_bare = '" + codBareS + "' where cod = " + codS;
                    SqlUtils.executeUpdate(s, conn);
                }
                line = reader.readLine();
            }
            conn.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getProductAttributes(int idProduct) {
        try {
            Vector attributes;
            if (idProduct > 0 && (attributes = this.getCategoriesImpl().getAttributesForProduct(idProduct)).size() > 0) {
                Vector vector = attributes;
                return vector;
            }
            attributes = this.getCategoriesImpl().getAllAttributes();
            return attributes;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, String> getProductAtrributesAsHash(int idProduct) {
        try {
            Hashtable<String, String> result = new Hashtable<String, String>();
            Vector attributes = this.getCategoriesImpl().getAttributesForProduct(idProduct);
            for (ProductAttribute attribute : attributes) {
                result.put(attribute.getLabel(), attribute.getValue());
            }
            Hashtable<String, String> i$ = result;
            return i$;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            return hashtable;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void addProductAttributes(int idProduct, Vector attributes) throws SQLException {
        this.getCategoriesImpl().deleteAttributesFromProduct(idProduct);
        for (int i = 0; i < attributes.size(); ++i) {
            ProductAttribute productAttribute = (ProductAttribute)attributes.elementAt(i);
            this.getCategoriesImpl().addAttributeToProduct(idProduct, productAttribute.getIdAttribute(), productAttribute.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProductAttribute getAttributeByName(String label) {
        try {
            ProductAttribute pa;
            ProductAttribute productAttribute = pa = this.getCategoriesImpl().getAttributeByName(label);
            return productAttribute;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            ProductAttribute productAttribute = null;
            return productAttribute;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public ProductIcon loadIcon(int idProduct, String parentFolder, int dx) {
        ProductIcon icon = this.loadIcon(idProduct, parentFolder);
        if (dx > 0) {
            icon.scale(dx, GuiUtils.currentFrame);
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProductIcon loadIcon(int idProduct, String parentFolder) {
        ProductIcon result = new ProductIcon();
        ImageIcon img = null;
        if (idProduct != -1) {
            try {
                int idFile = -1;
                try {
                    idFile = this.getCategoriesImpl().getPictureForProduct(idProduct);
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
                finally {
                    try {
                        this.pool.commit();
                    }
                    catch (SQLException e) {
                        Logger.logException(this, (Exception)e);
                    }
                    this.pool.releaseConnection();
                }
                if (idFile != -1) {
                    String fullPath = parentFolder + File.separator + "Product_" + idProduct + "_" + idFile + ".jpg";
                    DocumenteLogic.getInstance().saveDocument(new File(fullPath), idFile);
                    img = Utils.getImageFromDiskAbsolutePath(fullPath);
                    result.setFullPath(fullPath);
                }
            }
            catch (MalformedURLException e2) {
                Logger.logException(this, (Exception)e2);
                result = null;
            }
        }
        if (img == null) {
            img = Utils.getImageResource("nobody.gif");
        }
        result.setIcon(img);
        return result;
    }

    public void updateToPrintNoCommit(boolean toPrint, int idProduct) throws SQLException {
        this.getCategoriesImpl().updateToPrint(toPrint, idProduct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateToPrint(boolean toPrint, int idProduct) {
        try {
            this.updateToPrintNoCommit(toPrint, idProduct);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void toggleToPrintNoCommit(int idProduct) throws SQLException {
        this.getCategoriesImpl().toggleToPrint(idProduct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleToPrint(int idProduct) {
        try {
            this.toggleToPrintNoCommit(idProduct);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Product> getProduseRelated(Product p) {
        Vector<Product> result = new Vector<Product>();
        try {
            Vector<Integer> ids = this.getCategoriesImpl().getAllProduseRelated(p.getId());
            for (Integer id : ids) {
                Product toadd = this.getProductByIdNoCommit(id);
                result.add(toadd);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProduseRelated(int idParent, int idChild) {
        try {
            this.getCategoriesImpl().addProduseRelated(idParent, idChild);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProduseRelated(int idParent, int idChild) {
        try {
            this.getCategoriesImpl().deleteProduseRelated(idParent, idChild);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Product lookForProductByBarcodeInName(String name) {
        try {
            String[] sb;
            for (String s : sb = name.split(" ")) {
                Product result = this.getCategoriesImpl().getProductByCodBare(s);
                if (result == null) continue;
                Product product = result;
                return product;
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Product product = null;
            return product;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return null;
    }

    public Integer getIdValutaFromCategorieNoCommit(int idCategorie) throws SQLException {
        return this.getCategoriesImpl().getIdValutaFromCategorie(idCategorie);
    }

    public Product getProductForNameAndPriceNoCommit(String name, Double price) throws SQLException {
        Hashtable<Product, Double> prods = this.getCategoriesImpl().getProductsAndPricesByProductName(name, -1);
        if (prods.size() > 0) {
            if (prods.size() == 1) {
                Iterator<Product> i$ = prods.keySet().iterator();
                if (i$.hasNext()) {
                    Product product = i$.next();
                    return product;
                }
            } else {
                for (Product product : prods.keySet()) {
                    Double priceInDB = prods.get(product);
                    if (!Utils.isValueZero(price - priceInDB)) continue;
                    return product;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValutaForCategory(int idCategory, int idValuta) {
        try {
            this.getCategoriesImpl().setValutaForSubcategory(idCategory, idValuta);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Integer getIdCategoryForIdProductNoCommit(int idProduct) throws SQLException {
        return this.getCategoriesImpl().getIdCategoryForIdProduct(idProduct);
    }
}

