/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.nomenclatura.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.ProductAttribute;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.sql.SqlUtils;

public class CategoriesImpl
implements DaoInterface {
    private Connection connection;
    private PreparedStatement selectSubcategoryById;
    private PreparedStatement selectSubcategoryByCod;
    private PreparedStatement selectSubcategoryByName;
    private PreparedStatement selectAllSubcategories;
    private PreparedStatement selectSubcategoriesByCategoryId;
    private PreparedStatement selectCategoryById;
    private PreparedStatement selectCategoryByCod;
    private PreparedStatement selectCategoryBySubcategoryId;
    private PreparedStatement selectCategoryByName;
    private PreparedStatement selectAllCategories;
    private PreparedStatement addCategory;
    private PreparedStatement addSubcategory;
    private PreparedStatement deleteSubcategory;
    private PreparedStatement updateSubcategory;
    private PreparedStatement updateCategory;
    private PreparedStatement setNrOrdineForSubcategory;
    private PreparedStatement setCodForSubcategory;
    private PreparedStatement setCodForCategory;
    private PreparedStatement getLastCode;
    private PreparedStatement deleteAllSubcategories;
    private PreparedStatement deleteAllCategories;
    private PreparedStatement getProductById;
    private PreparedStatement selectAllProducts;
    private PreparedStatement selectProductsBySectieId;
    private PreparedStatement selectProductsByCategorieId;
    private PreparedStatement updateProduct;
    private PreparedStatement updateUzInternForProduct;
    private PreparedStatement addProduct;
    private PreparedStatement selectProductByCod;
    private PreparedStatement selectProductByCodBare;
    private PreparedStatement selectProductByCodSync;
    private PreparedStatement deleteAllProducts;
    private PreparedStatement selectAllSecondaryBarCodes;
    private PreparedStatement addBarcodeForProduct;
    private PreparedStatement deleteBarcodeFromProduct;
    private PreparedStatement deleteAllBarcodesFromProduct;
    private PreparedStatement selectAllProductsBarcodes;
    private PreparedStatement selectProductByNameAndPrice;
    private PreparedStatement updateSubcategoryNew;
    private PreparedStatement setValutaForSubcategory;
    private PreparedStatement getIdCategoryForIdProduct;
    private PreparedStatement deleteProduct;
    private PreparedStatement selectProductByName;
    private PreparedStatement getProduseCantar;
    private PreparedStatement isProductLaKg;
    private PreparedStatement selectProductByPartialCodBare;
    private PreparedStatement getAttributesForProduct;
    private PreparedStatement addAttributesForProduct;
    private PreparedStatement deleteAttributesForProduct;
    private PreparedStatement getAllAttributes;
    private PreparedStatement getProductAttributeByName;
    private PreparedStatement getPictureForProduct;
    private PreparedStatement setPictureForProduct;
    private PreparedStatement deletePictureForProduct;
    private PreparedStatement updateToPrintForProduct;
    private PreparedStatement toggleToPrintForProduct;
    private PreparedStatement getParentCategories;
    private PreparedStatement getProduseRelated;
    private PreparedStatement addProduseRelated;
    private PreparedStatement deleteProduseRelated;

    public CategoriesImpl(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.getProduseRelated = this.connection.prepareStatement("select * from produse_related where id_parent = ?");
        this.addProduseRelated = this.connection.prepareStatement("insert into produse_related (id_parent, id_child) values (?,?)");
        this.deleteProduseRelated = this.connection.prepareStatement("delete from produse_related where id_parent = ? and id_child = ?");
        this.getParentCategories = this.connection.prepareStatement("select distinct id_parent from subcategories_ierarchy where id_child = ?");
        this.setPictureForProduct = this.connection.prepareStatement("insert into product_picture (id_file, id_product) values ( ?,?)");
        this.deletePictureForProduct = this.connection.prepareStatement("delete from product_picture where id_product = ?");
        this.getPictureForProduct = this.connection.prepareStatement("select * from product_picture where id_product = ?");
        this.addAttributesForProduct = this.connection.prepareStatement("insert into mapping_product_attribute (id_product,id_attribute, value) values (?,?, ?)");
        this.deleteAttributesForProduct = this.connection.prepareStatement("delete from mapping_product_attribute where id_product = ?");
        this.getAllAttributes = this.connection.prepareStatement("select product_attribute.label as label, product_attribute.export_field as export_key, product_attribute.id as id_attribute from product_attribute");
        this.getProductAttributeByName = this.connection.prepareStatement("select product_attribute.label as label, product_attribute.export_field as export_key, product_attribute.id as id_attribute from product_attribute where label = ?");
        this.getAttributesForProduct = this.connection.prepareStatement("select coalesce(mapping_product_attribute.value, '') as value, product_attribute.label as label, product_attribute.export_field as export_key, product_attribute.id as id_attribute from product_attribute inner join mapping_product_attribute on product_attribute.id = mapping_product_attribute.id_attribute where id_product = ?");
        this.isProductLaKg = this.connection.prepareStatement("select pret_kg from subcategories where id = ( select id_subcategory from products where id = ? )");
        this.deleteAllProducts = this.connection.prepareStatement("delete from products");
        this.getLastCode = this.connection.prepareStatement("select max(cod) from products");
        this.selectAllSubcategories = this.connection.prepareStatement("select * from subcategories where status = 1");
        this.selectSubcategoryById = this.connection.prepareStatement("select * from subcategories where id = ?");
        this.selectSubcategoryByCod = this.connection.prepareStatement("select * from subcategories where cod = ?");
        this.selectSubcategoryByName = this.connection.prepareStatement("select * from subcategories where label = ?");
        this.selectSubcategoriesByCategoryId = this.connection.prepareStatement("select * from subcategories where (id_category = ? OR ? = -1) and status = 1");
        this.addSubcategory = this.connection.prepareStatement("insert into subcategories ( id_category, label, color, status, cod_departament, id_tva, pret_kg, comision ) values ( ? , ?, ?, 1 , ?, ?, ?, ? )");
        this.setNrOrdineForSubcategory = this.connection.prepareStatement("update subcategories set nr_ordine = ? where id = ?");
        this.setCodForSubcategory = this.connection.prepareStatement("update subcategories set cod = ? where id = ?");
        this.setCodForCategory = this.connection.prepareStatement("update categories set cod = ? where id = ?");
        this.deleteSubcategory = this.connection.prepareStatement("update subcategories set status = 2 where id = ?");
        this.updateSubcategory = this.connection.prepareStatement("update subcategories set label=?, nr_ordine = ?, id_category = ?, color = ?, cod_departament = ?, id_tva = ?, pret_kg = ?, comision = ? where id= ? ");
        this.selectCategoryById = this.connection.prepareStatement("select * from categories where id = ?");
        this.selectCategoryByCod = this.connection.prepareStatement("select * from categories where cod = ?");
        this.selectCategoryBySubcategoryId = this.connection.prepareStatement("select categories.id as id, categories.label as label, categories.cod as cod, categories.analitic as analitic, categories.analitic_tva as analitic_tva from categories inner join subcategories on categories.id = subcategories.id_category where subcategories.id = ?");
        this.selectCategoryByName = this.connection.prepareStatement("select * from categories where label = ?");
        this.selectAllCategories = this.connection.prepareStatement("select * from categories where status = 1");
        this.addCategory = this.connection.prepareStatement("insert into categories (label, analitic, analitic_tva, status) values ( ?, ?, ?, 1 )");
        this.updateCategory = this.connection.prepareStatement("update categories set label = ?, analitic = ?, analitic_tva = ? where id = ?");
        this.deleteAllSubcategories = this.connection.prepareStatement("delete from subcategories");
        this.deleteAllCategories = this.connection.prepareStatement("delete from categories");
        this.getProductById = this.connection.prepareStatement("select * from products where id = ?");
        this.selectProductByCod = this.connection.prepareStatement("select * from products where products.cod = ? and products.status = 1");
        this.selectProductByCodBare = this.connection.prepareStatement("select products.* from products inner join products_barcodes on products.id = products_barcodes.id_product where products_barcodes.barcode = ? and products.status = 1");
        this.selectProductByCodSync = this.connection.prepareStatement("select * from products where cod_sync = ? and products.status = 1");
        this.selectProductByPartialCodBare = this.connection.prepareStatement("select * from products where cod_bare like ? and products.status = 1");
        this.selectProductByName = this.connection.prepareStatement("select * from products where products.label = ? and ((products.status = ?) OR ( ? = -1))");
        this.selectAllProducts = this.connection.prepareStatement("select * from products where products.status = 1");
        this.selectProductsByCategorieId = this.connection.prepareStatement("select * from products where id_subcategory = ? and (uz_intern = ? or ? = -1) and status = 1 order by label");
        this.addProduct = this.connection.prepareStatement("insert into products  (label, short_label, sectie_label, liber1, liber2, id_subcategory, cod, status, uz_intern, export_cantar, cod_sync )  values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )");
        this.deleteProduct = this.connection.prepareStatement("update products set status = 2 where id = ?");
        this.addBarcodeForProduct = this.connection.prepareStatement("insert into products_barcodes ( id_product, barcode ) values ( ?, ? ) ");
        this.deleteBarcodeFromProduct = this.connection.prepareStatement("delete from products_barcodes where id_product = ? and barcode = ?");
        this.deleteAllBarcodesFromProduct = this.connection.prepareStatement("delete from products_barcodes where id_product = ?");
        this.selectAllSecondaryBarCodes = this.connection.prepareStatement("select * from products_barcodes where id_product = ?");
        this.updateProduct = this.connection.prepareStatement("update products set label = ?, short_label = ?, sectie_label = ?, liber1 = ?, liber2 = ?, id_subcategory = ?, cod = ?, uz_intern = ?, export_cantar = ? where id = ?");
        this.updateUzInternForProduct = this.connection.prepareStatement("update products set uz_intern = ? where id = ?");
        this.selectProductsBySectieId = this.connection.prepareStatement("select * from products inner join subcategories on products.id_subcategory = subcategories.id where id_category = ? and uz_intern = 0 and products.status = 1 order by products.label");
        this.getProduseCantar = this.connection.prepareStatement("select * from products where status = 1 and export_cantar = 1");
        this.updateToPrintForProduct = this.connection.prepareStatement("update products set to_print = ? where ( id = ? or ? = -1 )");
        this.toggleToPrintForProduct = this.connection.prepareStatement("update products set to_print = ( case when to_print = 1 then 0 else 1 end ) where ( id = ? or ? = -1 )");
        this.selectAllProductsBarcodes = this.connection.prepareStatement("select * from products_barcodes");
        this.selectProductByNameAndPrice = this.connection.prepareStatement("select products.*, stocks.sell_price from products  inner join produse_finite on produse_finite.id_product = products.id inner join stocks on stocks.id = produse_finite.id_stock   where products.label = ? and ((products.status = ?) OR ( ? = -1))");
        this.updateSubcategoryNew = this.connection.prepareStatement("update subcategories set label=?, nr_ordine = ?, id_category = ?, color = ?, cod_departament = ?, id_tva = ?, pret_kg = ?, comision = ?, id_valuta = ? where id = ? ");
        this.setValutaForSubcategory = this.connection.prepareStatement("update subcategories set id_valuta = ? where id = ?");
        this.getIdCategoryForIdProduct = this.connection.prepareStatement("select id_subcategory from products where id = ?");
    }

    public Hashtable<Integer, Vector<String>> getAllProductsBarcodes() throws SQLException {
        Hashtable<Integer, Vector<String>> result = new Hashtable<Integer, Vector<String>>();
        ResultSet rs = this.selectAllProductsBarcodes.executeQuery();
        while (rs.next()) {
            int idProdus = rs.getInt("id_product");
            String codBare = rs.getString("barcode");
            Vector<String> existings = result.get(idProdus);
            if (existings == null) {
                existings = new Vector();
                result.put(idProdus, existings);
            }
            existings.add(codBare);
        }
        rs.close();
        return result;
    }

    public Vector<String> getAllSecondaryCodesById(int idProduct) throws SQLException {
        Vector<String> result = new Vector<String>();
        this.selectAllSecondaryBarCodes.setInt(1, idProduct);
        ResultSet rs = this.selectAllSecondaryBarCodes.executeQuery();
        while (rs.next()) {
            String cod = rs.getString("barcode");
            result.add(cod);
        }
        rs.close();
        return result;
    }

    public void addBarcodeToProduct(int idProduct, String barcode) throws SQLException {
        this.addBarcodeForProduct.setInt(1, idProduct);
        this.addBarcodeForProduct.setString(2, barcode);
        this.addBarcodeForProduct.execute();
    }

    public void deleteSecondaryBarCode(int prodId, String barCode) throws SQLException {
        this.deleteBarcodeFromProduct.setInt(1, prodId);
        this.deleteBarcodeFromProduct.setString(2, barCode);
        this.deleteBarcodeFromProduct.execute();
    }

    public void deleteAllBarCodeFromProduct(int prodId) throws SQLException {
        this.deleteAllBarcodesFromProduct.setInt(1, prodId);
        this.deleteAllBarcodesFromProduct.execute();
    }

    public void addProduseRelated(int idParent, int idChild) throws SQLException {
        this.addProduseRelated.setInt(1, idParent);
        this.addProduseRelated.setInt(2, idChild);
        this.addProduseRelated.execute();
    }

    public void deleteProduseRelated(int idParent, int idChild) throws SQLException {
        this.deleteProduseRelated.setInt(1, idParent);
        this.deleteProduseRelated.setInt(2, idChild);
        this.deleteProduseRelated.execute();
    }

    public Vector<Integer> getAllProduseRelated(int idParent) throws SQLException {
        Vector<Integer> result = new Vector<Integer>();
        this.getProduseRelated.setInt(1, idParent);
        ResultSet rs = this.getProduseRelated.executeQuery();
        while (rs.next()) {
            int idChild = rs.getInt("id_child");
            result.add(idChild);
        }
        rs.close();
        return result;
    }

    public Vector<Integer> getParentSubcategoriesForSubcategory(int idChild) throws SQLException {
        Vector<Integer> result = new Vector<Integer>();
        this.getParentCategories.setInt(1, idChild);
        ResultSet rs = this.getParentCategories.executeQuery();
        while (rs.next()) {
            result.add(rs.getInt(1));
        }
        rs.close();
        return result;
    }

    public void updateToPrint(boolean toPrint, int idProduct) throws SQLException {
        this.updateToPrintForProduct.setInt(1, toPrint ? 1 : 0);
        this.updateToPrintForProduct.setInt(2, idProduct);
        this.updateToPrintForProduct.setInt(3, idProduct);
        this.updateToPrintForProduct.execute();
    }

    public void toggleToPrint(int idProduct) throws SQLException {
        this.toggleToPrintForProduct.setInt(1, idProduct);
        this.toggleToPrintForProduct.setInt(2, idProduct);
        this.toggleToPrintForProduct.execute();
    }

    public void addAttributeToProduct(int idProduct, int idAttribute, String value) throws SQLException {
        this.addAttributesForProduct.setInt(1, idProduct);
        this.addAttributesForProduct.setInt(2, idAttribute);
        this.addAttributesForProduct.setString(3, value);
        this.addAttributesForProduct.execute();
    }

    public void deleteAttributesFromProduct(int idProduct) throws SQLException {
        this.deleteAttributesForProduct.setInt(1, idProduct);
        this.deleteAttributesForProduct.execute();
    }

    private ProductAttribute getProductAttributeFromResultSet(ResultSet rs) throws SQLException {
        ProductAttribute pa = new ProductAttribute();
        pa.setCodExtern(rs.getString("export_key"));
        pa.setIdAttribute(rs.getInt("id_attribute"));
        pa.setLabel(rs.getString("label"));
        pa.setValue("");
        return pa;
    }

    public Vector getAllAttributes() throws SQLException {
        Vector<ProductAttribute> result = new Vector<ProductAttribute>();
        ResultSet rs = this.getAllAttributes.executeQuery();
        while (rs.next()) {
            ProductAttribute pa = this.getProductAttributeFromResultSet(rs);
            result.add(pa);
        }
        rs.close();
        return result;
    }

    public ProductAttribute getAttributeByName(String attrName) throws SQLException {
        ProductAttribute result = null;
        this.getProductAttributeByName.setString(1, attrName);
        ResultSet rs = this.getProductAttributeByName.executeQuery();
        while (rs.next()) {
            result = this.getProductAttributeFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Vector getAttributesForProduct(int idProduct) throws SQLException {
        Vector<ProductAttribute> result = new Vector<ProductAttribute>();
        this.getAttributesForProduct.setInt(1, idProduct);
        ResultSet rs = this.getAttributesForProduct.executeQuery();
        while (rs.next()) {
            ProductAttribute pa = new ProductAttribute();
            pa.setCodExtern(rs.getString("export_key"));
            pa.setIdAttribute(rs.getInt("id_attribute"));
            pa.setLabel(rs.getString("label"));
            pa.setValue(rs.getString("value"));
            result.add(pa);
        }
        rs.close();
        return result;
    }

    public boolean isProductLaKg(int idProduct) throws SQLException {
        boolean result = false;
        this.isProductLaKg.setInt(1, idProduct);
        ResultSet rs = this.isProductLaKg.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1) == 1;
        }
        rs.close();
        return result;
    }

    public void addProdus(String label, String casaName, String sectieName, String liber1, String liber2, int cod, int idSubcategory, boolean uzIntern, boolean exportCantar, String codSync) throws SQLException {
        this.addProduct.setString(1, label);
        this.addProduct.setString(2, casaName);
        this.addProduct.setString(3, sectieName);
        this.addProduct.setString(4, liber1);
        this.addProduct.setString(5, liber2);
        this.addProduct.setInt(6, idSubcategory);
        this.addProduct.setInt(7, cod);
        this.addProduct.setInt(8, 1);
        this.addProduct.setInt(9, uzIntern ? 1 : 0);
        this.addProduct.setInt(10, exportCantar ? 1 : 0);
        this.addProduct.setString(11, codSync);
        this.addProduct.execute();
    }

    public void deleteAll() throws SQLException {
        this.deleteAllSubcategories.execute();
        this.deleteAllCategories.execute();
    }

    public final int getLastCode() throws SQLException {
        ResultSet rs = this.getLastCode.executeQuery();
        int result = -1;
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void addSectie(String label, String analitic, String analiticTva) throws SQLException {
        this.addCategory.setString(1, label);
        this.addCategory.setString(2, analitic);
        this.addCategory.setString(3, analiticTva);
        this.addCategory.executeUpdate();
    }

    public void setCodForSectie(int idCategory, int cod) throws SQLException {
        this.setCodForCategory.setInt(1, cod);
        this.setCodForCategory.setInt(2, idCategory);
        this.setCodForCategory.execute();
    }

    public Vector<Sectie> getSectii() throws SQLException {
        Vector<Sectie> result = new Vector<Sectie>();
        ResultSet rs = this.selectAllCategories.executeQuery();
        while (rs.next()) {
            Sectie toAdd = this.getCategoryFromResultSet(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    private Sectie getCategoryFromResultSet(ResultSet rs) throws SQLException {
        return new Sectie(rs.getInt("id"), rs.getString("label"), rs.getInt("cod"), rs.getString("analitic"), rs.getString("analitic_tva"));
    }

    public Sectie getSectieByCod(int cod) throws SQLException {
        this.selectCategoryByCod.setInt(1, cod);
        ResultSet rs = this.selectCategoryByCod.executeQuery();
        Sectie result = null;
        if (rs.next()) {
            result = this.getCategoryFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Sectie getSectieById(int categoryId) throws SQLException {
        this.selectCategoryById.setInt(1, categoryId);
        ResultSet rs = this.selectCategoryById.executeQuery();
        Sectie result = null;
        if (rs.next()) {
            result = this.getCategoryFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Sectie getSectieByCategoryId(int categoryId) throws SQLException {
        Sectie result = null;
        this.selectCategoryBySubcategoryId.setInt(1, categoryId);
        ResultSet rs = this.selectCategoryBySubcategoryId.executeQuery();
        if (rs.next()) {
            result = this.getCategoryFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Sectie getSectieByName(String label) throws SQLException {
        this.selectCategoryByName.setString(1, label);
        ResultSet rs = this.selectCategoryByName.executeQuery();
        Sectie result = null;
        if (rs.next()) {
            result = this.getCategoryFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Vector getCategorii(int idSectie) throws SQLException {
        Vector<Categorie> result = new Vector<Categorie>();
        this.selectSubcategoriesByCategoryId.setInt(1, idSectie);
        this.selectSubcategoriesByCategoryId.setInt(2, idSectie);
        ResultSet rs = this.selectSubcategoriesByCategoryId.executeQuery();
        while (rs.next()) {
            Categorie toAdd = this.getSubCategoryFromRS(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    private Categorie getSubCategoryFromRS(ResultSet rs) throws SQLException {
        int idSubcat = rs.getInt("id");
        int idCat = rs.getInt("id_category");
        int color = rs.getInt("color");
        String label = rs.getString("label");
        int idTva = rs.getInt("id_tva");
        int pretKg = rs.getInt("pret_kg");
        int idValuta = rs.getInt("id_valuta");
        Categorie toAdd = new Categorie(idSubcat, new Integer(idCat), label, rs.getInt("nr_ordine"), rs.getInt("cod"), rs.getString("cod_departament"), idTva, pretKg == 1, rs.getDouble("comision"), idValuta);
        toAdd.setColor(color);
        return toAdd;
    }

    public Vector getAllSubcategories() throws SQLException {
        Vector<Categorie> result = new Vector<Categorie>();
        ResultSet rs = this.selectAllSubcategories.executeQuery();
        while (rs.next()) {
            Categorie toAdd = this.getSubCategoryFromRS(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public Categorie getCategoryById(int cod) throws SQLException {
        this.selectSubcategoryById.setInt(1, cod);
        ResultSet rs = this.selectSubcategoryById.executeQuery();
        Categorie result = null;
        if (rs.next()) {
            result = this.getSubCategoryFromRS(rs);
        }
        rs.close();
        return result;
    }

    public Categorie getCategoryByCod(int cod) throws SQLException {
        this.selectSubcategoryByCod.setInt(1, cod);
        ResultSet rs = this.selectSubcategoryByCod.executeQuery();
        Categorie result = null;
        if (rs.next()) {
            result = this.getSubCategoryFromRS(rs);
        }
        rs.close();
        return result;
    }

    public Categorie getCategoryByName(String name) throws SQLException {
        this.selectSubcategoryByName.setString(1, name);
        ResultSet rs = this.selectSubcategoryByName.executeQuery();
        Categorie result = null;
        if (rs.next()) {
            result = this.getSubCategoryFromRS(rs);
        }
        rs.close();
        return result;
    }

    public void addCategory(Categorie toAdd) throws SQLException {
        this.addSubcategory.setInt(1, toAdd.getSectie());
        this.addSubcategory.setString(2, toAdd.getName());
        this.addSubcategory.setInt(3, toAdd.getColorAsInt());
        this.addSubcategory.setString(4, toAdd.getCodDepartament());
        this.addSubcategory.setInt(5, toAdd.getIdTva());
        this.addSubcategory.setInt(6, toAdd.isPretKg() ? 1 : 0);
        this.addSubcategory.setDouble(7, toAdd.getComision());
        this.addSubcategory.execute();
    }

    public void setOrdine(int idSubcategorie, int idOrdine) throws SQLException {
        this.setNrOrdineForSubcategory.setInt(1, idOrdine);
        this.setNrOrdineForSubcategory.setInt(2, idSubcategorie);
        this.setNrOrdineForSubcategory.execute();
    }

    public void setCod(int idSubcategorie, int cod) throws SQLException {
        this.setCodForSubcategory.setInt(1, cod);
        this.setCodForSubcategory.setInt(2, idSubcategorie);
        this.setCodForSubcategory.execute();
    }

    public void updateCategory(Categorie toUpdate) throws SQLException {
        this.updateSubcategory.setString(1, toUpdate.getName());
        this.updateSubcategory.setInt(2, toUpdate.getNrOrdine());
        this.updateSubcategory.setInt(3, toUpdate.getSectie());
        this.updateSubcategory.setInt(4, toUpdate.getColorAsInt());
        this.updateSubcategory.setString(5, toUpdate.getCodDepartament());
        this.updateSubcategory.setInt(6, toUpdate.getIdTva());
        this.updateSubcategory.setInt(7, toUpdate.isPretKg() ? 1 : 0);
        this.updateSubcategory.setDouble(8, toUpdate.getComision());
        this.updateSubcategory.setInt(9, toUpdate.getId());
        this.updateSubcategory.execute();
    }

    public void updateCategoryNew(Categorie toUpdate) throws SQLException {
        this.updateSubcategoryNew.setString(1, toUpdate.getName());
        this.updateSubcategoryNew.setInt(2, toUpdate.getNrOrdine());
        this.updateSubcategoryNew.setInt(3, toUpdate.getSectie());
        this.updateSubcategoryNew.setInt(4, toUpdate.getColorAsInt());
        this.updateSubcategoryNew.setString(5, toUpdate.getCodDepartament());
        this.updateSubcategoryNew.setInt(6, toUpdate.getIdTva());
        this.updateSubcategoryNew.setInt(7, toUpdate.isPretKg() ? 1 : 0);
        this.updateSubcategoryNew.setDouble(8, toUpdate.getComision());
        this.updateSubcategoryNew.setDouble(9, toUpdate.getIdValuta());
        this.updateSubcategoryNew.setInt(10, toUpdate.getId());
        this.updateSubcategoryNew.execute();
    }

    public void updateSectie(Sectie toUpdate) throws SQLException {
        this.updateCategory.setString(1, toUpdate.getName());
        this.updateCategory.setString(2, toUpdate.getAnalitic());
        this.updateCategory.setString(3, toUpdate.getAnaliticTva());
        this.updateCategory.setInt(4, toUpdate.getId());
        this.updateCategory.execute();
    }

    public void deleteCategory(Categorie toDelete) throws SQLException {
        this.deleteSubcategory.setInt(1, toDelete.getId());
        this.deleteSubcategory.execute();
    }

    private Product getProductFromRS(ResultSet rs) throws SQLException {
        Product p = new Product();
        int idSubcat = rs.getInt("id_subcategory");
        int cod = rs.getInt("cod");
        int idProduct = rs.getInt("id");
        p.setCodSync(rs.getString("cod_sync"));
        p.setIdCategorie(idSubcat);
        p.setCod(cod);
        p.setId(idProduct);
        p.setUzIntern(rs.getInt("uz_intern") == 1);
        p.setExportCantar(rs.getInt("export_cantar") == 1);
        p.setName(rs.getString("label"));
        p.setNumeCasa(rs.getString("short_label"));
        p.setNumeSectie(rs.getString("sectie_label"));
        p.setLiber1(rs.getString("liber1"));
        p.setLiber2(rs.getString("liber2"));
        p.setStatus(rs.getInt("status"));
        return p;
    }

    public Product getProductById(int id) throws SQLException {
        Product result = null;
        this.getProductById.setInt(1, id);
        ResultSet rs = this.getProductById.executeQuery();
        if (rs.next()) {
            result = this.getProductFromRS(rs);
        }
        rs.close();
        return result;
    }

    public Vector<Product> getAllProducts(int tip) throws SQLException {
        Vector<Product> result = new Vector<Product>();
        ResultSet rs = this.selectAllProducts.executeQuery();
        while (rs.next()) {
            Product toAdd = this.getProductFromRS(rs);
            if (toAdd == null) continue;
            if (tip == -1) {
                result.add(toAdd);
                continue;
            }
            if (toAdd.isUzIntern()) continue;
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public Vector<Product> getAllProduseCantar() throws SQLException {
        Vector<Product> result = new Vector<Product>();
        ResultSet rs = this.getProduseCantar.executeQuery();
        while (rs.next()) {
            Product toAdd = this.getProductFromRS(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public Product getProductByCod(int cod) throws SQLException {
        Product result = null;
        this.selectProductByCod.setInt(1, cod);
        ResultSet rs = this.selectProductByCod.executeQuery();
        if (rs.next()) {
            result = this.getProductFromRS(rs);
        }
        rs.close();
        return result;
    }

    public Product getProductByCodBare(String codBare) throws SQLException {
        Product result = null;
        this.selectProductByCodBare.setString(1, codBare);
        ResultSet rs = this.selectProductByCodBare.executeQuery();
        if (rs.next()) {
            result = this.getProductFromRS(rs);
        }
        rs.close();
        return result;
    }

    public Product getProductByCodSync(String codSync) throws SQLException {
        Product result = null;
        this.selectProductByCodSync.setString(1, codSync);
        ResultSet rs = this.selectProductByCodSync.executeQuery();
        if (rs.next()) {
            result = this.getProductFromRS(rs);
        }
        rs.close();
        return result;
    }

    public Product getProductByCodBarePartially(String codBare) throws SQLException {
        Product result = null;
        this.selectProductByPartialCodBare.setString(1, codBare + "%");
        ResultSet rs = this.selectProductByPartialCodBare.executeQuery();
        if (rs.next()) {
            result = this.getProductFromRS(rs);
        }
        rs.close();
        return result;
    }

    public Product getProductByName(String name, int status) throws SQLException {
        Product result = null;
        this.selectProductByName.setString(1, name);
        this.selectProductByName.setInt(2, status);
        this.selectProductByName.setInt(3, status);
        ResultSet rs = this.selectProductByName.executeQuery();
        if (rs.next()) {
            result = this.getProductFromRS(rs);
        }
        rs.close();
        return result;
    }

    public Vector getProductsForCategorie(int idSubcategory, int uzIntern) throws SQLException {
        Vector<Product> result = new Vector<Product>();
        this.selectProductsByCategorieId.setInt(1, idSubcategory);
        this.selectProductsByCategorieId.setInt(2, uzIntern);
        this.selectProductsByCategorieId.setInt(3, uzIntern);
        ResultSet rs = this.selectProductsByCategorieId.executeQuery();
        while (rs.next()) {
            Product toAdd = this.getProductFromRS(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public Vector getProductsForSectie(int idSectie) throws SQLException {
        Vector<Product> result = new Vector<Product>();
        this.selectProductsBySectieId.setInt(1, idSectie);
        ResultSet rs = this.selectProductsBySectieId.executeQuery();
        while (rs.next()) {
            Product toAdd = this.getProductFromRS(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public void updateProduct(Product product) throws SQLException {
        this.updateProduct.setString(1, product.getName());
        this.updateProduct.setString(2, product.getNumeCasa());
        this.updateProduct.setString(3, product.getNumeSectie());
        this.updateProduct.setString(4, product.getLiber1());
        this.updateProduct.setString(5, product.getLiber2());
        this.updateProduct.setInt(6, product.getIdCategorie());
        this.updateProduct.setInt(7, product.getCod());
        this.updateProduct.setInt(8, product.isUzIntern() ? 1 : 0);
        this.updateProduct.setInt(9, product.isExportCantar() ? 1 : 0);
        this.updateProduct.setInt(10, product.getId());
        this.updateProduct.execute();
    }

    public void updateUzInternForProduct(boolean uzIntern, int idProdus) throws SQLException {
        this.updateUzInternForProduct.setInt(1, uzIntern ? 1 : 0);
        this.updateUzInternForProduct.setInt(2, idProdus);
        this.updateUzInternForProduct.execute();
    }

    public void deleteProduct(Product toDelete) throws SQLException {
        this.deleteProduct.setInt(1, toDelete.getId());
        this.deleteProduct.execute();
    }

    public void deleteAllProducts() throws SQLException {
        this.deleteAllProducts.execute();
    }

    public int getPictureForProduct(int idProduct) throws SQLException {
        int result = -1;
        this.getPictureForProduct.setInt(1, idProduct);
        ResultSet rs = this.getPictureForProduct.executeQuery();
        if (rs.next()) {
            result = rs.getInt("id_file");
        }
        rs.close();
        return result;
    }

    public void updateProductPicture(int idProduct, int idFile) throws SQLException {
        this.deletePictureForProduct.setInt(1, idProduct);
        this.deletePictureForProduct.execute();
        this.setPictureForProduct.setInt(1, idFile);
        this.setPictureForProduct.setInt(2, idProduct);
        this.setPictureForProduct.execute();
    }

    public Integer getIdValutaFromCategorie(int idCategorie) throws SQLException {
        Integer result = -1;
        ResultSet rs = SqlUtils.executeQuery("select id_valuta from subcategories where id = " + idCategorie, this.connection);
        if (rs.next()) {
            result = rs.getInt("id_valuta");
        }
        return result;
    }

    public Hashtable<Product, Double> getProductsAndPricesByProductName(String name, int status) throws SQLException {
        Hashtable<Product, Double> result = new Hashtable<Product, Double>();
        this.selectProductByNameAndPrice.setString(1, name);
        this.selectProductByNameAndPrice.setInt(2, status);
        this.selectProductByNameAndPrice.setInt(3, status);
        ResultSet rs = this.selectProductByNameAndPrice.executeQuery();
        while (rs.next()) {
            Product prod = this.getProductFromRS(rs);
            Double price = rs.getDouble("sell_price");
            result.put(prod, price);
        }
        return result;
    }

    public void setValutaForSubcategory(int idCategorie, int idValuta) throws SQLException {
        this.setValutaForSubcategory.setInt(1, idValuta);
        this.setValutaForSubcategory.setInt(2, idCategorie);
        this.setValutaForSubcategory.executeUpdate();
    }

    public Integer getIdCategoryForIdProduct(int idProduct) throws SQLException {
        this.getIdCategoryForIdProduct.setInt(1, idProduct);
        ResultSet rs = this.getIdCategoryForIdProduct.executeQuery();
        if (rs.next()) {
            return rs.getInt("id_subcategory");
        }
        return -1;
    }
}

