/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.nomenclatura.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;
import ro.atreides.utils.valute.Valuta;
import ro.atreides.utils.valute.ValuteLogic;

public class CategoriesPanel
extends AbstractListPanel
implements CleanupRequired {
    private NomeclaturaLogic logic = null;
    private JButton saveButton = null;
    private JButton deleteButton;
    private JComboBox sectiiCombo = new JComboBox();
    private JComboBox tvaCombo = new JComboBox();
    private JComboBox valuteCombo = new JComboBox();
    private JTextField nume;
    private JTextField codDepartament;
    private JTextField comision;
    private Categorie toEdit;
    private JButton colorButton;
    private JCheckBox pretKg;
    private boolean showCuloare;
    private boolean showLaKg;
    private boolean showComision;
    private boolean showDepartament;

    public CategoriesPanel(boolean showCuloare, boolean showLaKg, boolean showComision, boolean showDepartament) {
        this.logic = NomeclaturaLogic.getInstance();
        this.showCuloare = showCuloare;
        this.showLaKg = showLaKg;
        this.showComision = showComision;
        this.showDepartament = showDepartament;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Categorie sc = (Categorie)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return sc.getName();
                    }
                    case 1: {
                        Sectie c = CategoriesPanel.this.logic.getSectieById(sc.getSectie());
                        return c.getName();
                    }
                    case 2: {
                        return sc.getCodDepartament();
                    }
                    case 3: {
                        int idTva = sc.getIdTva();
                        Tva t = TvaLogic.getInstance().getTvaById(idTva);
                        double tva = t.getCota();
                        return Utils.getString2Decimals(tva);
                    }
                    case 4: {
                        return Utils.getString2Decimals(sc.getComision());
                    }
                    case 5: {
                        return ValuteLogic.getInstance().getValutaById(sc.getIdValuta());
                    }
                    case 6: {
                        return new Boolean(sc.isPretKg());
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 0;
        final CategoriesPanel panel = this;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.categorie), c);
        ++c.gridx;
        this.nume = new JTextField(10);
        result.add((Component)this.nume, c);
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.sectie), c);
        ++c.gridx;
        result.add((Component)this.sectiiCombo, c);
        this.codDepartament = new JTextField(3);
        if (this.showDepartament) {
            ++c.gridx;
            result.add(new JLabel(LangRoAll.departament));
            ++c.gridx;
            result.add((Component)this.codDepartament, c);
        }
        this.colorButton = new JButton(LangRoAll.culoare);
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Color c = Color.WHITE;
                if (CategoriesPanel.this.toEdit != null) {
                    c = CategoriesPanel.this.toEdit.getColor();
                }
                Color newColor = JColorChooser.showDialog(panel, LangRoAll.alegetiCuloarea, c);
                CategoriesPanel.this.colorButton.setBackground(newColor);
                CategoriesPanel.this.colorButton.setForeground(GuiUtils.negateColor(newColor));
            }
        });
        this.colorButton.setBackground(Color.WHITE);
        if (this.showCuloare) {
            ++c.gridx;
            result.add((Component)this.colorButton, c);
        }
        ++c.gridx;
        this.saveButton = new JButton(LangRoAll.salveaza);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Sectie c = (Sectie)CategoriesPanel.this.sectiiCombo.getSelectedItem();
                Tva t = (Tva)CategoriesPanel.this.tvaCombo.getSelectedItem();
                Valuta v = (Valuta)CategoriesPanel.this.valuteCombo.getSelectedItem();
                String codDept = c.getId() + "";
                String try1 = CategoriesPanel.this.codDepartament.getText();
                if (Validators.correctString(try1)) {
                    codDept = try1;
                }
                if (!Validators.correctDouble(CategoriesPanel.this.comision.getText())) {
                    DialogUtils.errorDialog(panel, LangRoAll.comisionulNuENumar, LangRoAll.nuPotContinua);
                    CategoriesPanel.this.comision.setText("0");
                    CategoriesPanel.this.comision.requestFocus();
                    return;
                }
                double comi = Utils.parseDouble(CategoriesPanel.this.comision.getText());
                boolean pretKg1 = CategoriesPanel.this.pretKg.isSelected();
                String n = CategoriesPanel.this.nume.getText();
                if (Validators.correctString(n)) {
                    if (CategoriesPanel.this.toEdit == null) {
                        int i = CategoriesPanel.this.logic.newCategory(c.getId(), n, CategoriesPanel.this.colorButton.getBackground().getRGB(), codDept, t.getId(), pretKg1, comi);
                        CategoriesPanel.this.logic.setValutaForCategory(i, v.getId());
                        CategoriesPanel.this.refreshTable();
                    } else {
                        CategoriesPanel.this.toEdit.setSectie(c.getId());
                        CategoriesPanel.this.toEdit.setName(n);
                        CategoriesPanel.this.toEdit.setColor(CategoriesPanel.this.colorButton.getBackground().getRGB());
                        CategoriesPanel.this.toEdit.setCodDepartament(codDept);
                        CategoriesPanel.this.toEdit.setIdTva(t.getId());
                        CategoriesPanel.this.toEdit.setPretKg(pretKg1);
                        CategoriesPanel.this.toEdit.setComision(comi);
                        CategoriesPanel.this.toEdit.setIdValuta(v.getId());
                        CategoriesPanel.this.logic.updateCategoryNew(CategoriesPanel.this.toEdit);
                        CategoriesPanel.this.refreshTable();
                    }
                    CategoriesPanel.this.setObjectToEdit(null);
                }
            }
        });
        result.add((Component)this.saveButton, c);
        c.gridx = 0;
        ++c.gridy;
        result.add((Component)new JLabel(LangRoAll.tva), c);
        ++c.gridx;
        result.add((Component)this.tvaCombo, c);
        this.comision = new JTextField(4);
        this.comision.setText("0");
        if (this.showComision) {
            ++c.gridx;
            result.add((Component)new JLabel(LangRoAll.comisionProcent), c);
            ++c.gridx;
            result.add((Component)this.comision, c);
        }
        this.pretKg = new JCheckBox();
        if (this.showLaKg) {
            ++c.gridx;
            result.add((Component)new JLabel(LangRoAll.laKg), c);
            ++c.gridx;
            result.add((Component)this.pretKg, c);
        }
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.valute), c);
        ++c.gridx;
        result.add((Component)this.valuteCombo, c);
        c.gridx += 2;
        this.deleteButton = new JButton(LangRoAll.sterge);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CategoriesPanel.this.toEdit == null) {
                    return;
                }
                if (DialogUtils.confirmDialog(panel, LangRoAll.confirmareStergereCategorie, LangRoAll.confirmare)) {
                    CategoriesPanel.this.logic.deleteCategory(CategoriesPanel.this.toEdit);
                    CategoriesPanel.this.tm.refresh(CategoriesPanel.this.buildData());
                    DialogUtils.okDialog(panel, LangRoAll.operatieExecutata, LangRoAll.succes);
                    CategoriesPanel.this.setObjectToEdit(null);
                }
            }
        });
        result.add((Component)this.deleteButton, c);
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        return result;
    }

    private void setObjectToEdit(Categorie sub) {
        this.toEdit = sub;
        Color fond = Color.WHITE;
        if (this.toEdit != null) {
            this.nume.setText(this.toEdit.getName());
            Sectie c = this.logic.getSectieById(this.toEdit.getSectie());
            this.sectiiCombo.setSelectedItem(c);
            fond = sub.getColor();
            this.codDepartament.setText(this.toEdit.getCodDepartament().trim());
            Tva t = TvaLogic.getInstance().getTvaById(this.toEdit.getIdTva());
            this.tvaCombo.setSelectedItem(t);
            this.pretKg.setSelected(this.toEdit.isPretKg());
            this.comision.setText(Utils.getString2Decimals(sub.getComision()));
            Valuta valutaById = ValuteLogic.getInstance().getValutaById(this.toEdit.getIdValuta());
            this.valuteCombo.setSelectedItem(this.getValutaInCombo(valutaById));
        } else {
            this.nume.setText("");
            this.codDepartament.setText("");
            this.pretKg.setSelected(false);
            this.comision.setText("0");
        }
        this.colorButton.setBackground(fond);
        this.colorButton.setForeground(GuiUtils.negateColor(fond));
    }

    @Override
    public Vector buildData() {
        return this.logic.getCategoriiForcedOrder(-1);
    }

    @Override
    public String[] buildColumns() {
        return new String[]{LangRoAll.categorie, LangRoAll.sectie, LangRoAll.departament, LangRoAll.tva, LangRoAll.comisionProcent, LangRoAll.valute, LangRoAll.laKg};
    }

    @Override
    public Class[] buildTypes() {
        return new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, Boolean.class};
    }

    @Override
    public void doStuff() {
        EventListener categoriesListener = new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(CategoriesPanel.this.sectiiCombo, CategoriesPanel.this.logic.getAllSectii(), false);
            }

            @Override
            public String getName() {
                return LangRoAll.categorii;
            }
        };
        this.logic.addListener(categoriesListener, 0);
        EventListener valuteListener = new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(CategoriesPanel.this.valuteCombo, ValuteLogic.getInstance().getAllValute(), false);
            }

            @Override
            public String getName() {
                return LangRoAll.valute;
            }
        };
        this.logic.addListener(valuteListener, 456);
        ComboUtils.replaceItemsForCombo(this.sectiiCombo, this.logic.getAllSectii(), false);
        ComboUtils.replaceItemsForCombo(this.tvaCombo, TvaLogic.getInstance().getTvas(), false);
        ComboUtils.replaceItemsForCombo(this.valuteCombo, ValuteLogic.getInstance().getAllValute(), false);
        this.display();
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    return;
                }
                JTable t = (JTable)e.getSource();
                final int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final Categorie sc = (Categorie)CategoriesPanel.this.tm.getObjectAt(selRow);
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem edit = new JMenuItem(LangRoAll.modifica);
                popup.add(edit);
                edit.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CategoriesPanel.this.setObjectToEdit(sc);
                        popup.setVisible(false);
                    }
                });
                JMenuItem mutaSus = new JMenuItem(LangRoAll.mutaInSus);
                popup.add(mutaSus);
                mutaSus.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (selRow > 1) {
                            Categorie upper = (Categorie)CategoriesPanel.this.tm.getObjectAt(selRow - 1);
                            CategoriesPanel.this.logic.switchOrderCategories(upper, sc);
                            CategoriesPanel.this.refreshTable();
                        }
                        popup.setVisible(false);
                    }
                });
                JMenuItem mutaJos = new JMenuItem(LangRoAll.mutaInJos);
                popup.add(mutaJos);
                mutaJos.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (selRow < CategoriesPanel.this.tm.getRowCount() - 1) {
                            Categorie upper = (Categorie)CategoriesPanel.this.tm.getObjectAt(selRow + 1);
                            CategoriesPanel.this.logic.switchOrderCategories(sc, upper);
                            CategoriesPanel.this.refreshTable();
                        }
                        popup.setVisible(false);
                    }
                });
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Categorie sc = (Categorie)CategoriesPanel.this.tm.getData().get(row);
                Color fond = sc.getColor();
                this.setBackground(fond);
                this.setForeground(GuiUtils.negateColor(fond));
                return this;
            }
        };
        TableColumnModel colModel = this.table.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        int i = 0;
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            if (i < 6) {
                column.setCellRenderer(cellRenderer);
            }
            ++i;
        }
        if (!this.showDepartament) {
            colModel.getColumn(2).setMaxWidth(0);
        }
        if (!this.showComision) {
            colModel.getColumn(4).setMaxWidth(0);
        }
        if (!this.showLaKg) {
            colModel.getColumn(6).setMaxWidth(0);
        }
    }

    public Valuta getValutaInCombo(Valuta v) {
        int x = this.valuteCombo.getItemCount();
        for (int i = 0; i < x; ++i) {
            Valuta y = (Valuta)this.valuteCombo.getItemAt(i);
            if (!v.equals(y)) continue;
            return y;
        }
        return null;
    }

    @Override
    public void cleanup() {
        this.tm.refresh(new Vector());
    }
}

