/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.nomenclatura.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.gui.ProductChooserInterface;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;

public class ProductChooser
extends JPanel {
    private XComboBox combo;
    private JButton okButton;
    private JTextField cantitate;
    private Vector data;
    public static boolean pricesLoaded = false;
    private ProductChooserInterface inter;

    public ProductChooser(ProductChooserInterface inter) {
        this.inter = inter;
        this.refreshData();
        this.display();
    }

    public Vector getData() {
        return this.data;
    }

    public void refreshData() {
        this.data = NomeclaturaLogic.getInstance().getAllProducts(1);
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel(LangRoAll.produs), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.combo = new XComboBox(new FilterableComboBoxModel(this.data));
        this.combo.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.add((Component)this.combo, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel(LangRoAll.cantitate), c);
        ++c.gridx;
        this.cantitate = new JTextField(10);
        c.weightx = 1.0;
        this.add((Component)this.cantitate, c);
        final ProductChooser panel = this;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        this.okButton = new JButton(LangRoAll.adauga);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String s = ProductChooser.this.cantitate.getText();
                if (!Validators.correctDouble(s)) {
                    DialogUtils.errorDialog(panel, "Cantitate incorecta", LangRoAll.nuPotContinua);
                    ProductChooser.this.cantitate.requestFocus();
                } else {
                    double f = Utils.parseDouble(s);
                    ProductChooser.this.inter.productChosen(ProductChooser.this.combo.getSelectedItem(), f);
                    ProductChooser.this.combo.requestFocus();
                }
                ProductChooser.this.cantitate.setText("");
                ProductChooser.this.combo.clearAllText();
            }
        });
        this.add((Component)this.okButton, c);
        this.setBorder(new TitledBorder("Adauga produs"));
    }
}

