/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.nomenclatura.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.ProductIcon;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;

public class ProductPicturePanel
extends JPanel {
    private JLabel img;
    private String newPictureFile;
    private String actualPicture;
    private boolean showBorderText = true;
    private int dx;

    public ProductPicturePanel(int dx) {
        this.dx = dx;
        this.display();
    }

    public ProductPicturePanel(boolean borderText, int dx) {
        this.dx = dx;
        this.showBorderText = borderText;
        this.display();
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 2;
        ProductIcon img2 = NomeclaturaLogic.getInstance().loadIcon(-1, null, this.dx);
        this.img = new JLabel(img2.getIcon());
        this.add((Component)this.img, c);
        AbstractBorder b = this.showBorderText ? new TitledBorder("Poza - click pentru a schimba") : new EtchedBorder();
        this.setBorder(b);
    }

    public void setDx(int dx) {
        this.dx = dx;
    }

    public void reload(int idProduct) {
        ProductIcon icon = NomeclaturaLogic.getInstance().loadIcon(idProduct, FileUtils.getTempDir(), this.dx);
        this.img.setIcon(icon.getIcon());
        this.newPictureFile = null;
        this.actualPicture = icon.getFullPath();
        if (this.actualPicture == null) {
            this.actualPicture = "";
        }
    }

    public void reload(String absolutePath) {
        try {
            String extensie = ".jpg";
            int extPoint = absolutePath.lastIndexOf(".");
            if (extPoint > 0) {
                extensie = absolutePath.substring(extPoint);
            }
            String now = Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(new Date());
            String outputFile = FileUtils.getTempDir() + File.separator + now + extensie;
            try {
                FileUtils.copyFiles(new FileInputStream(absolutePath), new FileOutputStream(outputFile));
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
            }
            ImageIcon img2 = Utils.getImageFromDiskAbsolutePath(outputFile);
            this.img.setIcon(img2);
            this.newPictureFile = absolutePath;
        }
        catch (MalformedURLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public String getNewPictureFile() {
        return this.newPictureFile;
    }
}

