/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.nomenclatura.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumnModel;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class SectiiPanel
extends AbstractListPanel {
    private Sectie toEdit;
    private JTextField nume;
    private JTextField analitic;
    private JTextField analiticTva;
    private JButton adaugare;
    private static final String addText = LangRoAll.adauga;
    private static final String saveText = LangRoAll.salveaza;
    private boolean showConturi;

    public SectiiPanel(boolean showConturi) {
        this.showConturi = showConturi;
    }

    @Override
    public String[] buildColumns() {
        return new String[]{LangRoAll.sectie, LangRoAll.analitic, LangRoAll.analiticTva};
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(this.buildColumns().length);
    }

    @Override
    public Vector buildData() {
        return NomeclaturaLogic.getInstance().getAllSectii();
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Sectie mp = (Sectie)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return mp.getName();
                    }
                    case 1: {
                        return mp.getAnalitic();
                    }
                    case 2: {
                        return mp.getAnaliticTva();
                    }
                }
                return null;
            }
        });
        return tm;
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel(LangRoAll.sectie), c);
        ++c.gridx;
        this.nume = new JTextField(10);
        result.add((Component)this.nume, c);
        this.analitic = new JTextField(10);
        this.analiticTva = new JTextField(10);
        if (this.showConturi) {
            ++c.gridx;
            result.add((Component)new JLabel(LangRoAll.analitic), c);
            ++c.gridx;
            result.add((Component)this.analitic, c);
            ++c.gridx;
            result.add((Component)new JLabel(LangRoAll.analiticTva), c);
            ++c.gridx;
            result.add((Component)this.analiticTva, c);
        }
        final SectiiPanel parent = this;
        ++c.gridx;
        this.adaugare = new JButton(addText);
        this.adaugare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String toAdd = SectiiPanel.this.nume.getText();
                String analit = SectiiPanel.this.analitic.getText();
                String tva = SectiiPanel.this.analiticTva.getText();
                if (Validators.correctString(toAdd)) {
                    if (SectiiPanel.this.toEdit == null) {
                        NomeclaturaLogic.getInstance().addSectie(toAdd, analit, tva);
                    } else {
                        SectiiPanel.this.toEdit.setName(toAdd);
                        SectiiPanel.this.toEdit.setAnalitic(analit);
                        SectiiPanel.this.toEdit.setAnaliticTva(tva);
                        NomeclaturaLogic.getInstance().updateSectie(SectiiPanel.this.toEdit);
                    }
                    SectiiPanel.this.setObjectToEdit(null);
                    SectiiPanel.this.refreshTable();
                } else {
                    DialogUtils.errorDialog(parent, LangRoAll.completatiNumeleSectiei, LangRoAll.nuPotContinua);
                    SectiiPanel.this.nume.requestFocus();
                }
            }
        });
        result.add((Component)this.adaugare, c);
        result.setBorder(new TitledBorder(LangRoAll.adaugareSectie));
        return result;
    }

    @Override
    public void doStuff() {
        this.display();
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    return;
                }
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final Sectie sc = (Sectie)SectiiPanel.this.tm.getObjectAt(selRow);
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem edit = new JMenuItem(LangRoAll.modifica);
                popup.add(edit);
                edit.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SectiiPanel.this.setObjectToEdit(sc);
                        popup.setVisible(false);
                    }
                });
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        TableColumnModel colModel = this.table.getColumnModel();
        if (!this.showConturi) {
            colModel.getColumn(1).setMaxWidth(0);
            colModel.getColumn(2).setMaxWidth(0);
        }
    }

    private void setObjectToEdit(Sectie sub) {
        this.toEdit = sub;
        if (this.toEdit != null) {
            this.nume.setText(this.toEdit.getName());
            this.analitic.setText(this.toEdit.getAnalitic());
            this.analiticTva.setText(this.toEdit.getAnaliticTva());
            this.adaugare.setText(saveText);
        } else {
            this.nume.setText("");
            this.analitic.setText("");
            this.adaugare.setText(addText);
            this.analiticTva.setText("");
        }
        this.nume.requestFocus();
    }
}

