/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.pontaj.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.pontaj.PontajLogic;
import ro.atreides.pontaj.gui.CounterView;
import ro.atreides.print.PrintLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class CounterReport
extends AbstractReportPanel
implements CleanupRequired {
    private JComboBox clientiPJ;
    private JComboBox clientiPF;
    public static final String[] columns = new String[]{"Departament", "Numar legitimatie", "Nume", "Count"};
    private JLabel total;
    private ReportInterface pdfReportInterface;
    private Hashtable printCriteria = new Hashtable();
    public static final String DEPARTAMENT_KEY = "Departament";
    public static final String ANGAJAT_KEY = LangRoAll.angajat;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Comparable<Date>> result = new Hashtable<String, Comparable<Date>>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (ComboUtils.anythingButAllSelected(this.clientiPJ)) {
            ClientPersJuridica cpj = (ClientPersJuridica)this.clientiPJ.getSelectedItem();
            this.printCriteria.put(DEPARTAMENT_KEY, cpj.toString());
            result.put(DEPARTAMENT_KEY, Integer.valueOf(cpj.getIdPersJuridica()));
        } else {
            this.printCriteria.remove(DEPARTAMENT_KEY);
        }
        if (ComboUtils.anythingButAllSelected(this.clientiPF)) {
            ClientPersFizica cpf = (ClientPersFizica)this.clientiPF.getSelectedItem();
            this.printCriteria.put(ANGAJAT_KEY, cpf.toString());
            result.put(ANGAJAT_KEY, Integer.valueOf(cpf.getIdPersFizica()));
        } else {
            this.printCriteria.remove(ANGAJAT_KEY);
        }
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        ++c.gridy;
        result.add((Component)new JLabel(DEPARTAMENT_KEY), c);
        ++c.gridx;
        this.clientiPJ = new JComboBox();
        result.add((Component)this.clientiPJ, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.angajat), c);
        ++c.gridx;
        this.clientiPF = new JComboBox();
        result.add((Component)this.clientiPF, c);
        return result;
    }

    @Override
    public AbstractTM buildTableModel() {
        Class[] types = Utils.getStringClass(columns.length);
        this.tm = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                CounterView fe = (CounterView)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return fe.getDepartament();
                    }
                    case 1: {
                        return fe.getNumar();
                    }
                    case 2: {
                        return fe.getNume();
                    }
                    case 3: {
                        return fe.getCount();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.total), c);
        ++c.gridx;
        this.total = new JLabel("");
        result.add((Component)this.total, c);
        return result;
    }

    @Override
    public String getName() {
        return "Counter";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return PontajLogic.getInstance().getCounterClienti(criteria);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, null, this.data);
    }

    @Override
    public void refreshTotalPanel() {
        this.updateTotals(this.data);
    }

    public void updateTotals(Vector items) {
        int suma = 0;
        for (CounterView element : items) {
            suma += element.getCount();
        }
        this.total.setText(suma + "");
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    CounterView entry = (CounterView)o;
                    try {
                        Label label = new Label(0, row, entry.getDepartament());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, entry.getNumar());
                        sheet.addCell((WritableCell)label);
                        label = new Label(2, row, entry.getNume());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(3, row, (double)entry.getCount()));
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return CounterReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    private Vector replacePersFizice() {
        Vector persFizice = ClientLogic.getInstance().getAllPersFiziceSorted();
        return persFizice;
    }

    private Vector replacePersJuridice() {
        Vector<ClientPersJuridica> persFizice = ClientLogic.getInstance().getAllPersJuridiceSorted();
        return persFizice;
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.clientiPJ, this.replacePersJuridice());
        ComboUtils.replaceItemsForCombo(this.clientiPF, this.replacePersFizice());
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public String getName() {
                return "CounterReport_persJuridice";
            }

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(CounterReport.this.clientiPJ, CounterReport.this.replacePersJuridice());
            }
        }, 42);
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public String getName() {
                return "CounterReport_persFizice";
            }

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(CounterReport.this.clientiPF, CounterReport.this.replacePersFizice());
            }
        }, 41);
        this.clientiPJ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(CounterReport.this.clientiPJ)) {
                    Client c = (Client)CounterReport.this.clientiPJ.getSelectedItem();
                    ClientPersJuridica c1 = (ClientPersJuridica)c;
                    Vector angajatiForCompanie = ClientLogic.getInstance().getAnjagati(c1.getIdPersJuridica());
                    ComboUtils.replaceItemsForCombo(CounterReport.this.clientiPF, angajatiForCompanie);
                } else {
                    ComboUtils.replaceItemsForCombo(CounterReport.this.clientiPF, CounterReport.this.replacePersFizice());
                }
            }
        });
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 1;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 3: {
                        return CounterReport.this.total.getText();
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return CounterReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return CounterReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                CounterView fe = (CounterView)row;
                if (fe == null) {
                    return null;
                }
                switch (column) {
                    case 0: {
                        return fe.getDepartament();
                    }
                    case 1: {
                        return fe.getNumar();
                    }
                    case 2: {
                        return fe.getNume();
                    }
                    case 3: {
                        return fe.getCount() + "";
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    @Override
    public void cleanup() {
    }
}

