/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.pontaj.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.pontaj.PontajLogic;
import ro.atreides.pontaj.RaportPontajEntry;
import ro.atreides.print.PrintLogic;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.JMultilineLabel;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class IntrariClienti
extends AbstractReportPanel
implements CleanupRequired {
    private ReportInterface pdfReportInterface;
    private Hashtable printCriteria = new Hashtable();
    private JMultilineLabel total;
    private JComboBox clienti;
    private static final String[] columns = new String[]{LangRoAll.client, "Intrare", "Iesire", LangRoAll.detalii};
    private static final Class[] types = new Class[]{String.class, String.class, String.class, String.class};

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Comparable<Date>> result = new Hashtable<String, Comparable<Date>>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (ComboUtils.anythingButAllSelected(this.clienti)) {
            Client cat = (Client)this.clienti.getSelectedItem();
            result.put("user", Integer.valueOf(cat.getId()));
            this.printCriteria.put(LangRoAll.client, cat.toString());
        } else {
            this.printCriteria.remove(LangRoAll.client);
        }
        return result;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, null, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return PontajLogic.getInstance().getClientsRaportPontaj(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    RaportPontajEntry entry = (RaportPontajEntry)o;
                    try {
                        Label label = new Label(0, row, entry.getUser());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, entry.getStart());
                        sheet.addCell((WritableCell)label);
                        label = new Label(2, row, entry.getStop());
                        sheet.addCell((WritableCell)label);
                        label = new Label(3, row, entry.getDetalii());
                        sheet.addCell((WritableCell)label);
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return IntrariClienti.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Intrari clienti";
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM model = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                RaportPontajEntry se = (RaportPontajEntry)data.elementAt(rowIndex);
                if (se == null) {
                    return null;
                }
                switch (columnIndex) {
                    case 0: {
                        return se.getUser();
                    }
                    case 1: {
                        return se.getStart();
                    }
                    case 2: {
                        return se.getStop();
                    }
                    case 3: {
                        return se.getDetalii();
                    }
                }
                return null;
            }
        });
        return model;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        this.total = new JMultilineLabel();
        this.total.setText("Total :");
        result.add((Component)this.total, c);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel categPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        categPanel.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        this.clienti = new JComboBox();
        this.clienti.setPrototypeDisplayValue("111111111111111111111111111111111");
        categPanel.add((Component)this.clienti, c);
        return categPanel;
    }

    @Override
    public void refreshTotalPanel() {
        String newLabel = "Total intrari : " + this.getNrIntrari();
        this.total.setText(newLabel);
    }

    private int getNrIntrari() {
        int total = 0;
        for (int i = 0; i < this.data.size(); ++i) {
            RaportPontajEntry re = (RaportPontajEntry)this.data.elementAt(i);
            if (!re.isCounted()) continue;
            ++total;
        }
        return total;
    }

    private void refreshClienti() {
        ComboUtils.replaceItemsForCombo(this.clienti, ClientLogic.getInstance().getAllClientsSorted());
    }

    @Override
    public void doStuff() {
        this.refreshClienti();
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public String getName() {
                return "IntrariClienti_persFizice";
            }

            @Override
            public void dataChanged() {
                IntrariClienti.this.refreshClienti();
            }
        }, 41);
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public String getName() {
                return "IntrariClienti_persJuridice";
            }

            @Override
            public void dataChanged() {
                IntrariClienti.this.refreshClienti();
            }
        }, 42);
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 3;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                return "";
            }

            @Override
            public String getReportTitle() {
                return IntrariClienti.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return IntrariClienti.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                RaportPontajEntry ie = (RaportPontajEntry)row;
                if (ie == null) {
                    return null;
                }
                switch (column) {
                    case 0: {
                        return ie.getUser();
                    }
                    case 1: {
                        return ie.getStart();
                    }
                    case 2: {
                        return ie.getStop();
                    }
                    case 3: {
                        return ie.getDetalii();
                    }
                }
                return null;
            }
        };
        final IntrariClienti parent = this;
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem delete = new JMenuItem(LangRoAll.sterge);
                popup.add(delete);
                popup.setInvoker(IntrariClienti.this.table);
                final RaportPontajEntry rpe = (RaportPontajEntry)IntrariClienti.this.tm.getObjectAt(selRow);
                delete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (DialogUtils.confirmDialog(parent, "Doriti sa stergeti aceasta intrare", LangRoAll.confirmare)) {
                            PontajLogic.getInstance().deletePontajEntry(rpe.getId());
                            UsersLogic.getInstance().addUserLogCommit(AdministrationPanel.loggedUser.getId(), "Sters intrare: " + rpe.getUser() + "_" + rpe.getStart() + "_" + rpe.getDetalii());
                            IntrariClienti.this.raport();
                        }
                        popup.setVisible(false);
                    }
                });
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    @Override
    public void cleanup() {
    }
}

