/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.pontaj.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.pontaj.PontajLogic;
import ro.atreides.pontaj.gui.PlanOrarEntry;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class PlanOrarList
extends AbstractListPanel {
    private JTextField startT;
    private JTextField stopT;
    private JTextField payedT;
    private PlanOrarEntry toEdit;

    @Override
    public AbstractTM buildTableModel() {
        return new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                PlanOrarEntry plata = (PlanOrarEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return Formatters.TIME_FORMAT.format(plata.getOraStart());
                    }
                    case 1: {
                        return Formatters.TIME_FORMAT.format(plata.getOraStop());
                    }
                    case 2: {
                        return "1";
                    }
                    case 3: {
                        return Utils.getString2Decimals(plata.getPayedHours());
                    }
                }
                return null;
            }
        });
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Ora start"), c);
        ++c.gridx;
        this.startT = new JTextField(5);
        result.add((Component)this.startT, c);
        ++c.gridx;
        result.add((Component)new JLabel("Ora stop"), c);
        ++c.gridx;
        this.stopT = new JTextField(5);
        result.add((Component)this.stopT, c);
        ++c.gridx;
        result.add((Component)new JLabel("Ore platite"), c);
        ++c.gridx;
        this.payedT = new JTextField(5);
        result.add((Component)this.payedT, c);
        final PlanOrarList parent = this;
        ++c.gridx;
        JButton salveaza = new JButton(LangRoAll.salveaza);
        salveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String start = PlanOrarList.this.startT.getText();
                String stop = PlanOrarList.this.stopT.getText();
                String pay = PlanOrarList.this.payedT.getText();
                if (!Validators.correctDate(start, Formatters.TIME_FORMAT)) {
                    DialogUtils.errorDialog(parent, "Camp Ora start incorect", LangRoAll.nuPotContinua);
                    return;
                }
                if (!Validators.correctDate(stop, Formatters.TIME_FORMAT)) {
                    DialogUtils.errorDialog(parent, "Camp Ora stop incorect", LangRoAll.nuPotContinua);
                    return;
                }
                if (!Validators.correctDouble(pay)) {
                    DialogUtils.errorDialog(parent, "Camp Ore platite incorect", LangRoAll.nuPotContinua);
                    return;
                }
                Date d1 = DateUtils.setTimeToDate2(new Date(), PlanOrarList.this.startT);
                Timestamp t1 = new Timestamp(d1.getTime());
                Date d2 = DateUtils.setTimeToDate2(new Date(), PlanOrarList.this.stopT);
                Timestamp t2 = new Timestamp(d2.getTime());
                double payed = Utils.parseDouble(pay);
                if (PlanOrarList.this.toEdit != null) {
                    PontajLogic.getInstance().savePlanOrarEntry(PlanOrarList.this.toEdit.getId(), t1, t2, payed);
                    PlanOrarList.this.refreshTable();
                    PlanOrarList.this.setObjectToEdit(null);
                    PlanOrarList.this.startT.requestFocus();
                } else {
                    PontajLogic.getInstance().addPlanOrarEntry(t1, t2, payed);
                    PlanOrarList.this.refreshTable();
                    PlanOrarList.this.setObjectToEdit(null);
                    PlanOrarList.this.startT.requestFocus();
                }
            }
        });
        result.add((Component)salveaza, c);
        ++c.gridx;
        JButton sterge = new JButton(LangRoAll.sterge);
        sterge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PlanOrarList.this.toEdit != null) {
                    if (DialogUtils.confirmDialog(parent, "Stergem acest plan orar", LangRoAll.confirmare)) {
                        PontajLogic.getInstance().deletePlanOrarEntry(PlanOrarList.this.toEdit.getId());
                    }
                    PlanOrarList.this.refreshTable();
                    PlanOrarList.this.setObjectToEdit(null);
                    PlanOrarList.this.startT.requestFocus();
                }
            }
        });
        result.add((Component)sterge, c);
        result.setBorder(new TitledBorder("Salvare/stergere"));
        return result;
    }

    private void setObjectToEdit(PlanOrarEntry toEdit) {
        if (toEdit != null) {
            this.startT.setText(Formatters.TIME_FORMAT.format(toEdit.getOraStart()));
            this.stopT.setText(Formatters.TIME_FORMAT.format(toEdit.getOraStop()));
            this.payedT.setText(Utils.getString2Decimals(toEdit.getPayedHours()));
        } else {
            this.startT.setText("");
            this.stopT.setText("");
            this.payedT.setText("");
        }
        this.toEdit = toEdit;
    }

    @Override
    public Vector buildData() {
        return PontajLogic.getInstance().getPlanOrar();
    }

    @Override
    public String[] buildColumns() {
        return new String[]{"Ora start", "Ora stop", "Ore lucrate", "Ore platite"};
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(this.buildColumns().length);
    }

    @Override
    public void doStuff() {
        this.display();
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                if (e.getClickCount() > 1) {
                    PlanOrarEntry sc = (PlanOrarEntry)PlanOrarList.this.tm.getObjectAt(selRow);
                    PlanOrarList.this.setObjectToEdit(sc);
                }
            }
        });
    }
}

