/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.pontaj.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import ro.atreides.pontaj.PontajLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.CardInputDialog;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class PontajPanel
extends ReflectedJPanel {
    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(10, 10, 10, 10);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        final PontajPanel parent = this;
        JButton punchIn = new JButton("Intrare");
        punchIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                CardInputDialog dialog = new CardInputDialog((Frame)GuiUtils.currentFrame, true, Config.getInstance().getInt("codAutentificareLength"));
                dialog.setVisible(true);
                String cod = dialog.getCodAutentificare();
                User u = UsersLogic.getInstance().getUserByCodAutentificare(cod);
                if (u == null) {
                    DialogUtils.errorDialog(parent, "Utilizator inexistent", LangRoAll.nuPotContinua);
                    return;
                }
                PontajLogic.getInstance().punchUserIn(u.getId(), "");
                DialogUtils.okDialog(parent, "Intrare inregistrata pentru " + u.getLogin(), LangRoAll.succes);
            }
        });
        this.add((Component)punchIn, c);
        ++c.gridx;
        JButton punchOut = new JButton("Iesire");
        punchOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                CardInputDialog dialog = new CardInputDialog((Frame)GuiUtils.currentFrame, true, Config.getInstance().getInt("codAutentificareLength"));
                dialog.setVisible(true);
                String cod = dialog.getCodAutentificare();
                User u = UsersLogic.getInstance().getUserByCodAutentificare(cod);
                if (u == null) {
                    DialogUtils.errorDialog(parent, "Utilizator inexistent", LangRoAll.nuPotContinua);
                    return;
                }
                PontajLogic.getInstance().punchUserOut(u.getId());
                DialogUtils.okDialog(parent, "Iesire inregistrata pentru " + u.getLogin(), LangRoAll.succes);
            }
        });
        this.add((Component)punchOut, c);
        punchIn.setFocusable(false);
        punchOut.setFocusable(false);
    }

    @Override
    public void doStuff() {
        this.display();
    }
}

