/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.print;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.print.PrinterBonItem;
import ro.atreides.print.PrinterSale;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;

public class DocumentXmlHandler
extends DefaultHandler {
    private StringBuffer text;
    private Hashtable fields;
    private Vector items;
    private XMLReader itemsReader;
    private DocumentXmlHandler handler;
    private String lineFile;
    private StringBuffer currentLine;
    public static final String SALE_PRODUS = "produs";
    public static final String SALE_CANTITATE = "cantitate";
    public static final String SALE_PRET = "pret";
    public static final String SALE_VALOARE = "valoare";
    private String cutterSequence;

    public DocumentXmlHandler() {
    }

    public DocumentXmlHandler(Hashtable fields, Vector items, XMLReader itemsReader, DocumentXmlHandler lineHandler, String lineFile, String cutterSequence) {
        this.fields = fields;
        this.items = items;
        this.itemsReader = itemsReader;
        this.handler = lineHandler;
        this.lineFile = lineFile;
        this.cutterSequence = cutterSequence;
    }

    public StringBuffer getText() {
        return this.text;
    }

    public DocumentXmlHandler(Hashtable fields) {
        this.fields = fields;
    }

    public Hashtable getFields() {
        return this.fields;
    }

    public void setFields(Hashtable fields) {
        this.fields = fields;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Hashtable<String, String> lineFields;
        Object o;
        int i;
        if (qName.equalsIgnoreCase("document")) {
            this.text = new StringBuffer();
        }
        if (qName.equalsIgnoreCase("line")) {
            this.currentLine = new StringBuffer();
        }
        if (qName.equalsIgnoreCase("sales")) {
            for (i = 0; i < this.items.size(); ++i) {
                o = (PrinterSale)this.items.elementAt(i);
                lineFields = new Hashtable<String, String>();
                lineFields.put(SALE_PRODUS, ((PrinterSale)o).getProduct());
                lineFields.put(SALE_CANTITATE, ((PrinterSale)o).getQuantity());
                lineFields.put(SALE_PRET, ((PrinterSale)o).getPrice());
                lineFields.put(SALE_VALOARE, ((PrinterSale)o).getValue());
                this.handler.setFields(lineFields);
                try {
                    this.itemsReader.parse(this.lineFile);
                    this.text.append(this.handler.getText());
                    continue;
                }
                catch (IOException e) {
                    Logger.logException(this, (Exception)e);
                }
            }
        }
        if (qName.equalsIgnoreCase("comenzi")) {
            for (i = 0; i < this.items.size(); ++i) {
                o = (PrinterBonItem)this.items.elementAt(i);
                lineFields = new Hashtable();
                lineFields.put(SALE_PRODUS, ((PrinterBonItem)o).getProduct());
                lineFields.put(SALE_CANTITATE, ((PrinterBonItem)o).getQuantity());
                lineFields.put(SALE_VALOARE, ((PrinterBonItem)o).getValoare());
                this.handler.setFields(lineFields);
                try {
                    this.itemsReader.parse(this.lineFile);
                    this.text.append(this.handler.getText());
                    continue;
                }
                catch (IOException e) {
                    Logger.logException(this, (Exception)e);
                }
            }
        }
        if (qName.equalsIgnoreCase("space")) {
            int spaces = Integer.parseInt(attributes.getValue("size"));
            String string = attributes.getValue("char");
            for (int i2 = 0; i2 < spaces; ++i2) {
                this.currentLine.append(string.substring(0, 1));
            }
        }
        if (qName.equalsIgnoreCase("text")) {
            String text1 = attributes.getValue("value");
            this.currentLine.append(text1);
        }
        if (qName.equalsIgnoreCase("info")) {
            int size = Integer.parseInt(attributes.getValue("size"));
            String field = attributes.getValue("field");
            String align = attributes.getValue("align");
            boolean rightAlign = false;
            if (align != null && align.equalsIgnoreCase("right")) {
                rightAlign = true;
            }
            String value = (String)this.fields.get(field);
            if (field != null && value != null) {
                String toAdd = Utils.getStringMaxSize(size, value, Character.valueOf(' '), rightAlign);
                this.currentLine.append(toAdd);
            }
        }
        if (qName.equalsIgnoreCase("esc")) {
            String text1 = '\u001b' + attributes.getValue("value");
            this.currentLine.append(text1);
        }
        if (qName.equalsIgnoreCase("cutter")) {
            this.currentLine.append(this.cutterSequence);
        }
        if (qName.equalsIgnoreCase("int")) {
            try {
                int i3 = Integer.parseInt(attributes.getValue("value"));
                this.currentLine.append((char)i3);
            }
            catch (NumberFormatException e) {
                Logger.logException(this, (Exception)e);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("line") && this.currentLine.length() > 0) {
            this.text.append(this.currentLine.toString() + '\n');
        }
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        Logger.logException(this, (Exception)ex);
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        Logger.logException(this, (Exception)ex);
    }
}

