/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.print;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.viewer.PreviewDialog;
import org.apache.fop.viewer.ProgressListener;
import org.apache.fop.viewer.SecureResourceBundle;
import org.apache.fop.viewer.Translator;
import org.apache.fop.viewer.UserMessage;

public class PrintPreview {
    public static final String TRANSLATION_PATH = "/org/apache/fop/viewer/resources/";

    protected PreviewDialog createPreviewDialog(AWTRenderer renderer, Translator res) {
        PreviewDialog frame = new PreviewDialog(renderer, res);
        frame.validate();
        frame.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent we) {
            }
        });
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
        return frame;
    }

    private SecureResourceBundle getResourceBundle(String path) throws IOException {
        URL url = this.getClass().getResource(path);
        if (url == null) {
            path = path.substring(0, path.lastIndexOf(".")) + ".en";
            url = this.getClass().getResource(path);
        }
        return new SecureResourceBundle(url.openStream());
    }

    public void viewFO(File fo) throws IOException, FOPException, TransformerException {
        String language = System.getProperty("user.language");
        SecureResourceBundle translator = this.getResourceBundle("/org/apache/fop/viewer/resources/resources." + language);
        translator.setMissingEmphasized(false);
        UserMessage.setTranslator((Translator)this.getResourceBundle("/org/apache/fop/viewer/resources/messages." + language));
        AWTRenderer renderer = new AWTRenderer((Translator)translator);
        PreviewDialog frame = this.createPreviewDialog(renderer, (Translator)translator);
        renderer.setProgressListener((ProgressListener)frame);
        renderer.setComponent((Component)frame);
        Driver driver = new Driver();
        driver.setLogger((Logger)new ConsoleLogger(1));
        driver.setRenderer((Renderer)renderer);
        try {
            frame.progress(translator.getString("Build FO tree") + " ...");
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            StreamSource src = new StreamSource(fo);
            SAXResult res = new SAXResult(driver.getContentHandler());
            transformer.transform(src, res);
            frame.progress(translator.getString("Show"));
            frame.showPage();
        }
        catch (Exception e) {
            frame.reportException(e);
            if (e instanceof FOPException) {
                throw (FOPException)((Object)e);
            }
            throw new FOPException((Throwable)e);
        }
    }
}

