/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.print.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.print.Item;
import ro.atreides.print.PrintLogic;
import ro.atreides.print.PrinterEntry;
import ro.atreides.utils.db.DaoInterface;

public class PrintersImpl
implements DaoInterface {
    private Connection connection;
    private PreparedStatement selectAllPrinters;
    private PreparedStatement deleteAllPrinters;
    private PreparedStatement updatePrinterClassname;
    private PreparedStatement addPrinter;
    private PreparedStatement deletePrinter;
    private PreparedStatement selectCategoriesForPrinter;
    private PreparedStatement deleteAllPrinterCategories;
    private PreparedStatement insertPrinterCategory;
    private PreparedStatement deleteCategoriesForPrinter;
    private PreparedStatement insertPrinterMapping;
    private PreparedStatement selectMappingsForPrinter;
    private PreparedStatement deletePrinterMappingsForPrinter;
    private PreparedStatement deleteAllPrinterMappings;
    private PreparedStatement getPrinterItemByKey;
    private PreparedStatement selectAllItems;
    private PreparedStatement deleteAllMappings;
    private PreparedStatement selectNoteConfigForPrinter;
    private PreparedStatement deleteAllNoteConfigForPrinter;
    private PreparedStatement insertNoteConfigForPrinter;

    public Connection getConnection() {
        return this.connection;
    }

    public PrintersImpl(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.selectAllPrinters = this.connection.prepareStatement("select * from printers where id_machine = ( select id from network where name = ? )");
        this.deleteAllPrinters = this.connection.prepareStatement("delete from printers where id_machine = ( select id from network where name = ? )");
        this.updatePrinterClassname = this.connection.prepareStatement("update printers set classname = ? where id = ?");
        this.addPrinter = this.connection.prepareStatement("insert into printers (label, classname, id_machine ) values ( ?, ?, ( select id from network where name = ? ) ) ");
        this.deletePrinter = this.connection.prepareStatement("delete from printers where id = ?");
        this.insertPrinterCategory = this.connection.prepareStatement("insert into printer_categories( id_category, id_printer, id_locatie ) values ( ?, ?, ?) ");
        this.selectCategoriesForPrinter = this.connection.prepareStatement("select * from printer_categories where id_printer = ?");
        this.deleteAllPrinterCategories = this.connection.prepareStatement("delete from printer_categories where id_printer in ( select printers.id as id from printers inner join network on printers.id_machine = network.id where network.name = ? ) ");
        this.deleteCategoriesForPrinter = this.connection.prepareStatement("delete from printer_categories where id_printer = ?");
        this.deleteAllPrinterMappings = this.connection.prepareStatement("delete from mapping_printers_items where id_printer in ( select printers.id as id from printers inner join network on printers.id_machine = network.id where network.name = ? ) ");
        this.deletePrinterMappingsForPrinter = this.connection.prepareStatement("delete from mapping_printers_items where id_printer = ?");
        this.insertPrinterMapping = this.connection.prepareStatement("insert into mapping_printers_items (id_item, id_printer) values (?,?)");
        this.selectMappingsForPrinter = this.connection.prepareStatement("select * from mapping_printers_items where id_printer = ?");
        this.selectAllItems = this.connection.prepareStatement("select printer_items.id as id, messages.label as label from printer_items inner join keys on printer_items.id_key = keys.id inner join messages on keys.id = messages.id_key where messages.id_lang = ?");
        this.getPrinterItemByKey = this.connection.prepareStatement("select printer_items.id as id from printer_items inner join keys on printer_items.id_key = keys.id where keys.label = ?");
        this.deleteAllMappings = this.connection.prepareStatement("delete from printer_categories");
        this.selectNoteConfigForPrinter = this.connection.prepareStatement("select * from mapping_printer_nota where id_printer = ?");
        this.deleteAllNoteConfigForPrinter = this.connection.prepareStatement("delete from mapping_printer_nota where id_printer = ?");
        this.insertNoteConfigForPrinter = this.connection.prepareStatement("insert into mapping_printer_nota (id_printer, id_locatie) values (?,?)");
    }

    public void deleteAllMappings() throws SQLException {
        this.deleteAllMappings.execute();
    }

    public void addPrinter(PrinterEntry toAdd, String localMachine) throws SQLException {
        this.addPrinter.setString(1, toAdd.getName());
        this.addPrinter.setString(2, toAdd.getClassname());
        this.addPrinter.setString(3, localMachine);
        this.addPrinter.execute();
    }

    public Vector<PrinterEntry> getPrinters(String localComputerName) throws SQLException {
        Vector<PrinterEntry> result = new Vector<PrinterEntry>();
        this.selectAllPrinters.setString(1, localComputerName);
        ResultSet rs = this.selectAllPrinters.executeQuery();
        while (rs.next()) {
            PrinterEntry p = new PrinterEntry();
            int id = rs.getInt("id");
            p.setId(id);
            p.setName(rs.getString("label"));
            p.setClassname(rs.getString("classname"));
            Hashtable categories = this.getCategoriesForPrinter(id);
            p.setCategories(categories);
            Hashtable note = this.getNoteConfigForPrinter(id);
            p.setNoteHash(note);
            Hashtable items = this.getMappingsForPrinter(id);
            p.setItems(items);
            result.add(p);
        }
        rs.close();
        return result;
    }

    public Hashtable getCategoriesForPrinter(int printerId) throws SQLException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        this.selectCategoriesForPrinter.setInt(1, printerId);
        ResultSet rs = this.selectCategoriesForPrinter.executeQuery();
        while (rs.next()) {
            int idCat = rs.getInt("id_category");
            int idLoc = rs.getInt("id_locatie");
            result.put(PrintLogic.buildCategoryKey(idCat, idLoc), new Object());
        }
        rs.close();
        return result;
    }

    public Hashtable getNoteConfigForPrinter(int printerId) throws SQLException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        this.selectNoteConfigForPrinter.setInt(1, printerId);
        ResultSet rs = this.selectNoteConfigForPrinter.executeQuery();
        while (rs.next()) {
            int idLoc = rs.getInt("id_locatie");
            result.put(PrintLogic.buildNotePrinterKey(idLoc), new Object());
        }
        rs.close();
        return result;
    }

    public Hashtable getMappingsForPrinter(int printerId) throws SQLException {
        Hashtable<Integer, Object> result = new Hashtable<Integer, Object>();
        this.selectMappingsForPrinter.setInt(1, printerId);
        ResultSet rs = this.selectMappingsForPrinter.executeQuery();
        while (rs.next()) {
            Integer cat = new Integer(rs.getInt("id_item"));
            result.put(cat, new Object());
        }
        rs.close();
        return result;
    }

    public void updatePrinter(PrinterEntry toUpdate) throws SQLException {
        int id = toUpdate.getId();
        this.updatePrinterClassname.setString(1, toUpdate.getClassname());
        this.updatePrinterClassname.setInt(2, id);
        this.updatePrinterClassname.execute();
        this.updateMappingsForPrinter(toUpdate, id);
        this.updateCategoriesForPrinter(toUpdate, id);
        this.updateNoteConfigForPrinter(toUpdate, id);
    }

    public void updateMappingsForPrinter(PrinterEntry toUpdate, int id) throws SQLException {
        this.deletePrinterMappingsForPrinter.setInt(1, id);
        this.deletePrinterMappingsForPrinter.execute();
        for (Integer element : toUpdate.getItems().keySet()) {
            this.insertPrinterMapping.setInt(1, element);
            this.insertPrinterMapping.setInt(2, id);
            this.insertPrinterMapping.execute();
        }
    }

    public void updateCategoriesForPrinter(PrinterEntry toUpdate, int id) throws SQLException {
        this.deleteCategoriesForPrinter.setInt(1, id);
        this.deleteCategoriesForPrinter.execute();
        for (String key : toUpdate.getCategories().keySet()) {
            int idCat = PrintLogic.getIdFromKey(key, 0);
            int idLoc = PrintLogic.getIdFromKey(key, 1);
            this.insertPrinterCategory.setInt(1, idCat);
            this.insertPrinterCategory.setInt(2, id);
            this.insertPrinterCategory.setInt(3, idLoc);
            this.insertPrinterCategory.execute();
        }
    }

    public void updateNoteConfigForPrinter(PrinterEntry toUpdate, int id) throws SQLException {
        this.deleteAllNoteConfigForPrinter.setInt(1, id);
        this.deleteAllNoteConfigForPrinter.execute();
        for (String key : toUpdate.getNoteHash().keySet()) {
            int idLoc = PrintLogic.getIdFromKey(key, 1);
            this.insertNoteConfigForPrinter.setInt(1, id);
            this.insertNoteConfigForPrinter.setInt(2, idLoc);
            this.insertNoteConfigForPrinter.execute();
        }
    }

    public void removeAllPrinters(String localComputerName) throws SQLException {
        this.deleteAllPrinterMappings.setString(1, localComputerName);
        this.deleteAllPrinterMappings.execute();
        this.deleteAllPrinterCategories.setString(1, localComputerName);
        this.deleteAllPrinterCategories.execute();
        this.deleteAllPrinters.setString(1, localComputerName);
        this.deleteAllPrinters.execute();
    }

    public int getPrinterItemIdByKey(String key) throws SQLException {
        this.getPrinterItemByKey.setString(1, key);
        ResultSet rs = this.getPrinterItemByKey.executeQuery();
        int result = -1;
        if (rs.next()) {
            result = rs.getInt("id");
        }
        rs.close();
        return result;
    }

    public Vector getAllItems(int idLanguage) throws SQLException {
        Vector<Item> result = new Vector<Item>();
        this.selectAllItems.setInt(1, idLanguage);
        ResultSet rs = this.selectAllItems.executeQuery();
        while (rs.next()) {
            String label = rs.getString("label");
            int id = rs.getInt("id");
            Item newItem = new Item(id, label);
            result.add(newItem);
        }
        rs.close();
        return result;
    }

    public void deletePrinter(int idPrinter) throws SQLException {
        this.deletePrinterMappingsForPrinter.setInt(1, idPrinter);
        this.deletePrinterMappingsForPrinter.execute();
        this.deleteCategoriesForPrinter.setInt(1, idPrinter);
        this.deleteCategoriesForPrinter.execute();
        this.deletePrinter.setInt(1, idPrinter);
        this.deletePrinter.execute();
    }
}

