/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.print.printers;

import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import ro.atreides.print.AbstractPrinter;
import ro.atreides.print.PrintLogic;
import ro.atreides.print.PrinterBonItem;
import ro.atreides.print.PrinterSale;
import ro.atreides.print.PrinterSalesTotalPerSectie;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ProguardKeepNames;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public class AsciiPrinter
extends AbstractPrinter
implements Runnable,
ProguardKeepNames {
    private int charactersPerPrintJob;
    private int linesPerPrintJob;
    private int secondsSleepBetweenPrintJobs;
    protected int notaLineFeed;
    protected int bonLineFeed;
    private Vector queue = new Vector();
    private boolean notaNumbering = false;
    private String header = "";
    private String footer = "";
    protected boolean openDrawer = false;

    public AsciiPrinter() {
        this.notaLineFeed = this.config.getInt("notaLineFeed");
        this.bonLineFeed = this.config.getInt("bonLineFeed");
        this.charactersPerPrintJob = this.config.getInt("charactersPerPrintJob");
        this.linesPerPrintJob = this.config.getInt("linesPerPrintJob");
        this.secondsSleepBetweenPrintJobs = this.config.getInt("secondsSleepBetweenPrintJobs");
        this.notaNumbering = this.config.getBoolean("notaNumbering");
        this.header = this.config.getString("notaHeader", "");
        this.footer = this.config.getString("notaFooter", "");
        this.openDrawer = this.config.getBoolean("printerOpenDrawer");
        new Thread(this).start();
    }

    protected String center(String center, int chars, char c) {
        String result = "";
        StringTokenizer token = new StringTokenizer(center, " ");
        String next = "";
        while (token.hasMoreTokens() || next != null) {
            String line;
            block6: {
                line = next;
                while (token.hasMoreTokens()) {
                    String current = token.nextToken();
                    int size = current.length();
                    if (line.length() + size >= chars) {
                        next = current;
                    } else {
                        line = line + current + " ";
                        next = "";
                        if (token.hasMoreTokens()) continue;
                    }
                    break block6;
                }
                next = null;
            }
            line = line.trim();
            int rest = chars - line.length();
            if (rest < 0) {
                rest = 0;
            }
            int left = rest / 2;
            int right = rest - left;
            line = Utils.getStringMaxSize(left, "", Character.valueOf(c), false) + line + Utils.getStringMaxSize(right, "", Character.valueOf(c), false);
            if (next != null && next.length() != 0) {
                line = line + "\n";
            }
            result = result + line;
        }
        return result;
    }

    protected String feedNota() {
        String s = "";
        String startOfLine = "\n" + VpConfig.getInstance().raportInchiderePreambul;
        for (int i = 0; i < this.notaLineFeed; ++i) {
            s = s + startOfLine;
        }
        return s;
    }

    protected String feedBon() {
        String s = "";
        for (int i = 0; i < this.bonLineFeed; ++i) {
            s = s + "\n";
        }
        return s;
    }

    protected String getSale2Lines(PrinterSale element) {
        if (!element.isEmptyLine()) {
            String s = Utils.arrange(element.getProduct(), "", this.charsPerLine, ' ') + "\n";
            s = element.getPrice() != null ? s + Utils.arrange(element.getQuantity() + " * " + element.getPrice(), element.getValue(), this.charsPerLine, ' ') + "\n" : s + Utils.arrange("", element.getValue(), this.charsPerLine, ' ') + "\n";
            return s;
        }
        return "\n";
    }

    protected String getSale1Line(PrinterSale element) {
        if (!element.isEmptyLine()) {
            String left = element.getQuantity() + "|" + element.getProduct();
            String right = element.getValue();
            int leftSize = this.charsPerLine - right.length() - 2;
            leftSize = leftSize > left.length() ? left.length() : leftSize;
            left = left.substring(0, leftSize);
            String s = Utils.arrange(left, right, this.charsPerLine, ' ') + "\n";
            return s;
        }
        return "\n";
    }

    protected String getAutocutterSequence() {
        return "";
    }

    protected String getStartOfNota() {
        if (this.bonLineFeed == 0) {
            return this.feedNota();
        }
        return "";
    }

    protected String getStartOfMiddlePage() {
        return "";
    }

    protected String getEndOfMiddlePage() {
        return "";
    }

    protected void addJob(String text) {
        this.queue.add(text);
    }

    protected String getNotaStartFontSelection() {
        return "";
    }

    protected String getNotaStopFontSelection() {
        return "";
    }

    protected String getBonStopFontSelection() {
        return "";
    }

    protected String getBonStartFontSelection() {
        return "";
    }

    protected String getCharacterTableSelection() {
        return "";
    }

    @Override
    public void run() {
        block6: while (true) {
            try {
                while (true) {
                    if (this.queue.size() > 0) {
                        String job = (String)this.queue.remove(0);
                        if (job == null) continue;
                        this.printSingleJob(job);
                        try {
                            if (this.charactersPerPrintJob == -1 && this.linesPerPrintJob == -1) continue block6;
                            Thread.sleep(this.secondsSleepBetweenPrintJobs);
                            continue block6;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                    }
                    try {
                        Thread.sleep(500L);
                        continue block6;
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                Logger.logException(this, e);
                continue;
            }
            break;
        }
    }

    protected void printSingleJob(String text) {
        Logger.logDebugVerbose(this, "NOTA " + text);
        byte[] buffer = text.getBytes();
        SimpleDoc myDoc = new SimpleDoc(buffer, DocFlavor.BYTE_ARRAY.AUTOSENSE, null);
        DocPrintJob job = this.printService.createPrintJob();
        try {
            job.print(myDoc, this.attributeSet);
        }
        catch (PrintException pe) {
            if (!this.config.getBoolean("asciiPrinterIgnoreLprError")) {
                Logger.logException(this, (Exception)pe);
            }
            Logger.logWarning(this, "PrintException : " + pe.getMessage());
        }
    }

    @Override
    public void printPdf(String pdfFile, int copii) {
        throw new UnsupportedOperationException("Printer " + this.getClass().getName() + " cannot print graphics");
    }

    @Override
    public void printBonLivrare(Vector<PrinterBonItem> livrareItems, String ospatar, String table, String data, double valoare) {
        boolean printValue = this.config.getBoolean("printBonValue");
        String s = this.getBonStartFontSelection();
        s = s + "Livrare " + data + "\n" + ospatar + " " + table;
        if (printValue) {
            s = s + " Total= " + Utils.getString2Decimals(valoare);
        }
        s = s + "\n";
        for (PrinterBonItem item : livrareItems) {
            s = s + item.getQuantity() + "   " + item.getProduct();
            if (printValue) {
                s = s + " =" + item.getValoare();
            }
            s = s + "\n";
        }
        s = this.bonLineFeed > 0 ? s + this.feedBon() : s + "\n";
        s = s + this.getBonStopFontSelection();
        s = s + this.getAutocutterSequence();
        Vector<String> v = new Vector<String>();
        v.add(s);
        this.printText(v, false);
    }

    @Override
    public String printBon(Vector<PrinterBonItem> bonItems, String waiter, boolean protocol, String nrBon, String table, String titluBon, int copii, String total, String detaliiLivrare, boolean cutter, String adresaClient, String numeClient, String telefonClient) {
        String s = this.getCharacterTableSelection();
        s = s + this.getBonStartFontSelection();
        boolean printValue = this.config.getBoolean("printBonValue");
        s = s + titluBon + " " + nrBon + " " + table + (printValue ? " =" + total : "") + "\n" + waiter + " " + Utils.getCurrentDateAndTimeForPrinter() + "\n";
        for (PrinterBonItem element : bonItems) {
            s = s + element.getQuantity() + "   " + element.getProduct();
            if (printValue) {
                s = s + " =" + element.getValoare();
            }
            if (protocol) {
                s = s + " PROTOCOL";
            }
            s = s + "\n";
        }
        s = this.bonLineFeed > 0 ? s + this.feedBon() : s + "\n";
        s = s + this.getBonStopFontSelection();
        if (cutter) {
            s = s + this.getAutocutterSequence();
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < copii; ++i) {
            v.add(s);
        }
        this.printText(v, false);
        return s;
    }

    @Override
    public void printText(Vector pagini, boolean isRaport) {
        for (int j = 0; j < pagini.size(); ++j) {
            String text = (String)pagini.get(j);
            if (isRaport) {
                text = text + this.feedNota();
                text = text + this.getAutocutterSequence();
            }
            if (this.charactersPerPrintJob != -1) {
                int bufferSize = this.charactersPerPrintJob;
                int begin = 0;
                int charsLeft = text.length() - begin;
                while (charsLeft > 0) {
                    int end = Math.min(begin + bufferSize, text.length());
                    String buffer = text.substring(begin, end);
                    charsLeft = text.length() - begin;
                    begin = end;
                    this.addJob(buffer);
                }
                continue;
            }
            if (this.linesPerPrintJob != -1) {
                StringTokenizer token = new StringTokenizer(text, "\n", true);
                boolean firstPage = true;
                while (token.hasMoreTokens()) {
                    String buffer = firstPage ? "" : this.getStartOfMiddlePage();
                    for (int i = 0; i < 2 * this.linesPerPrintJob && token.hasMoreTokens(); ++i) {
                        buffer = buffer + token.nextToken();
                    }
                    buffer = buffer + this.getEndOfMiddlePage();
                    this.addJob(buffer);
                    firstPage = false;
                }
                continue;
            }
            this.addJob(text);
        }
    }

    protected String getTitleStartFontSelection() {
        return "";
    }

    protected String getTitleStopFontSelection() {
        return "";
    }

    public String getExemplarString(String value) {
        String result = "";
        if (Validators.correctString(value)) {
            result = result + value;
            result = result + "\n" + Utils.getStringMaxSize(this.charsPerLine, "", Character.valueOf('-'), false) + "\n";
        }
        return result;
    }

    public String getNotaString(int nota) {
        String result = "";
        if (this.notaNumbering) {
            result = result + "Nota nr " + nota;
            result = result + "\n" + Utils.getStringMaxSize(this.charsPerLine, "", Character.valueOf('-'), false) + "\n";
        }
        return result;
    }

    public int getTallFontCharsPerLine() {
        return this.charsPerLine;
    }

    protected String getLogoCommand() {
        return "";
    }

    @Override
    public void printNota(Vector<PrinterSale> sales, String discount, String total, String totalDupaDiscount, String waiter, String table, boolean protocol, String tva, Vector plati, String promoName, int nrNota, String adresaClient, String numeClient, String telefonClient, String detaliiNota, String cnpClient, String serieAct) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.notaExemplare.size(); ++i) {
            String platiS;
            String exemplar = (String)this.notaExemplare.elementAt(i);
            String s = this.getLogoCommand();
            s = s + this.getNotaStartFontSelection() + this.getStartOfNota();
            if (Validators.correctString(this.header)) {
                s = s + "\n" + this.center(this.header, this.charsPerLine, ' ') + "\n\n";
            }
            String titleLine = this.getTitleStartFontSelection() + this.center(this.entity, this.charsPerLine, ' ') + this.getTitleStopFontSelection();
            s = s + titleLine + "\n" + Utils.getStringMaxSize(this.charsPerLine, "", Character.valueOf('-'), false) + "\n";
            s = s + this.getExemplarString(exemplar);
            s = s + this.getNotaString(nrNota);
            String data = Formatters.currentDateAndTimeForPrinter.format(new Date());
            s = s + Utils.arrange(data, "", this.charsPerLine, ' ') + "\n";
            s = s + Utils.arrange(table, "", this.charsPerLine, ' ') + "\n";
            s = s + Utils.arrange(waiter, "", this.charsPerLine, ' ') + "\n\n";
            Hashtable<String, PrinterSalesTotalPerSectie> totalsPerSectie = new Hashtable<String, PrinterSalesTotalPerSectie>();
            Hashtable<String, Vector<PrinterSale>> salesPeSectie = new Hashtable<String, Vector<PrinterSale>>();
            if (VpConfig.getInstance().separareProdPeSectieNotaPlata) {
                for (PrinterSale sale : sales) {
                    String sectieCurenta = sale.getSectie();
                    PrinterSalesTotalPerSectie totalPerSectieCurenta = (PrinterSalesTotalPerSectie)totalsPerSectie.get(sectieCurenta);
                    if (totalPerSectieCurenta == null) {
                        totalPerSectieCurenta = new PrinterSalesTotalPerSectie();
                        totalPerSectieCurenta.setNumeSectie(sectieCurenta);
                        totalsPerSectie.put(sectieCurenta, totalPerSectieCurenta);
                    }
                    totalPerSectieCurenta.addCantitate(Integer.valueOf(sale.getQuantity()));
                    totalPerSectieCurenta.addValoare(Double.valueOf(sale.getValue()));
                    Vector<PrinterSale> salesPerSectieCurenta = (Vector<PrinterSale>)salesPeSectie.get(sectieCurenta);
                    if (salesPerSectieCurenta == null) {
                        salesPerSectieCurenta = new Vector<PrinterSale>();
                        salesPeSectie.put(sectieCurenta, salesPerSectieCurenta);
                    }
                    salesPerSectieCurenta.add(sale);
                }
                for (PrinterSalesTotalPerSectie ps : totalsPerSectie.values()) {
                    s = s + Utils.arrange("Sectie: " + ps.getNumeSectie(), " Produse " + ps.getNumarProduse(), this.charsPerLine, ' ') + "\n";
                    s = s + Utils.arrange("", "", this.charsPerLine, '-') + "\n";
                    Vector printerSales = (Vector)salesPeSectie.get(ps.getNumeSectie());
                    for (PrinterSale element : printerSales) {
                        if (this.notaSaleOnOneLine) {
                            s = s + this.getSale1Line(element);
                            continue;
                        }
                        s = s + this.getSale2Lines(element);
                    }
                    s = s + Utils.arrange("", "TOTAL Sectie : " + ps.getTotalPeSectie(), this.charsPerLine, '-') + "\n\n";
                }
            } else {
                for (PrinterSale element : sales) {
                    if (this.notaSaleOnOneLine) {
                        s = s + this.getSale1Line(element);
                        continue;
                    }
                    s = s + this.getSale2Lines(element);
                }
            }
            s = s + "\n";
            s = s + this.getTotalStartFontSelection() + Utils.arrange("TOTAL", total, this.getTallFontCharsPerLine(), ' ') + this.getTotalStopFontSelection();
            if (discount != null) {
                s = s + "\n";
                String discountName = "DISCOUNT" + promoName;
                if (protocol) {
                    discountName = discountName + " PROTOCOL";
                }
                s = s + this.getTotalStartFontSelection() + Utils.arrange(discountName + " ", discount, this.getTallFontCharsPerLine(), ' ') + this.getTotalStopFontSelection();
                s = s + "\n";
                s = s + this.getTotalStartFontSelection() + Utils.arrange("TOTAL", totalDupaDiscount, this.getTallFontCharsPerLine(), ' ') + this.getTotalStopFontSelection();
            }
            if (Validators.correctDouble(tva)) {
                s = s + "\n";
                s = s + Utils.arrange("din care TVA", tva, this.charsPerLine, ' ');
            }
            if (Validators.correctString(platiS = PrintLogic.getInstance().getPlatiString(plati))) {
                s = s + "\n\nMod plata:\n" + platiS + "\n";
            }
            if (Validators.correctString(numeClient)) {
                s = s + "\n\nClient: " + numeClient + "\n";
            }
            if (Validators.correctString(telefonClient)) {
                s = s + "\n\nTelefon: " + telefonClient + "\n";
            }
            if (Validators.correctString(adresaClient)) {
                s = s + "\n\nAdresa: " + adresaClient + "\n";
            }
            if (Validators.correctString(detaliiNota)) {
                s = s + "\n\nDetalii: " + detaliiNota + "\n";
            }
            s = s + "\n";
            s = s + Utils.getStringMaxSize(this.charsPerLine, "", Character.valueOf('-'), false) + "\n";
            s = s + titleLine + "\n";
            s = s + this.center(this.address, this.charsPerLine, ' ') + "\n";
            s = s + this.center(this.phone, this.charsPerLine, ' ') + "\n";
            if (Validators.correctString(this.footer)) {
                s = s + "\n";
                s = s + this.center(this.footer, this.charsPerLine, ' ') + "\n";
            }
            if (this.atreidesPromo) {
                s = s + "\n";
                s = s + this.center("soft by www.DeverSoft.ro", this.charsPerLine, ' ') + "\n";
            }
            s = s + this.feedNota();
            s = s + this.getNotaStopFontSelection();
            s = s + this.getAutocutterSequence();
            v.add(s);
        }
        this.printText(v, false);
    }

    public String getTotalStartFontSelection() {
        return "";
    }

    public String getTotalStopFontSelection() {
        return "";
    }

    @Override
    public boolean isPdfPrinter() {
        return false;
    }

    @Override
    public void printPVCustodie(String toPrint, int nrCopii) {
    }

    @Override
    public void printFactura(String toPrint, int nrCopii) {
    }

    @Override
    public void print2ColumnText(Vector pagini, boolean isRaport) {
        this.printText(pagini, isRaport);
    }

    @Override
    public void printBarcodeLabel(String barcode, String nume, String pretNormal, String pretRedus) {
    }

    @Override
    public void printBarcodeLot(Map<Constants.ETICHETA_LOT_FIELDS, String> map, int copies) {
    }
}

