/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.print.printers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ro.atreides.print.printers.AsciiPrinter;
import ro.atreides.print.tests.PrintUtilities;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;

public class GuiAsciiPrinter
extends AsciiPrinter {
    private Font font;

    public GuiAsciiPrinter() {
        String fontName = this.config.getString("guiAsciiPrinterFont");
        if (Validators.correctString(fontName)) {
            int fontSize = this.config.getInt("guiAsciiPrinterFontSize", 10);
            String fontType = this.config.getString("guiAsciiPrinterFontType", "normal");
            int style = 0;
            if (fontType.equalsIgnoreCase("bold")) {
                style = 1;
            } else if (fontType.equalsIgnoreCase("italic")) {
                style = 2;
            }
            this.font = new Font(fontName, style, fontSize);
        }
    }

    @Override
    public void printText(Vector pagini, boolean isRaport) {
        for (int i = 0; i < pagini.size(); ++i) {
            String pagina = (String)pagini.elementAt(i);
            JPanel panel = this.buildJPanelForPagina(pagina);
            panel.setVisible(true);
            panel.repaint();
            panel.validate();
            JDialog dia = DialogUtils.getJDialog(panel, GuiUtils.currentFrame, " ", 2.0);
            PrintUtilities.printComponent(this.attributeSet, this.printService, this.flavor, panel);
        }
    }

    private JPanel buildJPanelForPagina(String pagina) {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        Vector lines = Utils.splitString(pagina, '\n');
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.elementAt(i);
            JLabel label = new JLabel(line);
            if (this.font != null) {
                label.setFont(this.font);
            }
            result.add((Component)label, c);
            ++c.gridy;
        }
        c.weighty = 1.0;
        ++c.gridy;
        result.add((Component)new JLabel(""), c);
        result.setBackground(Color.WHITE);
        return result;
    }
}

