/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.print.printers;

import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import ro.atreides.print.DocumentXmlHandler;
import ro.atreides.print.PrintLogic;
import ro.atreides.print.PrinterBonItem;
import ro.atreides.print.PrinterSale;
import ro.atreides.print.printers.AsciiPrinter;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.multilang.LangRoAll;

public class NewAsciiPrinter
extends AsciiPrinter {
    public static final String ENTITY_NAME = "entityName";
    public static final String ADDRESS = "address";
    public static final String PHONE = "phone";
    public static final String DATA = "data";
    public static final String ORA = "ora";
    public static final String MASA = "masa";
    public static final String WAITER = "waiter";
    public static final String TOTAL_1 = "total1";
    public static final String TOTAL_2 = "total2";
    public static final String DISCOUNT = "discount";
    public static final String TVA = LangRoAll.tva;
    public static final String SOFT_BY = "softBy";
    public static final String NR_BON = "NrBon";
    public static final String EXEMPLAR = "exemplar";
    public static final String CLIENT_NAME = "client_name";
    public static final String CLIENT_PHONE = "client_phone";
    public static final String CLIENT_ADDRESS = "client_address";
    public static final String CLIENT_CNP = "client_cnp";
    public static final String CLIENT_SERIE_ACT = "client_act";
    public static final String DETALII_NOTA = "detalii_nota";
    public static final String PLATI = "plati";
    public static final String SOC_NAME = "SOC_NAME";
    public static final String SOC_CUI = "SOC_CUI";
    public static final String SOC_J = "SOC_J";
    public static final String SOC_ADRESA = "SOC_ADRESA";
    public static final String SOC_IBAN = "SOC_IBAN";
    public static final String SOC_BANCA = "SOC_BANCA";
    public static final String NR_BON_COMANDA = "NrBonComanda";
    public static final String TOTAL_BON_COMANDA = "TotalBonComanda";
    public static final String PROTOCOL_BON_COMANDA = "ProtocolBonComanda";
    public static final String CATEGORY_BON_COMANDA = "CategorieBonComanda";
    private int nrNota = 1;

    @Override
    public String getAutocutterSequence() {
        return "\u001dVB\u0000";
    }

    @Override
    public void printBonLivrare(Vector<PrinterBonItem> livrareItems, String ospatar, String table, String data1, double valoare) {
        String valoareS = Utils.getString2Decimals(valoare);
        try {
            SAXParser itemsReader = new SAXParser();
            DocumentXmlHandler lineHandler = new DocumentXmlHandler();
            itemsReader.setContentHandler(lineHandler);
            itemsReader.setErrorHandler(lineHandler);
            Hashtable<String, String> fields = new Hashtable<String, String>();
            Date d = new Date();
            String data = Formatters.DATE_FORMAT_RO.format(d);
            String ora = Formatters.TIME_FORMAT.format(d);
            fields.put(DATA, data);
            fields.put(ORA, ora);
            fields.put(WAITER, ospatar);
            fields.put(MASA, table);
            fields.put(TOTAL_BON_COMANDA, valoareS);
            String xmlFile = "conf/bon_livrare.txt";
            SAXParser r = new SAXParser();
            DocumentXmlHandler handler = new DocumentXmlHandler(fields, livrareItems, (XMLReader)itemsReader, lineHandler, "conf/bon_livrare_line.txt", this.getAutocutterSequence());
            r.setContentHandler(handler);
            r.setErrorHandler(handler);
            r.parse(xmlFile);
            String toPrint = handler.getText().toString();
            Logger.logDebug(this, "Printez \n" + toPrint + "\n");
            Vector<String> v = new Vector<String>();
            v.add(toPrint);
            this.printText(v, false);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (SAXException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String printBon(Vector<PrinterBonItem> bonItems, String waiter, boolean protocol, String nrBon, String table, String titluBon, int copii, String total, String detaliiLivrare1, boolean cutter, String adresaClient, String numeClient, String telefonClient) {
        try {
            SAXParser itemsReader = new SAXParser();
            DocumentXmlHandler lineHandler = new DocumentXmlHandler();
            itemsReader.setContentHandler(lineHandler);
            itemsReader.setErrorHandler(lineHandler);
            Hashtable<String, String> fields = new Hashtable<String, String>();
            Date d = new Date();
            String data = Formatters.DATE_FORMAT_RO.format(d);
            String ora = Formatters.TIME_FORMAT.format(d);
            fields.put(DATA, data);
            fields.put(ORA, ora);
            fields.put(WAITER, waiter);
            fields.put(MASA, table);
            fields.put(NR_BON_COMANDA, nrBon);
            fields.put(TOTAL_BON_COMANDA, total);
            fields.put(PROTOCOL_BON_COMANDA, protocol ? " PROTOCOL" : "");
            fields.put(CATEGORY_BON_COMANDA, titluBon);
            fields.put(CLIENT_NAME, numeClient);
            fields.put(CLIENT_ADDRESS, adresaClient);
            fields.put(CLIENT_PHONE, telefonClient);
            String xmlFile = "conf/bon.txt";
            SAXParser r = new SAXParser();
            DocumentXmlHandler handler = new DocumentXmlHandler(fields, bonItems, (XMLReader)itemsReader, lineHandler, "conf/bon_line.txt", this.getAutocutterSequence());
            r.setContentHandler(handler);
            r.setErrorHandler(handler);
            r.parse(xmlFile);
            String toPrint = handler.getText().toString();
            Logger.logDebug(this, "Printez \n" + toPrint + "\n");
            Vector<String> v = new Vector<String>();
            v.add(toPrint);
            this.printText(v, false);
            return toPrint;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (SAXException e) {
            Logger.logException(this, (Exception)e);
        }
        return "";
    }

    @Override
    public void printNota(Vector<PrinterSale> sales, String discount, String total, String totalDupaDiscount, String waiter, String table, boolean protocol, String tva, Vector plati, String promoName, int nrNota, String adresaClient, String numeClient, String telefonClient, String detaliiNota, String cnpClient, String serieAct) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.notaExemplare.size(); ++i) {
            String exemplar = (String)this.notaExemplare.elementAt(i);
            try {
                SAXParser itemsReader = new SAXParser();
                DocumentXmlHandler lineHandler = new DocumentXmlHandler();
                itemsReader.setContentHandler(lineHandler);
                itemsReader.setErrorHandler(lineHandler);
                Hashtable<String, String> fields = new Hashtable<String, String>();
                fields.put(ENTITY_NAME, this.entity);
                fields.put(ADDRESS, this.address);
                fields.put(PHONE, this.phone);
                Date d = new Date();
                String data = Formatters.DATE_FORMAT_RO.format(d);
                String ora = Formatters.TIME_FORMAT.format(d);
                fields.put(DATA, data);
                fields.put(ORA, ora);
                fields.put(WAITER, waiter);
                fields.put(MASA, table);
                fields.put(TOTAL_1, total);
                fields.put(NR_BON, nrNota + "");
                fields.put(CLIENT_NAME, numeClient);
                fields.put(CLIENT_ADDRESS, adresaClient);
                fields.put(CLIENT_PHONE, telefonClient);
                fields.put(CLIENT_CNP, cnpClient);
                fields.put(CLIENT_SERIE_ACT, serieAct);
                fields.put(DETALII_NOTA, detaliiNota);
                String platiS = PrintLogic.getInstance().getPlatiString(plati);
                fields.put(PLATI, platiS);
                fields.put(SOC_NAME, Config.getInstance().getString("societate"));
                fields.put(SOC_CUI, Config.getInstance().getString("cui"));
                fields.put(SOC_J, Config.getInstance().getString("j"));
                fields.put(SOC_ADRESA, Config.getInstance().getString(ADDRESS));
                fields.put(SOC_BANCA, Config.getInstance().getString("banca"));
                fields.put(SOC_IBAN, Config.getInstance().getString("iban"));
                if (Validators.correctString(discount)) {
                    fields.put(DISCOUNT, "DISCOUNT" + promoName + ": " + discount);
                    fields.put(TOTAL_2, "TOTAL: " + totalDupaDiscount);
                }
                if (Validators.correctString(tva)) {
                    fields.put(TVA, tva);
                }
                if (this.atreidesPromo) {
                    fields.put(SOFT_BY, "soft by www.DeverSoft.ro");
                }
                if (Validators.correctString(exemplar)) {
                    fields.put(EXEMPLAR, exemplar);
                } else {
                    fields.put(EXEMPLAR, "");
                }
                String xmlFile = "conf/nota.txt";
                SAXParser r = new SAXParser();
                DocumentXmlHandler handler = new DocumentXmlHandler(fields, sales, (XMLReader)itemsReader, lineHandler, "conf/nota_line.txt", this.getAutocutterSequence());
                r.setContentHandler(handler);
                r.setErrorHandler(handler);
                r.parse(xmlFile);
                String toPrint = handler.getText().toString();
                Logger.logDebug(this, "Printez \n" + toPrint + "\n");
                v.add(toPrint);
                continue;
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
                continue;
            }
            catch (SAXException e) {
                Logger.logException(this, (Exception)e);
            }
        }
        this.printText(v, false);
    }
}

