/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.print.printers;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.render.Renderer;
import org.xml.sax.InputSource;
import ro.atreides.print.AbstractPrinter;
import ro.atreides.print.PrintLogic;
import ro.atreides.print.PrinterBonItem;
import ro.atreides.print.PrinterSale;
import ro.atreides.print.printers.PrintRenderer;
import ro.atreides.utils.Constants;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ProguardKeepNames;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.multilang.LangRoAll;

public class PdfPrinter
extends AbstractPrinter
implements ProguardKeepNames {
    private String notaTemplate;
    private String notaEntryTemplate;
    private String wrapperTemplate;
    private String a4template;

    public PdfPrinter() {
        this.notaTemplate = this.config.getString("pdfNotaTemplate");
        this.notaEntryTemplate = this.config.getString("pdfNotaEntryTemplate");
        this.wrapperTemplate = this.config.getString("pdfWrapperTemplate");
        this.a4template = this.config.getString("a4template");
    }

    private String getProductLine(String inFile, String product, String ppu, String quantity, String total) throws IOException {
        String productEscaped = TextUtils.escapeForXML(product);
        String linie = FileUtils.readFileToString(inFile);
        linie = linie.replaceAll("%%product%%", productEscaped);
        if (ppu != null) {
            linie = linie.replaceAll("%%quantity_ppu%%", quantity);
            linie = linie.replaceAll("%%ppu%%", ppu);
            linie = linie.replaceAll("%%quantity%%", quantity);
        } else {
            linie = linie.replaceAll("%%quantity_ppu%%", "");
        }
        linie = linie.replaceAll("%%total%%", total);
        return linie + "\n";
    }

    private void printFop(String foFile, int exemplare) {
        for (int i = 0; i < exemplare; ++i) {
            try {
                InputSource source = new InputSource(new FileInputStream(foFile));
                Driver driver = new Driver(source, null);
                PrinterJob pj = PrinterJob.getPrinterJob();
                PrintRenderer renderer = new PrintRenderer(pj, this.printService);
                driver.setRenderer((Renderer)renderer);
                driver.run();
                continue;
            }
            catch (PrinterException e) {
                Logger.logException(this, (Exception)e);
                continue;
            }
            catch (FileNotFoundException e) {
                Logger.logException(this, (Exception)e);
                continue;
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
                continue;
            }
            catch (FOPException e) {
                Logger.logException(this, (Exception)((Object)e));
            }
        }
    }

    @Override
    public void printPdf(String pdfFile, int copii) {
        this.printFop(pdfFile, copii);
    }

    @Override
    public String printBon(Vector<PrinterBonItem> bonItems, String waiter, boolean protocol, String nrBon, String table, String titluBon, int copii, String total, String detaliiLivrare, boolean cutter, String adresaClient, String numeClient, String telefonClient) {
        boolean printValue = this.config.getBoolean("printBonValue");
        String s = titluBon + " " + nrBon + " " + table + (printValue ? " " + total : "") + "\n" + waiter + " " + Utils.getCurrentDateAndTimeForPrinter() + "\n";
        for (PrinterBonItem element : bonItems) {
            s = s + element.getProduct();
            if (printValue) {
                s = s + " =" + element.getValoare();
            }
            if (protocol) {
                s = s + " PROTOCOL";
            }
            s = s + "\n";
        }
        Vector<String> v = new Vector<String>();
        v.add(s);
        this.printText(v, false);
        return s;
    }

    @Override
    public void printBonLivrare(Vector<PrinterBonItem> livrareItems, String ospatar, String table, String data, double valoare) {
        boolean printValue = this.config.getBoolean("printBonValue");
        String s = "Livrare " + data + "\n" + ospatar + " " + table;
        if (printValue) {
            s = s + " Total= " + Utils.getString2Decimals(valoare);
        }
        s = s + "\n";
        for (PrinterBonItem item : livrareItems) {
            s = s + item.getQuantity() + "   " + item.getProduct();
            if (printValue) {
                s = s + " =" + item.getValoare();
            }
            s = s + "\n";
        }
        Vector<String> v = new Vector<String>();
        v.add(s);
        this.printText(v, false);
    }

    @Override
    public void printText(Vector pagini, boolean raport) {
        for (int i = 0; i < pagini.size(); ++i) {
            String text = (String)pagini.elementAt(i);
            try {
                String foFile = PrintLogic.wrapText(text, this.wrapperTemplate);
                String outFile = FileUtils.getTempDir() + File.separator + "bon.txt";
                FileWriter fw = new FileWriter(outFile);
                fw.write(foFile);
                fw.close();
                this.printFop(outFile, 1);
                continue;
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
            }
        }
    }

    @Override
    public void print2ColumnText(Vector pagini, boolean raport) {
        for (int i = 0; i < pagini.size(); ++i) {
            String text = (String)pagini.elementAt(i);
            try {
                String foFile = PrintLogic.wrapText(text, "wrapper_2columns.txt");
                String outFile = FileUtils.getTempDir() + File.separator + "bon.txt";
                FileWriter fw = new FileWriter(outFile);
                fw.write(foFile);
                fw.close();
                this.printFop(outFile, 1);
                continue;
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
            }
        }
    }

    public void printTextLandscape(String text, int copii) {
        try {
            String inFile = "conf" + File.separator + this.a4template;
            String foFile = FileUtils.readFileToString(inFile);
            foFile = foFile.replaceAll("%%content%%", text);
            String outFile = FileUtils.getTempDir() + File.separator + "landscape.txt";
            FileWriter fw = new FileWriter(outFile);
            fw.write(foFile);
            fw.close();
            this.printFop(outFile, copii);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void printNota(Vector<PrinterSale> sales, String discount, String total, String totalDupaDiscount, String waiter, String table, boolean protocol, String tva, Vector plati, String promoName, int nrNota, String adresaClient, String numeClient, String telefonClient, String detaliiNota, String cnpClient, String serieAct) {
        for (int i = 0; i < this.notaExemplare.size(); ++i) {
            String exemplar = (String)this.notaExemplare.elementAt(i);
            try {
                String inFile = "conf" + File.separator + this.notaTemplate;
                String inProductFile = "conf" + File.separator + this.notaEntryTemplate;
                String foFile = FileUtils.readFileToString(inFile);
                String productsText = "";
                for (PrinterSale newsaleentry : sales) {
                    if (newsaleentry.isEmptyLine()) {
                        productsText = productsText + this.getProductLine(inProductFile, "", "", "", "");
                        continue;
                    }
                    productsText = productsText + this.getProductLine(inProductFile, newsaleentry.getProduct(), newsaleentry.getPrice(), newsaleentry.getQuantity(), newsaleentry.getValue());
                }
                foFile = foFile.replaceAll("%%products%%", productsText);
                if (discount != null) {
                    String discountString = "DISCOUNT" + promoName;
                    if (protocol) {
                        discountString = discountString + " PROTOCOL";
                    }
                    foFile = foFile.replaceAll("%%discount_string%%", discountString);
                    foFile = foFile.replaceAll("%%discount_value%%", discount);
                    foFile = foFile.replaceAll("%%total1_value%%", total);
                    foFile = foFile.replaceAll("%%total1_string%%", "TOTAL");
                    foFile = foFile.replaceAll("%%total2_value%%", totalDupaDiscount);
                } else {
                    foFile = foFile.replaceAll("%%total1_string%%", " ");
                    foFile = foFile.replaceAll("%%total1_value%%", " ");
                    foFile = foFile.replaceAll("%%discount_string%%", " ");
                    foFile = foFile.replaceAll("%%discount_value%%", " ");
                    foFile = foFile.replaceAll("%%total2_value%%", total);
                }
                if (tva != null) {
                    foFile = foFile.replaceAll("%%tva%%", tva);
                    foFile = foFile.replaceAll("%%tva_string%%", LangRoAll.tva);
                } else {
                    foFile = foFile.replaceAll("%%tva%%", "");
                    foFile = foFile.replaceAll("%%tva_string%%", "");
                }
                foFile = foFile.replaceAll("%%entity%%", TextUtils.escapeForXML(this.entity));
                foFile = foFile.replaceAll("%%phone%%", TextUtils.escapeForXML(this.phone));
                foFile = foFile.replaceAll("%%address%%", TextUtils.escapeForXML(this.address));
                foFile = foFile.replaceAll("%%date%%", Formatters.currentDateAndTimeForPrinter.format(new Date()));
                foFile = foFile.replaceAll("%%waiter%%", TextUtils.escapeForXML(waiter));
                foFile = foFile.replaceAll("%%table%%", TextUtils.escapeForXML(table));
                foFile = Validators.correctString(adresaClient) ? foFile.replaceAll("%%adresa_client%%", TextUtils.escapeForXML(adresaClient)) : foFile.replaceAll("%%adresa_client%%", "");
                foFile = Validators.correctString(numeClient) ? foFile.replaceAll("%%nume_client%%", TextUtils.escapeForXML(numeClient)) : foFile.replaceAll("%%nume_client%%", "");
                foFile = Validators.correctString(cnpClient) ? foFile.replaceAll("%%cnp_client%%", TextUtils.escapeForXML(cnpClient)) : foFile.replaceAll("%%cnp_client%%", "");
                foFile = Validators.correctString(serieAct) ? foFile.replaceAll("%%act_client%%", TextUtils.escapeForXML(serieAct)) : foFile.replaceAll("%%act_client%%", "");
                foFile = Validators.correctString(telefonClient) ? foFile.replaceAll("%%telefon_client%%", TextUtils.escapeForXML(telefonClient)) : foFile.replaceAll("%%telefon_client%%", "");
                foFile = Validators.correctString(detaliiNota) ? foFile.replaceAll("%%detalii_nota%%", TextUtils.escapeForXML("Detalii: " + detaliiNota)) : foFile.replaceAll("%%detalii_nota%%", "");
                foFile = foFile.replaceAll("%%exemplar%%", exemplar);
                String platiS = PrintLogic.getInstance().getPlatiString(plati);
                if (Validators.correctString(platiS)) {
                    platiS = platiS.replaceAll("\n", ", ");
                    foFile = foFile.replaceAll("%%plati%%", platiS);
                } else {
                    foFile = foFile.replaceAll("%%plati%%", "");
                }
                String outFile = FileUtils.getTempDir() + File.separator + "nota.txt";
                FileWriter fw = new FileWriter(outFile);
                fw.write(foFile);
                fw.close();
                this.printFop(outFile, 1);
                continue;
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
            }
        }
    }

    @Override
    public boolean isPdfPrinter() {
        return true;
    }

    @Override
    public void printFactura(String toPrint, int nrCopii) {
        this.printPdf(toPrint, nrCopii);
    }

    @Override
    public void printPVCustodie(String toPrint, int nrCopii) {
        this.printPdf(toPrint, nrCopii);
    }

    @Override
    public void printBarcodeLabel(String barcode, String nume, String pretNormal, String pretRedus) {
    }

    @Override
    public void printBarcodeLot(Map<Constants.ETICHETA_LOT_FIELDS, String> map, int copies) {
    }
}

