/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.print.printers.datecs;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import ro.atreides.print.PrinterBonItem;
import ro.atreides.print.printers.AsciiPrinter;
import ro.atreides.print.printers.datecs.LP50Product;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public class LP50
extends AsciiPrinter {
    protected String bonFont;

    @Override
    protected String getAutocutterSequence() {
        return "";
    }

    @Override
    protected String getBonStartFontSelection() {
        return "";
    }

    private Vector getRightLines(Vector bonItems, String adresa, int productLines, int adresaLines, int charsPerLine) {
        Vector<LP50Product> r = new Vector<LP50Product>();
        for (int i = 0; i < bonItems.size(); ++i) {
            PrinterBonItem pbi = (PrinterBonItem)bonItems.elementAt(i);
            String s = pbi.getProduct();
            if ((s = s.trim()).length() > charsPerLine) {
                String line1 = s.substring(0, charsPerLine);
                int min = Math.min(s.length(), 2 * charsPerLine);
                String line2 = s.substring(charsPerLine, min);
                line2 = "  " + line2;
                min = Math.min(line2.length(), charsPerLine);
                line2 = line2.substring(0, min);
                LP50Product lp = new LP50Product();
                lp.setLine1(line1);
                lp.setLine2(line2);
                r.add(lp);
            }
            if (s.length() > charsPerLine || s.length() <= 0) continue;
            int min = Math.min(s.length(), charsPerLine);
            String line1 = s.substring(0, min);
            LP50Product lp = new LP50Product();
            lp.setLine1(line1);
            r.add(lp);
        }
        Vector<String> lines = new Vector<String>();
        int spaceLeft = productLines;
        for (int i = 0; i < r.size(); ++i) {
            int j;
            LP50Product lp50Product = (LP50Product)r.elementAt(i);
            boolean twoLines = false;
            if (lp50Product.getLine2() != null) {
                twoLines = true;
            }
            int spaceNeeded = 1;
            if (twoLines) {
                spaceNeeded = 2;
            }
            if (spaceNeeded <= spaceLeft) {
                lines.add(lp50Product.getLine1());
                if (twoLines) {
                    lines.add(lp50Product.getLine2());
                }
                spaceLeft -= spaceNeeded;
            }
            if (spaceNeeded <= spaceLeft && i != r.size() - 1) continue;
            for (j = 0; j < spaceLeft; ++j) {
                lines.add(" ");
            }
            for (j = 0; j < adresaLines; ++j) {
                int start = j * charsPerLine;
                int stop = Math.min((start + 1) * charsPerLine, adresa.length());
                String currentLine = " ";
                if (stop <= adresa.length() && stop > start) {
                    currentLine = adresa.substring(start, stop);
                }
                lines.add(currentLine);
            }
            spaceLeft = productLines;
        }
        return lines;
    }

    @Override
    public String printBon(Vector<PrinterBonItem> bonItems, String waiter, boolean protocol, String nrBon, String table, String titluBon, int copii, String total, String detaliiLivrare, boolean cutter, String adresaClient, String numeClient, String telefonClient) {
        detaliiLivrare = detaliiLivrare.trim();
        Map parentCategories = Collections.synchronizedMap(new LinkedHashMap());
        int lastParentCat = -1;
        for (PrinterBonItem bonItem : bonItems) {
            int idCurrentCat = bonItem.getIdCategory();
            Vector<Integer> idParentCat = bonItem.getIdParentCategory();
            boolean addedAsEmbedded = false;
            if (idParentCat != null && idParentCat.size() > 0) {
                int correctIdParentCatId = -1;
                for (Integer idParentCatId : idParentCat) {
                    if (idParentCatId != lastParentCat) continue;
                    correctIdParentCatId = lastParentCat;
                    break;
                }
                if (correctIdParentCatId != -1) {
                    Vector parentCats = (Vector)parentCategories.get(correctIdParentCatId);
                    PrinterBonItem parent = (PrinterBonItem)parentCats.get(parentCats.size() - 1);
                    parent.addEmbeddedProduct(bonItem);
                    parent.setValoare(Utils.getString2Decimals(Utils.parseDouble(parent.getValoare()) + Utils.parseDouble(bonItem.getValoare())));
                    addedAsEmbedded = true;
                }
            }
            if (addedAsEmbedded) continue;
            Vector<PrinterBonItem> brothers = (Vector<PrinterBonItem>)parentCategories.get(idCurrentCat);
            if (brothers == null) {
                brothers = new Vector<PrinterBonItem>();
                parentCategories.put(idCurrentCat, brothers);
                lastParentCat = idCurrentCat;
            }
            brothers.add(bonItem);
        }
        Vector mainProducts = new Vector();
        for (Vector printerBonItems : parentCategories.values()) {
            mainProducts.addAll(printerBonItems);
        }
        int i = 1;
        int embeddedLinesPerPage = 2;
        for (PrinterBonItem bonItem : mainProducts) {
            Vector<String> embeddedLines = this.getEmbeddedProductLines(bonItem, 19, embeddedLinesPerPage, ".");
            int page = 0;
            while (embeddedLines.size() > embeddedLinesPerPage * page) {
                try {
                    String file = FileUtils.readFileToString("conf/bon_lp50.txt");
                    file = file.replaceAll("%%adresa%%", adresaClient + " " + detaliiLivrare);
                    String detaliiProdus = " ";
                    if (Validators.correctString(bonItem.getDetalii())) {
                        detaliiProdus = bonItem.getDetalii();
                    }
                    file = file.replaceAll("%%linieprodus4%%", detaliiProdus);
                    if (page == 0) {
                        String q = bonItem.getQuantity();
                        q = this.stripProductName(q);
                        String p = bonItem.getProduct();
                        p = this.stripProductName(p);
                        if (Validators.correctString(q)) {
                            p = q + " " + p;
                        }
                        file = file.replaceAll("%%linieprodus1%%", p);
                    } else {
                        file = file.replaceAll("%%linieprodus1%%", "CONTINUARE - pag " + (page + 1) + " !!");
                    }
                    String count = "" + i + " / " + mainProducts.size();
                    file = file.replaceAll("%%telefon%%", telefonClient + " : " + count);
                    file = file.replaceAll("%%total%%", "Pret=" + bonItem.getValoare() + " TOTAL=" + total);
                    file = file.replaceAll("%%idcomanda%%", nrBon);
                    file = file.replaceAll("%%linieprodus3%%", embeddedLines.get(embeddedLinesPerPage * page));
                    file = file.replaceAll("%%linieprodus2%%", embeddedLines.get(embeddedLinesPerPage * page + 1));
                    final Vector<String> v = new Vector<String>();
                    v.add(file);
                    new Thread(){

                        @Override
                        public void run() {
                            for (int i = 0; i < v.size(); ++i) {
                                String page = (String)v.elementAt(i);
                                Vector<String> v1 = new Vector<String>();
                                v1.add(page);
                                LP50.this.printText(v1, false);
                                try {
                                    Thread.sleep(1000L);
                                    continue;
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                            }
                        }
                    }.start();
                }
                catch (IOException e) {
                    Logger.logException(this, (Exception)e);
                }
                ++page;
            }
            ++i;
        }
        return "";
    }

    private Vector<String> getEmbeddedProductLines(PrinterBonItem parentItem, int maxLength, int minimumLinesPerPage, String defaultString) {
        Vector<String> result = new Vector<String>();
        String currentLine = null;
        for (PrinterBonItem bonItem : parentItem.getEmbeddedProducts()) {
            String name = bonItem.getProduct().trim();
            if (currentLine == null) {
                currentLine = name;
                result.add(currentLine);
                continue;
            }
            if (currentLine.length() + 1 + name.length() > maxLength) {
                currentLine = name;
                result.add(currentLine);
                continue;
            }
            currentLine = currentLine + "," + name;
        }
        int pageCount = result.size() / minimumLinesPerPage;
        if (pageCount == 0) {
            pageCount = 1;
        } else if (result.size() % minimumLinesPerPage != 0) {
            ++pageCount;
        }
        if (result.size() < minimumLinesPerPage * pageCount) {
            for (int i = result.size(); i < minimumLinesPerPage * pageCount; ++i) {
                String line = defaultString;
                result.add(line);
            }
        }
        return result;
    }

    private String stripProductName(String name) {
        String s = name.trim();
        s = s.replaceAll("/", "");
        s = s.replaceAll("\\|", "");
        s = s.replaceAll("\\\\", "");
        s = s.trim();
        return s;
    }

    @Override
    protected String getBonStopFontSelection() {
        String s = "";
        return s;
    }

    @Override
    public String getTotalStartFontSelection() {
        return "";
    }

    @Override
    public String getTotalStopFontSelection() {
        return "";
    }
}

