/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.print.printers.epson;

import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import ro.atreides.print.DocumentXmlHandler;
import ro.atreides.print.PrinterBonItem;
import ro.atreides.print.printers.AsciiPrinter;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.gui.Validators;

public class NewTMU220
extends AsciiPrinter {
    protected String bonFont;
    protected String titleFont;
    public static final String NR_BON_COMANDA = "NrBonComanda";
    public static final String TOTAL_BON_COMANDA = "TotalBonComanda";
    public static final String PROTOCOL_BON_COMANDA = "ProtocolBonComanda";
    public static final String CATEGORY_BON_COMANDA = "CategorieBonComanda";
    public static final String DATA = "data";
    public static final String ORA = "ora";
    public static final String MASA = "masa";
    public static final String WAITER = "waiter";

    public NewTMU220() {
        this.bonFont = this.config.getString("bonFont");
        this.titleFont = this.config.getString("titleFont");
        if (!Validators.correctString(this.bonFont)) {
            this.bonFont = "normal";
        }
        if (!Validators.correctString(this.titleFont)) {
            this.titleFont = "normal";
        }
    }

    @Override
    protected String getTitleStartFontSelection() {
        if (this.titleFont.equalsIgnoreCase("tall")) {
            return "\u001b!\u0010";
        }
        return "";
    }

    @Override
    public String getTitleStopFontSelection() {
        if (this.titleFont.equalsIgnoreCase("tall")) {
            return "\u001b!\u0001";
        }
        return "";
    }

    @Override
    protected String getBonStartFontSelection() {
        int x = 0;
        if (this.bonFont.equalsIgnoreCase("tall")) {
            x = 16;
        } else if (this.bonFont.equalsIgnoreCase("wide")) {
            x = 32;
        } else if (this.bonFont.equalsIgnoreCase("double")) {
            x = 48;
        }
        if (x != 0) {
            return "\u001b!" + (char)x;
        }
        return "";
    }

    @Override
    public String getAutocutterSequence() {
        String s = "\u001dVB\u0000";
        return s;
    }

    @Override
    public String getBonStopFontSelection() {
        int x = 0;
        if (this.bonFont.equalsIgnoreCase("tall")) {
            x = 16;
        } else if (this.bonFont.equalsIgnoreCase("wide")) {
            x = 32;
        } else if (this.bonFont.equalsIgnoreCase("double")) {
            x = 48;
        }
        if (x != 0) {
            return "\u001b!\u0001";
        }
        return "";
    }

    @Override
    public String getTotalStartFontSelection() {
        int x = 16;
        return "\u001b!" + (char)x;
    }

    @Override
    public String getTotalStopFontSelection() {
        return "\u001b!\u0001";
    }

    @Override
    public int getTallFontCharsPerLine() {
        return 33;
    }

    public String printBon(Vector<PrinterBonItem> bonItems, String waiter, boolean protocol, String nrBon, String table, String titluBon, int copii, String total, String detaliiLivrare, boolean cutter) {
        try {
            SAXParser itemsReader = new SAXParser();
            DocumentXmlHandler lineHandler = new DocumentXmlHandler();
            itemsReader.setContentHandler(lineHandler);
            itemsReader.setErrorHandler(lineHandler);
            Hashtable<String, String> fields = new Hashtable<String, String>();
            Date d = new Date();
            String data = Formatters.DATE_FORMAT_RO.format(d);
            String ora = Formatters.TIME_FORMAT.format(d);
            fields.put(DATA, data);
            fields.put(ORA, ora);
            fields.put(WAITER, waiter);
            fields.put(MASA, table);
            fields.put(NR_BON_COMANDA, nrBon);
            fields.put(TOTAL_BON_COMANDA, total);
            fields.put(PROTOCOL_BON_COMANDA, protocol ? " PROTOCOL" : "");
            fields.put(CATEGORY_BON_COMANDA, titluBon);
            String xmlFile = "conf/bon2.txt";
            SAXParser r = new SAXParser();
            DocumentXmlHandler handler = new DocumentXmlHandler(fields, bonItems, (XMLReader)itemsReader, lineHandler, "conf/bon_line2.txt", this.getAutocutterSequence());
            r.setContentHandler(handler);
            r.setErrorHandler(handler);
            r.parse(xmlFile);
            String toPrint = handler.getText().toString();
            toPrint = this.getBonStartFontSelection() + toPrint + this.getBonStopFontSelection();
            Logger.logDebug(this, "Printez \n" + toPrint + "\n");
            Vector<String> v = new Vector<String>();
            v.add(toPrint);
            this.printText(v, false);
            return toPrint;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (SAXException e) {
            Logger.logException(this, (Exception)e);
        }
        return "";
    }
}

